/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsResponse;

public class ListActionConnectorsPublisher
implements SdkPublisher<ListActionConnectorsResponse> {
    private final QuickSightAsyncClient client;
    private final ListActionConnectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActionConnectorsPublisher(QuickSightAsyncClient client, ListActionConnectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActionConnectorsPublisher(QuickSightAsyncClient client, ListActionConnectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActionConnectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActionConnectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionConnectorSummary> actionConnectorSummaries() {
        return this.flatMapIterable(response -> response.actionConnectorSummaries());
    }

    private class ListActionConnectorsResponseFetcher
    implements AsyncPageFetcher<ListActionConnectorsResponse> {
        private ListActionConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActionConnectorsResponse> nextPage(ListActionConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListActionConnectorsPublisher.this.client.listActionConnectors(ListActionConnectorsPublisher.this.firstRequest);
            }
            return ListActionConnectorsPublisher.this.client.listActionConnectors((ListActionConnectorsRequest)((Object)ListActionConnectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

