/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssetBundleImportJobResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, StartAssetBundleImportJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StartAssetBundleImportJobResponse.getter(StartAssetBundleImportJobResponse::arn)).setter(StartAssetBundleImportJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleImportJobId").getter(StartAssetBundleImportJobResponse.getter(StartAssetBundleImportJobResponse::assetBundleImportJobId)).setter(StartAssetBundleImportJobResponse.setter(Builder::assetBundleImportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(StartAssetBundleImportJobResponse.getter(StartAssetBundleImportJobResponse::requestId)).setter(StartAssetBundleImportJobResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(StartAssetBundleImportJobResponse.getter(StartAssetBundleImportJobResponse::status)).setter(StartAssetBundleImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAssetBundleImportJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String assetBundleImportJobId;
    private final String requestId;
    private final Integer status;

    private StartAssetBundleImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String assetBundleImportJobId() {
        return this.assetBundleImportJobId;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleImportJobResponse)) {
            return false;
        }
        StartAssetBundleImportJobResponse other = (StartAssetBundleImportJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.assetBundleImportJobId(), other.assetBundleImportJobId()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"StartAssetBundleImportJobResponse").add("Arn", (Object)this.arn()).add("AssetBundleImportJobId", (Object)this.assetBundleImportJobId()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssetBundleImportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportJobId()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AssetBundleImportJobId", ASSET_BUNDLE_IMPORT_JOB_ID_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleImportJobResponse, T> g) {
        return obj -> g.apply((StartAssetBundleImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String assetBundleImportJobId;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleImportJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.assetBundleImportJobId(model.assetBundleImportJobId);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return this.assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public StartAssetBundleImportJobResponse build() {
            return new StartAssetBundleImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssetBundleImportJobResponse> {
        public Builder arn(String var1);

        public Builder assetBundleImportJobId(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

