/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SheetLayoutGroupMember;
import software.amazon.awssdk.services.quicksight.model.SheetLayoutGroupMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetLayoutGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetLayoutGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(SheetLayoutGroup.getter(SheetLayoutGroup::id)).setter(SheetLayoutGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<SheetLayoutGroupMember>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(SheetLayoutGroup.getter(SheetLayoutGroup::members)).setter(SheetLayoutGroup.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetLayoutGroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SheetLayoutGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<SheetLayoutGroupMember> members;

    private SheetLayoutGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.members = builder.members;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<SheetLayoutGroupMember> members() {
        return this.members;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetLayoutGroup)) {
            return false;
        }
        SheetLayoutGroup other = (SheetLayoutGroup)obj;
        return Objects.equals(this.id(), other.id()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members());
    }

    public final String toString() {
        return ToString.builder((String)"SheetLayoutGroup").add("Id", (Object)this.id()).add("Members", this.hasMembers() ? this.members() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Members", MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetLayoutGroup, T> g) {
        return obj -> g.apply((SheetLayoutGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<SheetLayoutGroupMember> members = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SheetLayoutGroup model) {
            this.id(model.id);
            this.members(model.members);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SheetLayoutGroupMember.Builder> getMembers() {
            List<SheetLayoutGroupMember.Builder> result = SheetLayoutGroupMemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<SheetLayoutGroupMember.BuilderImpl> members) {
            this.members = SheetLayoutGroupMemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<SheetLayoutGroupMember> members) {
            this.members = SheetLayoutGroupMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(SheetLayoutGroupMember ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<SheetLayoutGroupMember.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (SheetLayoutGroupMember)((SheetLayoutGroupMember.Builder)SheetLayoutGroupMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SheetLayoutGroup build() {
            return new SheetLayoutGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetLayoutGroup> {
        public Builder id(String var1);

        public Builder members(Collection<SheetLayoutGroupMember> var1);

        public Builder members(SheetLayoutGroupMember ... var1);

        public Builder members(Consumer<SheetLayoutGroupMember.Builder> ... var1);
    }
}

