/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SelfUpgradeRequestStatus;
import software.amazon.awssdk.services.quicksight.model.UserRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelfUpgradeRequestDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelfUpgradeRequestDetail> {
    private static final SdkField<String> UPGRADE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeRequestId").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::upgradeRequestId)).setter(SelfUpgradeRequestDetail.setter(Builder::upgradeRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeRequestId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::userName)).setter(SelfUpgradeRequestDetail.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> ORIGINAL_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalRole").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::originalRoleAsString)).setter(SelfUpgradeRequestDetail.setter(Builder::originalRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalRole").build()}).build();
    private static final SdkField<String> REQUESTED_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedRole").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::requestedRoleAsString)).setter(SelfUpgradeRequestDetail.setter(Builder::requestedRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedRole").build()}).build();
    private static final SdkField<String> REQUEST_NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestNote").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::requestNote)).setter(SelfUpgradeRequestDetail.setter(Builder::requestNote)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestNote").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTime").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::creationTime)).setter(SelfUpgradeRequestDetail.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestStatus").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::requestStatusAsString)).setter(SelfUpgradeRequestDetail.setter(Builder::requestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestStatus").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_ATTEMPT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdateAttemptTime").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::lastUpdateAttemptTime)).setter(SelfUpgradeRequestDetail.setter(Builder::lastUpdateAttemptTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateAttemptTime").build()}).build();
    private static final SdkField<String> LAST_UPDATE_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateFailureReason").getter(SelfUpgradeRequestDetail.getter(SelfUpgradeRequestDetail::lastUpdateFailureReason)).setter(SelfUpgradeRequestDetail.setter(Builder::lastUpdateFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateFailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_REQUEST_ID_FIELD, USER_NAME_FIELD, ORIGINAL_ROLE_FIELD, REQUESTED_ROLE_FIELD, REQUEST_NOTE_FIELD, CREATION_TIME_FIELD, REQUEST_STATUS_FIELD, LAST_UPDATE_ATTEMPT_TIME_FIELD, LAST_UPDATE_FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SelfUpgradeRequestDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String upgradeRequestId;
    private final String userName;
    private final String originalRole;
    private final String requestedRole;
    private final String requestNote;
    private final Long creationTime;
    private final String requestStatus;
    private final Long lastUpdateAttemptTime;
    private final String lastUpdateFailureReason;

    private SelfUpgradeRequestDetail(BuilderImpl builder) {
        this.upgradeRequestId = builder.upgradeRequestId;
        this.userName = builder.userName;
        this.originalRole = builder.originalRole;
        this.requestedRole = builder.requestedRole;
        this.requestNote = builder.requestNote;
        this.creationTime = builder.creationTime;
        this.requestStatus = builder.requestStatus;
        this.lastUpdateAttemptTime = builder.lastUpdateAttemptTime;
        this.lastUpdateFailureReason = builder.lastUpdateFailureReason;
    }

    public final String upgradeRequestId() {
        return this.upgradeRequestId;
    }

    public final String userName() {
        return this.userName;
    }

    public final UserRole originalRole() {
        return UserRole.fromValue(this.originalRole);
    }

    public final String originalRoleAsString() {
        return this.originalRole;
    }

    public final UserRole requestedRole() {
        return UserRole.fromValue(this.requestedRole);
    }

    public final String requestedRoleAsString() {
        return this.requestedRole;
    }

    public final String requestNote() {
        return this.requestNote;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final SelfUpgradeRequestStatus requestStatus() {
        return SelfUpgradeRequestStatus.fromValue(this.requestStatus);
    }

    public final String requestStatusAsString() {
        return this.requestStatus;
    }

    public final Long lastUpdateAttemptTime() {
        return this.lastUpdateAttemptTime;
    }

    public final String lastUpdateFailureReason() {
        return this.lastUpdateFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestNote());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateFailureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfUpgradeRequestDetail)) {
            return false;
        }
        SelfUpgradeRequestDetail other = (SelfUpgradeRequestDetail)obj;
        return Objects.equals(this.upgradeRequestId(), other.upgradeRequestId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.originalRoleAsString(), other.originalRoleAsString()) && Objects.equals(this.requestedRoleAsString(), other.requestedRoleAsString()) && Objects.equals(this.requestNote(), other.requestNote()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.requestStatusAsString(), other.requestStatusAsString()) && Objects.equals(this.lastUpdateAttemptTime(), other.lastUpdateAttemptTime()) && Objects.equals(this.lastUpdateFailureReason(), other.lastUpdateFailureReason());
    }

    public final String toString() {
        return ToString.builder((String)"SelfUpgradeRequestDetail").add("UpgradeRequestId", (Object)this.upgradeRequestId()).add("UserName", (Object)this.userName()).add("OriginalRole", (Object)this.originalRoleAsString()).add("RequestedRole", (Object)this.requestedRoleAsString()).add("RequestNote", (Object)this.requestNote()).add("CreationTime", (Object)this.creationTime()).add("RequestStatus", (Object)this.requestStatusAsString()).add("LastUpdateAttemptTime", (Object)this.lastUpdateAttemptTime()).add("LastUpdateFailureReason", (Object)this.lastUpdateFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeRequestId": {
                return Optional.ofNullable(clazz.cast(this.upgradeRequestId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "OriginalRole": {
                return Optional.ofNullable(clazz.cast(this.originalRoleAsString()));
            }
            case "RequestedRole": {
                return Optional.ofNullable(clazz.cast(this.requestedRoleAsString()));
            }
            case "RequestNote": {
                return Optional.ofNullable(clazz.cast(this.requestNote()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "RequestStatus": {
                return Optional.ofNullable(clazz.cast(this.requestStatusAsString()));
            }
            case "lastUpdateAttemptTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateAttemptTime()));
            }
            case "lastUpdateFailureReason": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateFailureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UpgradeRequestId", UPGRADE_REQUEST_ID_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("OriginalRole", ORIGINAL_ROLE_FIELD);
        map.put("RequestedRole", REQUESTED_ROLE_FIELD);
        map.put("RequestNote", REQUEST_NOTE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("RequestStatus", REQUEST_STATUS_FIELD);
        map.put("lastUpdateAttemptTime", LAST_UPDATE_ATTEMPT_TIME_FIELD);
        map.put("lastUpdateFailureReason", LAST_UPDATE_FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfUpgradeRequestDetail, T> g) {
        return obj -> g.apply((SelfUpgradeRequestDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String upgradeRequestId;
        private String userName;
        private String originalRole;
        private String requestedRole;
        private String requestNote;
        private Long creationTime;
        private String requestStatus;
        private Long lastUpdateAttemptTime;
        private String lastUpdateFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfUpgradeRequestDetail model) {
            this.upgradeRequestId(model.upgradeRequestId);
            this.userName(model.userName);
            this.originalRole(model.originalRole);
            this.requestedRole(model.requestedRole);
            this.requestNote(model.requestNote);
            this.creationTime(model.creationTime);
            this.requestStatus(model.requestStatus);
            this.lastUpdateAttemptTime(model.lastUpdateAttemptTime);
            this.lastUpdateFailureReason(model.lastUpdateFailureReason);
        }

        public final String getUpgradeRequestId() {
            return this.upgradeRequestId;
        }

        public final void setUpgradeRequestId(String upgradeRequestId) {
            this.upgradeRequestId = upgradeRequestId;
        }

        @Override
        public final Builder upgradeRequestId(String upgradeRequestId) {
            this.upgradeRequestId = upgradeRequestId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getOriginalRole() {
            return this.originalRole;
        }

        public final void setOriginalRole(String originalRole) {
            this.originalRole = originalRole;
        }

        @Override
        public final Builder originalRole(String originalRole) {
            this.originalRole = originalRole;
            return this;
        }

        @Override
        public final Builder originalRole(UserRole originalRole) {
            this.originalRole(originalRole == null ? null : originalRole.toString());
            return this;
        }

        public final String getRequestedRole() {
            return this.requestedRole;
        }

        public final void setRequestedRole(String requestedRole) {
            this.requestedRole = requestedRole;
        }

        @Override
        public final Builder requestedRole(String requestedRole) {
            this.requestedRole = requestedRole;
            return this;
        }

        @Override
        public final Builder requestedRole(UserRole requestedRole) {
            this.requestedRole(requestedRole == null ? null : requestedRole.toString());
            return this;
        }

        public final String getRequestNote() {
            return this.requestNote;
        }

        public final void setRequestNote(String requestNote) {
            this.requestNote = requestNote;
        }

        @Override
        public final Builder requestNote(String requestNote) {
            this.requestNote = requestNote;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getRequestStatus() {
            return this.requestStatus;
        }

        public final void setRequestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
        }

        @Override
        public final Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            return this;
        }

        @Override
        public final Builder requestStatus(SelfUpgradeRequestStatus requestStatus) {
            this.requestStatus(requestStatus == null ? null : requestStatus.toString());
            return this;
        }

        public final Long getLastUpdateAttemptTime() {
            return this.lastUpdateAttemptTime;
        }

        public final void setLastUpdateAttemptTime(Long lastUpdateAttemptTime) {
            this.lastUpdateAttemptTime = lastUpdateAttemptTime;
        }

        @Override
        public final Builder lastUpdateAttemptTime(Long lastUpdateAttemptTime) {
            this.lastUpdateAttemptTime = lastUpdateAttemptTime;
            return this;
        }

        public final String getLastUpdateFailureReason() {
            return this.lastUpdateFailureReason;
        }

        public final void setLastUpdateFailureReason(String lastUpdateFailureReason) {
            this.lastUpdateFailureReason = lastUpdateFailureReason;
        }

        @Override
        public final Builder lastUpdateFailureReason(String lastUpdateFailureReason) {
            this.lastUpdateFailureReason = lastUpdateFailureReason;
            return this;
        }

        public SelfUpgradeRequestDetail build() {
            return new SelfUpgradeRequestDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelfUpgradeRequestDetail> {
        public Builder upgradeRequestId(String var1);

        public Builder userName(String var1);

        public Builder originalRole(String var1);

        public Builder originalRole(UserRole var1);

        public Builder requestedRole(String var1);

        public Builder requestedRole(UserRole var1);

        public Builder requestNote(String var1);

        public Builder creationTime(Long var1);

        public Builder requestStatus(String var1);

        public Builder requestStatus(SelfUpgradeRequestStatus var1);

        public Builder lastUpdateAttemptTime(Long var1);

        public Builder lastUpdateFailureReason(String var1);
    }
}

