/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DashboardVisualResult;
import software.amazon.awssdk.services.quicksight.model.GeneratedAnswerResult;
import software.amazon.awssdk.services.quicksight.model.QAResultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QAResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QAResult> {
    private static final SdkField<String> RESULT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultType").getter(QAResult.getter(QAResult::resultTypeAsString)).setter(QAResult.setter(Builder::resultType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultType").build()}).build();
    private static final SdkField<DashboardVisualResult> DASHBOARD_VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashboardVisual").getter(QAResult.getter(QAResult::dashboardVisual)).setter(QAResult.setter(Builder::dashboardVisual)).constructor(DashboardVisualResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardVisual").build()}).build();
    private static final SdkField<GeneratedAnswerResult> GENERATED_ANSWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeneratedAnswer").getter(QAResult.getter(QAResult::generatedAnswer)).setter(QAResult.setter(Builder::generatedAnswer)).constructor(GeneratedAnswerResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedAnswer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_TYPE_FIELD, DASHBOARD_VISUAL_FIELD, GENERATED_ANSWER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QAResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resultType;
    private final DashboardVisualResult dashboardVisual;
    private final GeneratedAnswerResult generatedAnswer;

    private QAResult(BuilderImpl builder) {
        this.resultType = builder.resultType;
        this.dashboardVisual = builder.dashboardVisual;
        this.generatedAnswer = builder.generatedAnswer;
    }

    public final QAResultType resultType() {
        return QAResultType.fromValue(this.resultType);
    }

    public final String resultTypeAsString() {
        return this.resultType;
    }

    public final DashboardVisualResult dashboardVisual() {
        return this.dashboardVisual;
    }

    public final GeneratedAnswerResult generatedAnswer() {
        return this.generatedAnswer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardVisual());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedAnswer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QAResult)) {
            return false;
        }
        QAResult other = (QAResult)obj;
        return Objects.equals(this.resultTypeAsString(), other.resultTypeAsString()) && Objects.equals(this.dashboardVisual(), other.dashboardVisual()) && Objects.equals(this.generatedAnswer(), other.generatedAnswer());
    }

    public final String toString() {
        return ToString.builder((String)"QAResult").add("ResultType", (Object)this.resultTypeAsString()).add("DashboardVisual", (Object)this.dashboardVisual()).add("GeneratedAnswer", (Object)this.generatedAnswer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultType": {
                return Optional.ofNullable(clazz.cast(this.resultTypeAsString()));
            }
            case "DashboardVisual": {
                return Optional.ofNullable(clazz.cast(this.dashboardVisual()));
            }
            case "GeneratedAnswer": {
                return Optional.ofNullable(clazz.cast(this.generatedAnswer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultType", RESULT_TYPE_FIELD);
        map.put("DashboardVisual", DASHBOARD_VISUAL_FIELD);
        map.put("GeneratedAnswer", GENERATED_ANSWER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QAResult, T> g) {
        return obj -> g.apply((QAResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultType;
        private DashboardVisualResult dashboardVisual;
        private GeneratedAnswerResult generatedAnswer;

        private BuilderImpl() {
        }

        private BuilderImpl(QAResult model) {
            this.resultType(model.resultType);
            this.dashboardVisual(model.dashboardVisual);
            this.generatedAnswer(model.generatedAnswer);
        }

        public final String getResultType() {
            return this.resultType;
        }

        public final void setResultType(String resultType) {
            this.resultType = resultType;
        }

        @Override
        public final Builder resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        @Override
        public final Builder resultType(QAResultType resultType) {
            this.resultType(resultType == null ? null : resultType.toString());
            return this;
        }

        public final DashboardVisualResult.Builder getDashboardVisual() {
            return this.dashboardVisual != null ? this.dashboardVisual.toBuilder() : null;
        }

        public final void setDashboardVisual(DashboardVisualResult.BuilderImpl dashboardVisual) {
            this.dashboardVisual = dashboardVisual != null ? dashboardVisual.build() : null;
        }

        @Override
        public final Builder dashboardVisual(DashboardVisualResult dashboardVisual) {
            this.dashboardVisual = dashboardVisual;
            return this;
        }

        public final GeneratedAnswerResult.Builder getGeneratedAnswer() {
            return this.generatedAnswer != null ? this.generatedAnswer.toBuilder() : null;
        }

        public final void setGeneratedAnswer(GeneratedAnswerResult.BuilderImpl generatedAnswer) {
            this.generatedAnswer = generatedAnswer != null ? generatedAnswer.build() : null;
        }

        @Override
        public final Builder generatedAnswer(GeneratedAnswerResult generatedAnswer) {
            this.generatedAnswer = generatedAnswer;
            return this;
        }

        public QAResult build() {
            return new QAResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QAResult> {
        public Builder resultType(String var1);

        public Builder resultType(QAResultType var1);

        public Builder dashboardVisual(DashboardVisualResult var1);

        default public Builder dashboardVisual(Consumer<DashboardVisualResult.Builder> dashboardVisual) {
            return this.dashboardVisual((DashboardVisualResult)((DashboardVisualResult.Builder)DashboardVisualResult.builder().applyMutation(dashboardVisual)).build());
        }

        public Builder generatedAnswer(GeneratedAnswerResult var1);

        default public Builder generatedAnswer(Consumer<GeneratedAnswerResult.Builder> generatedAnswer) {
            return this.generatedAnswer((GeneratedAnswerResult)((GeneratedAnswerResult.Builder)GeneratedAnswerResult.builder().applyMutation(generatedAnswer)).build());
        }
    }
}

