/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefaultListCopier;
import software.amazon.awssdk.services.quicksight.model.DataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.DonutOptions;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.PieChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.PieChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.SmallMultiplesOptions;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PieChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PieChartConfiguration> {
    private static final SdkField<PieChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(PieChartConfiguration.getter(PieChartConfiguration::fieldWells)).setter(PieChartConfiguration.setter(Builder::fieldWells)).constructor(PieChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<PieChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(PieChartConfiguration.getter(PieChartConfiguration::sortConfiguration)).setter(PieChartConfiguration.setter(Builder::sortConfiguration)).constructor(PieChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<DonutOptions> DONUT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DonutOptions").getter(PieChartConfiguration.getter(PieChartConfiguration::donutOptions)).setter(PieChartConfiguration.setter(Builder::donutOptions)).constructor(DonutOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DonutOptions").build()}).build();
    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions").getter(PieChartConfiguration.getter(PieChartConfiguration::smallMultiplesOptions)).setter(PieChartConfiguration.setter(Builder::smallMultiplesOptions)).constructor(SmallMultiplesOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(PieChartConfiguration.getter(PieChartConfiguration::categoryLabelOptions)).setter(PieChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueLabelOptions").getter(PieChartConfiguration.getter(PieChartConfiguration::valueLabelOptions)).setter(PieChartConfiguration.setter(Builder::valueLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(PieChartConfiguration.getter(PieChartConfiguration::legend)).setter(PieChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabels").getter(PieChartConfiguration.getter(PieChartConfiguration::dataLabels)).setter(PieChartConfiguration.setter(Builder::dataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(PieChartConfiguration.getter(PieChartConfiguration::tooltip)).setter(PieChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(PieChartConfiguration.getter(PieChartConfiguration::visualPalette)).setter(PieChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributionAnalysisDefaults").getter(PieChartConfiguration.getter(PieChartConfiguration::contributionAnalysisDefaults)).setter(PieChartConfiguration.setter(Builder::contributionAnalysisDefaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContributionAnalysisDefault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(PieChartConfiguration.getter(PieChartConfiguration::interactions)).setter(PieChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, DONUT_OPTIONS_FIELD, SMALL_MULTIPLES_OPTIONS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, VALUE_LABEL_OPTIONS_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, VISUAL_PALETTE_FIELD, CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PieChartConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PieChartFieldWells fieldWells;
    private final PieChartSortConfiguration sortConfiguration;
    private final DonutOptions donutOptions;
    private final SmallMultiplesOptions smallMultiplesOptions;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final ChartAxisLabelOptions valueLabelOptions;
    private final LegendOptions legend;
    private final DataLabelOptions dataLabels;
    private final TooltipOptions tooltip;
    private final VisualPalette visualPalette;
    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;
    private final VisualInteractionOptions interactions;

    private PieChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.donutOptions = builder.donutOptions;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.visualPalette = builder.visualPalette;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.interactions = builder.interactions;
    }

    public final PieChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final PieChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final DonutOptions donutOptions() {
        return this.donutOptions;
    }

    public final SmallMultiplesOptions smallMultiplesOptions() {
        return this.smallMultiplesOptions;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final ChartAxisLabelOptions valueLabelOptions() {
        return this.valueLabelOptions;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final DataLabelOptions dataLabels() {
        return this.dataLabels;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final boolean hasContributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults != null && !(this.contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.donutOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PieChartConfiguration)) {
            return false;
        }
        PieChartConfiguration other = (PieChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.donutOptions(), other.donutOptions()) && Objects.equals(this.smallMultiplesOptions(), other.smallMultiplesOptions()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.valueLabelOptions(), other.valueLabelOptions()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.dataLabels(), other.dataLabels()) && Objects.equals(this.tooltip(), other.tooltip()) && Objects.equals(this.visualPalette(), other.visualPalette()) && this.hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults() && Objects.equals(this.contributionAnalysisDefaults(), other.contributionAnalysisDefaults()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"PieChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("DonutOptions", (Object)this.donutOptions()).add("SmallMultiplesOptions", (Object)this.smallMultiplesOptions()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("ValueLabelOptions", (Object)this.valueLabelOptions()).add("Legend", (Object)this.legend()).add("DataLabels", (Object)this.dataLabels()).add("Tooltip", (Object)this.tooltip()).add("VisualPalette", (Object)this.visualPalette()).add("ContributionAnalysisDefaults", this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "DonutOptions": {
                return Optional.ofNullable(clazz.cast(this.donutOptions()));
            }
            case "SmallMultiplesOptions": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesOptions()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "ValueLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.valueLabelOptions()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "DataLabels": {
                return Optional.ofNullable(clazz.cast(this.dataLabels()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "ContributionAnalysisDefaults": {
                return Optional.ofNullable(clazz.cast(this.contributionAnalysisDefaults()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("DonutOptions", DONUT_OPTIONS_FIELD);
        map.put("SmallMultiplesOptions", SMALL_MULTIPLES_OPTIONS_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("ValueLabelOptions", VALUE_LABEL_OPTIONS_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("ContributionAnalysisDefaults", CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PieChartConfiguration, T> g) {
        return obj -> g.apply((PieChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PieChartFieldWells fieldWells;
        private PieChartSortConfiguration sortConfiguration;
        private DonutOptions donutOptions;
        private SmallMultiplesOptions smallMultiplesOptions;
        private ChartAxisLabelOptions categoryLabelOptions;
        private ChartAxisLabelOptions valueLabelOptions;
        private LegendOptions legend;
        private DataLabelOptions dataLabels;
        private TooltipOptions tooltip;
        private VisualPalette visualPalette;
        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(PieChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.donutOptions(model.donutOptions);
            this.smallMultiplesOptions(model.smallMultiplesOptions);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.valueLabelOptions(model.valueLabelOptions);
            this.legend(model.legend);
            this.dataLabels(model.dataLabels);
            this.tooltip(model.tooltip);
            this.visualPalette(model.visualPalette);
            this.contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            this.interactions(model.interactions);
        }

        public final PieChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(PieChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(PieChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final PieChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(PieChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(PieChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final DonutOptions.Builder getDonutOptions() {
            return this.donutOptions != null ? this.donutOptions.toBuilder() : null;
        }

        public final void setDonutOptions(DonutOptions.BuilderImpl donutOptions) {
            this.donutOptions = donutOptions != null ? donutOptions.build() : null;
        }

        @Override
        public final Builder donutOptions(DonutOptions donutOptions) {
            this.donutOptions = donutOptions;
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return this.smallMultiplesOptions != null ? this.smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return this.valueLabelOptions != null ? this.valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return this.dataLabels != null ? this.dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier.copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults).map(c -> (ContributionAnalysisDefault)((ContributionAnalysisDefault.Builder)ContributionAnalysisDefault.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public PieChartConfiguration build() {
            return new PieChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PieChartConfiguration> {
        public Builder fieldWells(PieChartFieldWells var1);

        default public Builder fieldWells(Consumer<PieChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((PieChartFieldWells)((PieChartFieldWells.Builder)PieChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(PieChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<PieChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((PieChartSortConfiguration)((PieChartSortConfiguration.Builder)PieChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder donutOptions(DonutOptions var1);

        default public Builder donutOptions(Consumer<DonutOptions.Builder> donutOptions) {
            return this.donutOptions((DonutOptions)((DonutOptions.Builder)DonutOptions.builder().applyMutation(donutOptions)).build());
        }

        public Builder smallMultiplesOptions(SmallMultiplesOptions var1);

        default public Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return this.smallMultiplesOptions((SmallMultiplesOptions)((SmallMultiplesOptions.Builder)SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder valueLabelOptions(ChartAxisLabelOptions var1);

        default public Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return this.valueLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions)).build());
        }

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder dataLabels(DataLabelOptions var1);

        default public Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return this.dataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(dataLabels)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> var1);

        public Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... var1);

        public Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... var1);

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

