/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FieldName {
    ASSET_NAME("assetName"),
    ASSET_DESCRIPTION("assetDescription"),
    DIRECT_QUICKSIGHT_OWNER("DIRECT_QUICKSIGHT_OWNER"),
    DIRECT_QUICKSIGHT_VIEWER_OR_OWNER("DIRECT_QUICKSIGHT_VIEWER_OR_OWNER"),
    DIRECT_QUICKSIGHT_SOLE_OWNER("DIRECT_QUICKSIGHT_SOLE_OWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FieldName> VALUE_MAP;
    private final String value;

    private FieldName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FieldName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FieldName> knownValues() {
        EnumSet<FieldName> knownValues = EnumSet.allOf(FieldName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FieldName.class, FieldName::toString);
    }
}

