/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ActionConnector;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActionConnectorResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeActionConnectorResponse> {
    private static final SdkField<ActionConnector> ACTION_CONNECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActionConnector").getter(DescribeActionConnectorResponse.getter(DescribeActionConnectorResponse::actionConnector)).setter(DescribeActionConnectorResponse.setter(Builder::actionConnector)).constructor(ActionConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnector").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeActionConnectorResponse.getter(DescribeActionConnectorResponse::requestId)).setter(DescribeActionConnectorResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeActionConnectorResponse.getter(DescribeActionConnectorResponse::status)).setter(DescribeActionConnectorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_CONNECTOR_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeActionConnectorResponse.memberNameToFieldInitializer();
    private final ActionConnector actionConnector;
    private final String requestId;
    private final Integer status;

    private DescribeActionConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.actionConnector = builder.actionConnector;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final ActionConnector actionConnector() {
        return this.actionConnector;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConnector());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionConnectorResponse)) {
            return false;
        }
        DescribeActionConnectorResponse other = (DescribeActionConnectorResponse)((Object)obj);
        return Objects.equals(this.actionConnector(), other.actionConnector()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeActionConnectorResponse").add("ActionConnector", (Object)this.actionConnector()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionConnector": {
                return Optional.ofNullable(clazz.cast(this.actionConnector()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ActionConnector", ACTION_CONNECTOR_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionConnectorResponse, T> g) {
        return obj -> g.apply((DescribeActionConnectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private ActionConnector actionConnector;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionConnectorResponse model) {
            super(model);
            this.actionConnector(model.actionConnector);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final ActionConnector.Builder getActionConnector() {
            return this.actionConnector != null ? this.actionConnector.toBuilder() : null;
        }

        public final void setActionConnector(ActionConnector.BuilderImpl actionConnector) {
            this.actionConnector = actionConnector != null ? actionConnector.build() : null;
        }

        @Override
        public final Builder actionConnector(ActionConnector actionConnector) {
            this.actionConnector = actionConnector;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeActionConnectorResponse build() {
            return new DescribeActionConnectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeActionConnectorResponse> {
        public Builder actionConnector(ActionConnector var1);

        default public Builder actionConnector(Consumer<ActionConnector.Builder> actionConnector) {
            return this.actionConnector((ActionConnector)((ActionConnector.Builder)ActionConnector.builder().applyMutation(actionConnector)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

