/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DecalPatternType;
import software.amazon.awssdk.services.quicksight.model.DecalStyleType;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecalSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecalSettings> {
    private static final SdkField<String> ELEMENT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementValue").getter(DecalSettings.getter(DecalSettings::elementValue)).setter(DecalSettings.setter(Builder::elementValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementValue").build()}).build();
    private static final SdkField<String> DECAL_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecalVisibility").getter(DecalSettings.getter(DecalSettings::decalVisibilityAsString)).setter(DecalSettings.setter(Builder::decalVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecalVisibility").build()}).build();
    private static final SdkField<String> DECAL_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecalColor").getter(DecalSettings.getter(DecalSettings::decalColor)).setter(DecalSettings.setter(Builder::decalColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecalColor").build()}).build();
    private static final SdkField<String> DECAL_PATTERN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecalPatternType").getter(DecalSettings.getter(DecalSettings::decalPatternTypeAsString)).setter(DecalSettings.setter(Builder::decalPatternType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecalPatternType").build()}).build();
    private static final SdkField<String> DECAL_STYLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DecalStyleType").getter(DecalSettings.getter(DecalSettings::decalStyleTypeAsString)).setter(DecalSettings.setter(Builder::decalStyleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecalStyleType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_VALUE_FIELD, DECAL_VISIBILITY_FIELD, DECAL_COLOR_FIELD, DECAL_PATTERN_TYPE_FIELD, DECAL_STYLE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecalSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String elementValue;
    private final String decalVisibility;
    private final String decalColor;
    private final String decalPatternType;
    private final String decalStyleType;

    private DecalSettings(BuilderImpl builder) {
        this.elementValue = builder.elementValue;
        this.decalVisibility = builder.decalVisibility;
        this.decalColor = builder.decalColor;
        this.decalPatternType = builder.decalPatternType;
        this.decalStyleType = builder.decalStyleType;
    }

    public final String elementValue() {
        return this.elementValue;
    }

    public final Visibility decalVisibility() {
        return Visibility.fromValue(this.decalVisibility);
    }

    public final String decalVisibilityAsString() {
        return this.decalVisibility;
    }

    public final String decalColor() {
        return this.decalColor;
    }

    public final DecalPatternType decalPatternType() {
        return DecalPatternType.fromValue(this.decalPatternType);
    }

    public final String decalPatternTypeAsString() {
        return this.decalPatternType;
    }

    public final DecalStyleType decalStyleType() {
        return DecalStyleType.fromValue(this.decalStyleType);
    }

    public final String decalStyleTypeAsString() {
        return this.decalStyleType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.decalVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.decalColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.decalPatternTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.decalStyleTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecalSettings)) {
            return false;
        }
        DecalSettings other = (DecalSettings)obj;
        return Objects.equals(this.elementValue(), other.elementValue()) && Objects.equals(this.decalVisibilityAsString(), other.decalVisibilityAsString()) && Objects.equals(this.decalColor(), other.decalColor()) && Objects.equals(this.decalPatternTypeAsString(), other.decalPatternTypeAsString()) && Objects.equals(this.decalStyleTypeAsString(), other.decalStyleTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DecalSettings").add("ElementValue", (Object)this.elementValue()).add("DecalVisibility", (Object)this.decalVisibilityAsString()).add("DecalColor", (Object)this.decalColor()).add("DecalPatternType", (Object)this.decalPatternTypeAsString()).add("DecalStyleType", (Object)this.decalStyleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElementValue": {
                return Optional.ofNullable(clazz.cast(this.elementValue()));
            }
            case "DecalVisibility": {
                return Optional.ofNullable(clazz.cast(this.decalVisibilityAsString()));
            }
            case "DecalColor": {
                return Optional.ofNullable(clazz.cast(this.decalColor()));
            }
            case "DecalPatternType": {
                return Optional.ofNullable(clazz.cast(this.decalPatternTypeAsString()));
            }
            case "DecalStyleType": {
                return Optional.ofNullable(clazz.cast(this.decalStyleTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ElementValue", ELEMENT_VALUE_FIELD);
        map.put("DecalVisibility", DECAL_VISIBILITY_FIELD);
        map.put("DecalColor", DECAL_COLOR_FIELD);
        map.put("DecalPatternType", DECAL_PATTERN_TYPE_FIELD);
        map.put("DecalStyleType", DECAL_STYLE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecalSettings, T> g) {
        return obj -> g.apply((DecalSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementValue;
        private String decalVisibility;
        private String decalColor;
        private String decalPatternType;
        private String decalStyleType;

        private BuilderImpl() {
        }

        private BuilderImpl(DecalSettings model) {
            this.elementValue(model.elementValue);
            this.decalVisibility(model.decalVisibility);
            this.decalColor(model.decalColor);
            this.decalPatternType(model.decalPatternType);
            this.decalStyleType(model.decalStyleType);
        }

        public final String getElementValue() {
            return this.elementValue;
        }

        public final void setElementValue(String elementValue) {
            this.elementValue = elementValue;
        }

        @Override
        public final Builder elementValue(String elementValue) {
            this.elementValue = elementValue;
            return this;
        }

        public final String getDecalVisibility() {
            return this.decalVisibility;
        }

        public final void setDecalVisibility(String decalVisibility) {
            this.decalVisibility = decalVisibility;
        }

        @Override
        public final Builder decalVisibility(String decalVisibility) {
            this.decalVisibility = decalVisibility;
            return this;
        }

        @Override
        public final Builder decalVisibility(Visibility decalVisibility) {
            this.decalVisibility(decalVisibility == null ? null : decalVisibility.toString());
            return this;
        }

        public final String getDecalColor() {
            return this.decalColor;
        }

        public final void setDecalColor(String decalColor) {
            this.decalColor = decalColor;
        }

        @Override
        public final Builder decalColor(String decalColor) {
            this.decalColor = decalColor;
            return this;
        }

        public final String getDecalPatternType() {
            return this.decalPatternType;
        }

        public final void setDecalPatternType(String decalPatternType) {
            this.decalPatternType = decalPatternType;
        }

        @Override
        public final Builder decalPatternType(String decalPatternType) {
            this.decalPatternType = decalPatternType;
            return this;
        }

        @Override
        public final Builder decalPatternType(DecalPatternType decalPatternType) {
            this.decalPatternType(decalPatternType == null ? null : decalPatternType.toString());
            return this;
        }

        public final String getDecalStyleType() {
            return this.decalStyleType;
        }

        public final void setDecalStyleType(String decalStyleType) {
            this.decalStyleType = decalStyleType;
        }

        @Override
        public final Builder decalStyleType(String decalStyleType) {
            this.decalStyleType = decalStyleType;
            return this;
        }

        @Override
        public final Builder decalStyleType(DecalStyleType decalStyleType) {
            this.decalStyleType(decalStyleType == null ? null : decalStyleType.toString());
            return this;
        }

        public DecalSettings build() {
            return new DecalSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecalSettings> {
        public Builder elementValue(String var1);

        public Builder decalVisibility(String var1);

        public Builder decalVisibility(Visibility var1);

        public Builder decalColor(String var1);

        public Builder decalPatternType(String var1);

        public Builder decalPatternType(DecalPatternType var1);

        public Builder decalStyleType(String var1);

        public Builder decalStyleType(DecalStyleType var1);
    }
}

