/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BinWidthOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BinWidthOptions> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(BinWidthOptions.getter(BinWidthOptions::value)).setter(BinWidthOptions.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Long> BIN_COUNT_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BinCountLimit").getter(BinWidthOptions.getter(BinWidthOptions::binCountLimit)).setter(BinWidthOptions.setter(Builder::binCountLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinCountLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, BIN_COUNT_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BinWidthOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double value;
    private final Long binCountLimit;

    private BinWidthOptions(BuilderImpl builder) {
        this.value = builder.value;
        this.binCountLimit = builder.binCountLimit;
    }

    public final Double value() {
        return this.value;
    }

    public final Long binCountLimit() {
        return this.binCountLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.binCountLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BinWidthOptions)) {
            return false;
        }
        BinWidthOptions other = (BinWidthOptions)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.binCountLimit(), other.binCountLimit());
    }

    public final String toString() {
        return ToString.builder((String)"BinWidthOptions").add("Value", (Object)this.value()).add("BinCountLimit", (Object)this.binCountLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "BinCountLimit": {
                return Optional.ofNullable(clazz.cast(this.binCountLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("BinCountLimit", BIN_COUNT_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BinWidthOptions, T> g) {
        return obj -> g.apply((BinWidthOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double value;
        private Long binCountLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(BinWidthOptions model) {
            this.value(model.value);
            this.binCountLimit(model.binCountLimit);
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final Long getBinCountLimit() {
            return this.binCountLimit;
        }

        public final void setBinCountLimit(Long binCountLimit) {
            this.binCountLimit = binCountLimit;
        }

        @Override
        public final Builder binCountLimit(Long binCountLimit) {
            this.binCountLimit = binCountLimit;
            return this;
        }

        public BinWidthOptions build() {
            return new BinWidthOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BinWidthOptions> {
        public Builder value(Double var1);

        public Builder binCountLimit(Long var1);
    }
}

