/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AppendedColumn;
import software.amazon.awssdk.services.quicksight.model.AppendedColumnListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppendOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppendOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(AppendOperation.getter(AppendOperation::alias)).setter(AppendOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> FIRST_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirstSource").getter(AppendOperation.getter(AppendOperation::firstSource)).setter(AppendOperation.setter(Builder::firstSource)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSource").build()}).build();
    private static final SdkField<TransformOperationSource> SECOND_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecondSource").getter(AppendOperation.getter(AppendOperation::secondSource)).setter(AppendOperation.setter(Builder::secondSource)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondSource").build()}).build();
    private static final SdkField<List<AppendedColumn>> APPENDED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppendedColumns").getter(AppendOperation.getter(AppendOperation::appendedColumns)).setter(AppendOperation.setter(Builder::appendedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppendedColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, FIRST_SOURCE_FIELD, SECOND_SOURCE_FIELD, APPENDED_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppendOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource firstSource;
    private final TransformOperationSource secondSource;
    private final List<AppendedColumn> appendedColumns;

    private AppendOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.firstSource = builder.firstSource;
        this.secondSource = builder.secondSource;
        this.appendedColumns = builder.appendedColumns;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource firstSource() {
        return this.firstSource;
    }

    public final TransformOperationSource secondSource() {
        return this.secondSource;
    }

    public final boolean hasAppendedColumns() {
        return this.appendedColumns != null && !(this.appendedColumns instanceof SdkAutoConstructList);
    }

    public final List<AppendedColumn> appendedColumns() {
        return this.appendedColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppendedColumns() ? this.appendedColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppendOperation)) {
            return false;
        }
        AppendOperation other = (AppendOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.firstSource(), other.firstSource()) && Objects.equals(this.secondSource(), other.secondSource()) && this.hasAppendedColumns() == other.hasAppendedColumns() && Objects.equals(this.appendedColumns(), other.appendedColumns());
    }

    public final String toString() {
        return ToString.builder((String)"AppendOperation").add("Alias", (Object)this.alias()).add("FirstSource", (Object)this.firstSource()).add("SecondSource", (Object)this.secondSource()).add("AppendedColumns", this.hasAppendedColumns() ? this.appendedColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "FirstSource": {
                return Optional.ofNullable(clazz.cast(this.firstSource()));
            }
            case "SecondSource": {
                return Optional.ofNullable(clazz.cast(this.secondSource()));
            }
            case "AppendedColumns": {
                return Optional.ofNullable(clazz.cast(this.appendedColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("FirstSource", FIRST_SOURCE_FIELD);
        map.put("SecondSource", SECOND_SOURCE_FIELD);
        map.put("AppendedColumns", APPENDED_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppendOperation, T> g) {
        return obj -> g.apply((AppendOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource firstSource;
        private TransformOperationSource secondSource;
        private List<AppendedColumn> appendedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppendOperation model) {
            this.alias(model.alias);
            this.firstSource(model.firstSource);
            this.secondSource(model.secondSource);
            this.appendedColumns(model.appendedColumns);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getFirstSource() {
            return this.firstSource != null ? this.firstSource.toBuilder() : null;
        }

        public final void setFirstSource(TransformOperationSource.BuilderImpl firstSource) {
            this.firstSource = firstSource != null ? firstSource.build() : null;
        }

        @Override
        public final Builder firstSource(TransformOperationSource firstSource) {
            this.firstSource = firstSource;
            return this;
        }

        public final TransformOperationSource.Builder getSecondSource() {
            return this.secondSource != null ? this.secondSource.toBuilder() : null;
        }

        public final void setSecondSource(TransformOperationSource.BuilderImpl secondSource) {
            this.secondSource = secondSource != null ? secondSource.build() : null;
        }

        @Override
        public final Builder secondSource(TransformOperationSource secondSource) {
            this.secondSource = secondSource;
            return this;
        }

        public final List<AppendedColumn.Builder> getAppendedColumns() {
            List<AppendedColumn.Builder> result = AppendedColumnListCopier.copyToBuilder(this.appendedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppendedColumns(Collection<AppendedColumn.BuilderImpl> appendedColumns) {
            this.appendedColumns = AppendedColumnListCopier.copyFromBuilder(appendedColumns);
        }

        @Override
        public final Builder appendedColumns(Collection<AppendedColumn> appendedColumns) {
            this.appendedColumns = AppendedColumnListCopier.copy(appendedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appendedColumns(AppendedColumn ... appendedColumns) {
            this.appendedColumns(Arrays.asList(appendedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appendedColumns(Consumer<AppendedColumn.Builder> ... appendedColumns) {
            this.appendedColumns(Stream.of(appendedColumns).map(c -> (AppendedColumn)((AppendedColumn.Builder)AppendedColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AppendOperation build() {
            return new AppendOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppendOperation> {
        public Builder alias(String var1);

        public Builder firstSource(TransformOperationSource var1);

        default public Builder firstSource(Consumer<TransformOperationSource.Builder> firstSource) {
            return this.firstSource((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(firstSource)).build());
        }

        public Builder secondSource(TransformOperationSource var1);

        default public Builder secondSource(Consumer<TransformOperationSource.Builder> secondSource) {
            return this.secondSource((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(secondSource)).build());
        }

        public Builder appendedColumns(Collection<AppendedColumn> var1);

        public Builder appendedColumns(AppendedColumn ... var1);

        public Builder appendedColumns(Consumer<AppendedColumn.Builder> ... var1);
    }
}

