/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ConnectionAuthType;
import software.amazon.awssdk.services.quicksight.model.ReadAuthenticationMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadAuthConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadAuthConfig> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(ReadAuthConfig.getter(ReadAuthConfig::authenticationTypeAsString)).setter(ReadAuthConfig.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<ReadAuthenticationMetadata> AUTHENTICATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationMetadata").getter(ReadAuthConfig.getter(ReadAuthConfig::authenticationMetadata)).setter(ReadAuthConfig.setter(Builder::authenticationMetadata)).constructor(ReadAuthenticationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, AUTHENTICATION_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadAuthConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final ReadAuthenticationMetadata authenticationMetadata;

    private ReadAuthConfig(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.authenticationMetadata = builder.authenticationMetadata;
    }

    public final ConnectionAuthType authenticationType() {
        return ConnectionAuthType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final ReadAuthenticationMetadata authenticationMetadata() {
        return this.authenticationMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthConfig)) {
            return false;
        }
        ReadAuthConfig other = (ReadAuthConfig)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.authenticationMetadata(), other.authenticationMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ReadAuthConfig").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("AuthenticationMetadata", (Object)this.authenticationMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "AuthenticationMetadata": {
                return Optional.ofNullable(clazz.cast(this.authenticationMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("AuthenticationMetadata", AUTHENTICATION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthConfig, T> g) {
        return obj -> g.apply((ReadAuthConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private ReadAuthenticationMetadata authenticationMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthConfig model) {
            this.authenticationType(model.authenticationType);
            this.authenticationMetadata(model.authenticationMetadata);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(ConnectionAuthType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final ReadAuthenticationMetadata.Builder getAuthenticationMetadata() {
            return this.authenticationMetadata != null ? this.authenticationMetadata.toBuilder() : null;
        }

        public final void setAuthenticationMetadata(ReadAuthenticationMetadata.BuilderImpl authenticationMetadata) {
            this.authenticationMetadata = authenticationMetadata != null ? authenticationMetadata.build() : null;
        }

        @Override
        public final Builder authenticationMetadata(ReadAuthenticationMetadata authenticationMetadata) {
            this.authenticationMetadata = authenticationMetadata;
            return this;
        }

        public ReadAuthConfig build() {
            return new ReadAuthConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadAuthConfig> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(ConnectionAuthType var1);

        public Builder authenticationMetadata(ReadAuthenticationMetadata var1);

        default public Builder authenticationMetadata(Consumer<ReadAuthenticationMetadata.Builder> authenticationMetadata) {
            return this.authenticationMetadata((ReadAuthenticationMetadata)((ReadAuthenticationMetadata.Builder)ReadAuthenticationMetadata.builder().applyMutation(authenticationMetadata)).build());
        }
    }
}

