/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutElementBackgroundStyle;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutElementBorderStyle;
import software.amazon.awssdk.services.quicksight.model.LayoutElementType;
import software.amazon.awssdk.services.quicksight.model.LoadingAnimation;
import software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRule;
import software.amazon.awssdk.services.quicksight.model.SheetElementRenderingRuleListCopier;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeFormLayoutElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeFormLayoutElement> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementId").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::elementId)).setter(FreeFormLayoutElement.setter(Builder::elementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementId").build()}).build();
    private static final SdkField<String> ELEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementType").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::elementTypeAsString)).setter(FreeFormLayoutElement.setter(Builder::elementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementType").build()}).build();
    private static final SdkField<String> X_AXIS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XAxisLocation").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::xAxisLocation)).setter(FreeFormLayoutElement.setter(Builder::xAxisLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLocation").build()}).build();
    private static final SdkField<String> Y_AXIS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("YAxisLocation").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::yAxisLocation)).setter(FreeFormLayoutElement.setter(Builder::yAxisLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxisLocation").build()}).build();
    private static final SdkField<String> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Width").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::width)).setter(FreeFormLayoutElement.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final SdkField<String> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Height").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::height)).setter(FreeFormLayoutElement.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::visibilityAsString)).setter(FreeFormLayoutElement.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<List<SheetElementRenderingRule>> RENDERING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RenderingRules").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::renderingRules)).setter(FreeFormLayoutElement.setter(Builder::renderingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenderingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SheetElementRenderingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FreeFormLayoutElementBorderStyle> BORDER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BorderStyle").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::borderStyle)).setter(FreeFormLayoutElement.setter(Builder::borderStyle)).constructor(FreeFormLayoutElementBorderStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderStyle").build()}).build();
    private static final SdkField<FreeFormLayoutElementBorderStyle> SELECTED_BORDER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectedBorderStyle").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::selectedBorderStyle)).setter(FreeFormLayoutElement.setter(Builder::selectedBorderStyle)).constructor(FreeFormLayoutElementBorderStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedBorderStyle").build()}).build();
    private static final SdkField<FreeFormLayoutElementBackgroundStyle> BACKGROUND_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackgroundStyle").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::backgroundStyle)).setter(FreeFormLayoutElement.setter(Builder::backgroundStyle)).constructor(FreeFormLayoutElementBackgroundStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundStyle").build()}).build();
    private static final SdkField<LoadingAnimation> LOADING_ANIMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadingAnimation").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::loadingAnimation)).setter(FreeFormLayoutElement.setter(Builder::loadingAnimation)).constructor(LoadingAnimation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadingAnimation").build()}).build();
    private static final SdkField<String> BORDER_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderRadius").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::borderRadius)).setter(FreeFormLayoutElement.setter(Builder::borderRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderRadius").build()}).build();
    private static final SdkField<String> PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Padding").getter(FreeFormLayoutElement.getter(FreeFormLayoutElement::padding)).setter(FreeFormLayoutElement.setter(Builder::padding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Padding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD, ELEMENT_TYPE_FIELD, X_AXIS_LOCATION_FIELD, Y_AXIS_LOCATION_FIELD, WIDTH_FIELD, HEIGHT_FIELD, VISIBILITY_FIELD, RENDERING_RULES_FIELD, BORDER_STYLE_FIELD, SELECTED_BORDER_STYLE_FIELD, BACKGROUND_STYLE_FIELD, LOADING_ANIMATION_FIELD, BORDER_RADIUS_FIELD, PADDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FreeFormLayoutElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String elementId;
    private final String elementType;
    private final String xAxisLocation;
    private final String yAxisLocation;
    private final String width;
    private final String height;
    private final String visibility;
    private final List<SheetElementRenderingRule> renderingRules;
    private final FreeFormLayoutElementBorderStyle borderStyle;
    private final FreeFormLayoutElementBorderStyle selectedBorderStyle;
    private final FreeFormLayoutElementBackgroundStyle backgroundStyle;
    private final LoadingAnimation loadingAnimation;
    private final String borderRadius;
    private final String padding;

    private FreeFormLayoutElement(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.elementType = builder.elementType;
        this.xAxisLocation = builder.xAxisLocation;
        this.yAxisLocation = builder.yAxisLocation;
        this.width = builder.width;
        this.height = builder.height;
        this.visibility = builder.visibility;
        this.renderingRules = builder.renderingRules;
        this.borderStyle = builder.borderStyle;
        this.selectedBorderStyle = builder.selectedBorderStyle;
        this.backgroundStyle = builder.backgroundStyle;
        this.loadingAnimation = builder.loadingAnimation;
        this.borderRadius = builder.borderRadius;
        this.padding = builder.padding;
    }

    public final String elementId() {
        return this.elementId;
    }

    public final LayoutElementType elementType() {
        return LayoutElementType.fromValue(this.elementType);
    }

    public final String elementTypeAsString() {
        return this.elementType;
    }

    public final String xAxisLocation() {
        return this.xAxisLocation;
    }

    public final String yAxisLocation() {
        return this.yAxisLocation;
    }

    public final String width() {
        return this.width;
    }

    public final String height() {
        return this.height;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final boolean hasRenderingRules() {
        return this.renderingRules != null && !(this.renderingRules instanceof SdkAutoConstructList);
    }

    public final List<SheetElementRenderingRule> renderingRules() {
        return this.renderingRules;
    }

    public final FreeFormLayoutElementBorderStyle borderStyle() {
        return this.borderStyle;
    }

    public final FreeFormLayoutElementBorderStyle selectedBorderStyle() {
        return this.selectedBorderStyle;
    }

    public final FreeFormLayoutElementBackgroundStyle backgroundStyle() {
        return this.backgroundStyle;
    }

    public final LoadingAnimation loadingAnimation() {
        return this.loadingAnimation;
    }

    public final String borderRadius() {
        return this.borderRadius;
    }

    public final String padding() {
        return this.padding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.elementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xAxisLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.yAxisLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRenderingRules() ? this.renderingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.borderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedBorderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadingAnimation());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.padding());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormLayoutElement)) {
            return false;
        }
        FreeFormLayoutElement other = (FreeFormLayoutElement)obj;
        return Objects.equals(this.elementId(), other.elementId()) && Objects.equals(this.elementTypeAsString(), other.elementTypeAsString()) && Objects.equals(this.xAxisLocation(), other.xAxisLocation()) && Objects.equals(this.yAxisLocation(), other.yAxisLocation()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && this.hasRenderingRules() == other.hasRenderingRules() && Objects.equals(this.renderingRules(), other.renderingRules()) && Objects.equals(this.borderStyle(), other.borderStyle()) && Objects.equals(this.selectedBorderStyle(), other.selectedBorderStyle()) && Objects.equals(this.backgroundStyle(), other.backgroundStyle()) && Objects.equals(this.loadingAnimation(), other.loadingAnimation()) && Objects.equals(this.borderRadius(), other.borderRadius()) && Objects.equals(this.padding(), other.padding());
    }

    public final String toString() {
        return ToString.builder((String)"FreeFormLayoutElement").add("ElementId", (Object)this.elementId()).add("ElementType", (Object)this.elementTypeAsString()).add("XAxisLocation", (Object)this.xAxisLocation()).add("YAxisLocation", (Object)this.yAxisLocation()).add("Width", (Object)this.width()).add("Height", (Object)this.height()).add("Visibility", (Object)this.visibilityAsString()).add("RenderingRules", this.hasRenderingRules() ? this.renderingRules() : null).add("BorderStyle", (Object)this.borderStyle()).add("SelectedBorderStyle", (Object)this.selectedBorderStyle()).add("BackgroundStyle", (Object)this.backgroundStyle()).add("LoadingAnimation", (Object)this.loadingAnimation()).add("BorderRadius", (Object)this.borderRadius()).add("Padding", (Object)this.padding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElementId": {
                return Optional.ofNullable(clazz.cast(this.elementId()));
            }
            case "ElementType": {
                return Optional.ofNullable(clazz.cast(this.elementTypeAsString()));
            }
            case "XAxisLocation": {
                return Optional.ofNullable(clazz.cast(this.xAxisLocation()));
            }
            case "YAxisLocation": {
                return Optional.ofNullable(clazz.cast(this.yAxisLocation()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "RenderingRules": {
                return Optional.ofNullable(clazz.cast(this.renderingRules()));
            }
            case "BorderStyle": {
                return Optional.ofNullable(clazz.cast(this.borderStyle()));
            }
            case "SelectedBorderStyle": {
                return Optional.ofNullable(clazz.cast(this.selectedBorderStyle()));
            }
            case "BackgroundStyle": {
                return Optional.ofNullable(clazz.cast(this.backgroundStyle()));
            }
            case "LoadingAnimation": {
                return Optional.ofNullable(clazz.cast(this.loadingAnimation()));
            }
            case "BorderRadius": {
                return Optional.ofNullable(clazz.cast(this.borderRadius()));
            }
            case "Padding": {
                return Optional.ofNullable(clazz.cast(this.padding()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ElementId", ELEMENT_ID_FIELD);
        map.put("ElementType", ELEMENT_TYPE_FIELD);
        map.put("XAxisLocation", X_AXIS_LOCATION_FIELD);
        map.put("YAxisLocation", Y_AXIS_LOCATION_FIELD);
        map.put("Width", WIDTH_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("RenderingRules", RENDERING_RULES_FIELD);
        map.put("BorderStyle", BORDER_STYLE_FIELD);
        map.put("SelectedBorderStyle", SELECTED_BORDER_STYLE_FIELD);
        map.put("BackgroundStyle", BACKGROUND_STYLE_FIELD);
        map.put("LoadingAnimation", LOADING_ANIMATION_FIELD);
        map.put("BorderRadius", BORDER_RADIUS_FIELD);
        map.put("Padding", PADDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeFormLayoutElement, T> g) {
        return obj -> g.apply((FreeFormLayoutElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementId;
        private String elementType;
        private String xAxisLocation;
        private String yAxisLocation;
        private String width;
        private String height;
        private String visibility;
        private List<SheetElementRenderingRule> renderingRules = DefaultSdkAutoConstructList.getInstance();
        private FreeFormLayoutElementBorderStyle borderStyle;
        private FreeFormLayoutElementBorderStyle selectedBorderStyle;
        private FreeFormLayoutElementBackgroundStyle backgroundStyle;
        private LoadingAnimation loadingAnimation;
        private String borderRadius;
        private String padding;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeFormLayoutElement model) {
            this.elementId(model.elementId);
            this.elementType(model.elementType);
            this.xAxisLocation(model.xAxisLocation);
            this.yAxisLocation(model.yAxisLocation);
            this.width(model.width);
            this.height(model.height);
            this.visibility(model.visibility);
            this.renderingRules(model.renderingRules);
            this.borderStyle(model.borderStyle);
            this.selectedBorderStyle(model.selectedBorderStyle);
            this.backgroundStyle(model.backgroundStyle);
            this.loadingAnimation(model.loadingAnimation);
            this.borderRadius(model.borderRadius);
            this.padding(model.padding);
        }

        public final String getElementId() {
            return this.elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final String getElementType() {
            return this.elementType;
        }

        public final void setElementType(String elementType) {
            this.elementType = elementType;
        }

        @Override
        public final Builder elementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        @Override
        public final Builder elementType(LayoutElementType elementType) {
            this.elementType(elementType == null ? null : elementType.toString());
            return this;
        }

        public final String getXAxisLocation() {
            return this.xAxisLocation;
        }

        public final void setXAxisLocation(String xAxisLocation) {
            this.xAxisLocation = xAxisLocation;
        }

        @Override
        public final Builder xAxisLocation(String xAxisLocation) {
            this.xAxisLocation = xAxisLocation;
            return this;
        }

        public final String getYAxisLocation() {
            return this.yAxisLocation;
        }

        public final void setYAxisLocation(String yAxisLocation) {
            this.yAxisLocation = yAxisLocation;
        }

        @Override
        public final Builder yAxisLocation(String yAxisLocation) {
            this.yAxisLocation = yAxisLocation;
            return this;
        }

        public final String getWidth() {
            return this.width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getHeight() {
            return this.height;
        }

        public final void setHeight(String height) {
            this.height = height;
        }

        @Override
        public final Builder height(String height) {
            this.height = height;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final List<SheetElementRenderingRule.Builder> getRenderingRules() {
            List<SheetElementRenderingRule.Builder> result = SheetElementRenderingRuleListCopier.copyToBuilder(this.renderingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRenderingRules(Collection<SheetElementRenderingRule.BuilderImpl> renderingRules) {
            this.renderingRules = SheetElementRenderingRuleListCopier.copyFromBuilder(renderingRules);
        }

        @Override
        public final Builder renderingRules(Collection<SheetElementRenderingRule> renderingRules) {
            this.renderingRules = SheetElementRenderingRuleListCopier.copy(renderingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renderingRules(SheetElementRenderingRule ... renderingRules) {
            this.renderingRules(Arrays.asList(renderingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renderingRules(Consumer<SheetElementRenderingRule.Builder> ... renderingRules) {
            this.renderingRules(Stream.of(renderingRules).map(c -> (SheetElementRenderingRule)((SheetElementRenderingRule.Builder)SheetElementRenderingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FreeFormLayoutElementBorderStyle.Builder getBorderStyle() {
            return this.borderStyle != null ? this.borderStyle.toBuilder() : null;
        }

        public final void setBorderStyle(FreeFormLayoutElementBorderStyle.BuilderImpl borderStyle) {
            this.borderStyle = borderStyle != null ? borderStyle.build() : null;
        }

        @Override
        public final Builder borderStyle(FreeFormLayoutElementBorderStyle borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        public final FreeFormLayoutElementBorderStyle.Builder getSelectedBorderStyle() {
            return this.selectedBorderStyle != null ? this.selectedBorderStyle.toBuilder() : null;
        }

        public final void setSelectedBorderStyle(FreeFormLayoutElementBorderStyle.BuilderImpl selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle != null ? selectedBorderStyle.build() : null;
        }

        @Override
        public final Builder selectedBorderStyle(FreeFormLayoutElementBorderStyle selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle;
            return this;
        }

        public final FreeFormLayoutElementBackgroundStyle.Builder getBackgroundStyle() {
            return this.backgroundStyle != null ? this.backgroundStyle.toBuilder() : null;
        }

        public final void setBackgroundStyle(FreeFormLayoutElementBackgroundStyle.BuilderImpl backgroundStyle) {
            this.backgroundStyle = backgroundStyle != null ? backgroundStyle.build() : null;
        }

        @Override
        public final Builder backgroundStyle(FreeFormLayoutElementBackgroundStyle backgroundStyle) {
            this.backgroundStyle = backgroundStyle;
            return this;
        }

        public final LoadingAnimation.Builder getLoadingAnimation() {
            return this.loadingAnimation != null ? this.loadingAnimation.toBuilder() : null;
        }

        public final void setLoadingAnimation(LoadingAnimation.BuilderImpl loadingAnimation) {
            this.loadingAnimation = loadingAnimation != null ? loadingAnimation.build() : null;
        }

        @Override
        public final Builder loadingAnimation(LoadingAnimation loadingAnimation) {
            this.loadingAnimation = loadingAnimation;
            return this;
        }

        public final String getBorderRadius() {
            return this.borderRadius;
        }

        public final void setBorderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
        }

        @Override
        public final Builder borderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public final String getPadding() {
            return this.padding;
        }

        public final void setPadding(String padding) {
            this.padding = padding;
        }

        @Override
        public final Builder padding(String padding) {
            this.padding = padding;
            return this;
        }

        public FreeFormLayoutElement build() {
            return new FreeFormLayoutElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeFormLayoutElement> {
        public Builder elementId(String var1);

        public Builder elementType(String var1);

        public Builder elementType(LayoutElementType var1);

        public Builder xAxisLocation(String var1);

        public Builder yAxisLocation(String var1);

        public Builder width(String var1);

        public Builder height(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder renderingRules(Collection<SheetElementRenderingRule> var1);

        public Builder renderingRules(SheetElementRenderingRule ... var1);

        public Builder renderingRules(Consumer<SheetElementRenderingRule.Builder> ... var1);

        public Builder borderStyle(FreeFormLayoutElementBorderStyle var1);

        default public Builder borderStyle(Consumer<FreeFormLayoutElementBorderStyle.Builder> borderStyle) {
            return this.borderStyle((FreeFormLayoutElementBorderStyle)((FreeFormLayoutElementBorderStyle.Builder)FreeFormLayoutElementBorderStyle.builder().applyMutation(borderStyle)).build());
        }

        public Builder selectedBorderStyle(FreeFormLayoutElementBorderStyle var1);

        default public Builder selectedBorderStyle(Consumer<FreeFormLayoutElementBorderStyle.Builder> selectedBorderStyle) {
            return this.selectedBorderStyle((FreeFormLayoutElementBorderStyle)((FreeFormLayoutElementBorderStyle.Builder)FreeFormLayoutElementBorderStyle.builder().applyMutation(selectedBorderStyle)).build());
        }

        public Builder backgroundStyle(FreeFormLayoutElementBackgroundStyle var1);

        default public Builder backgroundStyle(Consumer<FreeFormLayoutElementBackgroundStyle.Builder> backgroundStyle) {
            return this.backgroundStyle((FreeFormLayoutElementBackgroundStyle)((FreeFormLayoutElementBackgroundStyle.Builder)FreeFormLayoutElementBackgroundStyle.builder().applyMutation(backgroundStyle)).build());
        }

        public Builder loadingAnimation(LoadingAnimation var1);

        default public Builder loadingAnimation(Consumer<LoadingAnimation.Builder> loadingAnimation) {
            return this.loadingAnimation((LoadingAnimation)((LoadingAnimation.Builder)LoadingAnimation.builder().applyMutation(loadingAnimation)).build());
        }

        public Builder borderRadius(String var1);

        public Builder padding(String var1);
    }
}

