/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionConnectorType {
    GENERIC_HTTP("GENERIC_HTTP"),
    SERVICENOW_NOW_PLATFORM("SERVICENOW_NOW_PLATFORM"),
    SALESFORCE_CRM("SALESFORCE_CRM"),
    MICROSOFT_OUTLOOK("MICROSOFT_OUTLOOK"),
    PAGERDUTY_ADVANCE("PAGERDUTY_ADVANCE"),
    JIRA_CLOUD("JIRA_CLOUD"),
    ATLASSIAN_CONFLUENCE("ATLASSIAN_CONFLUENCE"),
    AMAZON_S3("AMAZON_S3"),
    AMAZON_BEDROCK_AGENT_RUNTIME("AMAZON_BEDROCK_AGENT_RUNTIME"),
    AMAZON_BEDROCK_RUNTIME("AMAZON_BEDROCK_RUNTIME"),
    AMAZON_BEDROCK_DATA_AUTOMATION_RUNTIME("AMAZON_BEDROCK_DATA_AUTOMATION_RUNTIME"),
    AMAZON_TEXTRACT("AMAZON_TEXTRACT"),
    AMAZON_COMPREHEND("AMAZON_COMPREHEND"),
    AMAZON_COMPREHEND_MEDICAL("AMAZON_COMPREHEND_MEDICAL"),
    MICROSOFT_ONEDRIVE("MICROSOFT_ONEDRIVE"),
    MICROSOFT_SHAREPOINT("MICROSOFT_SHAREPOINT"),
    MICROSOFT_TEAMS("MICROSOFT_TEAMS"),
    SAP_BUSINESSPARTNER("SAP_BUSINESSPARTNER"),
    SAP_PRODUCTMASTERDATA("SAP_PRODUCTMASTERDATA"),
    SAP_PHYSICALINVENTORY("SAP_PHYSICALINVENTORY"),
    SAP_BILLOFMATERIALS("SAP_BILLOFMATERIALS"),
    SAP_MATERIALSTOCK("SAP_MATERIALSTOCK"),
    ZENDESK_SUITE("ZENDESK_SUITE"),
    SMARTSHEET("SMARTSHEET"),
    SLACK("SLACK"),
    ASANA("ASANA"),
    BAMBOO_HR("BAMBOO_HR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionConnectorType> VALUE_MAP;
    private final String value;

    private ActionConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionConnectorType> knownValues() {
        EnumSet<ActionConnectorType> knownValues = EnumSet.allOf(ActionConnectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionConnectorType.class, ActionConnectorType::toString);
    }
}

