/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebCrawlerAuthType {
    NO_AUTH("NO_AUTH"),
    BASIC_AUTH("BASIC_AUTH"),
    FORM("FORM"),
    SAML("SAML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebCrawlerAuthType> VALUE_MAP;
    private final String value;

    private WebCrawlerAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebCrawlerAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebCrawlerAuthType> knownValues() {
        EnumSet<WebCrawlerAuthType> knownValues = EnumSet.allOf(WebCrawlerAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebCrawlerAuthType.class, WebCrawlerAuthType::toString);
    }
}

