/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserIdentifier> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(UserIdentifier.getter(UserIdentifier::userName)).setter(UserIdentifier.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(UserIdentifier.getter(UserIdentifier::email)).setter(UserIdentifier.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserArn").getter(UserIdentifier.getter(UserIdentifier::userArn)).setter(UserIdentifier.setter(Builder::userArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, EMAIL_FIELD, USER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String email;
    private final String userArn;
    private final Type type;

    private UserIdentifier(BuilderImpl builder) {
        this.userName = builder.userName;
        this.email = builder.email;
        this.userArn = builder.userArn;
        this.type = builder.type;
    }

    public final String userName() {
        return this.userName;
    }

    public final String email() {
        return this.email;
    }

    public final String userArn() {
        return this.userArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentifier)) {
            return false;
        }
        UserIdentifier other = (UserIdentifier)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.userArn(), other.userArn());
    }

    public final String toString() {
        return ToString.builder((String)"UserIdentifier").add("UserName", (Object)(this.userName() == null ? null : "*** Sensitive Data Redacted ***")).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("UserArn", (Object)this.userArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "UserArn": {
                return Optional.ofNullable(clazz.cast(this.userArn()));
            }
        }
        return Optional.empty();
    }

    public static UserIdentifier fromUserName(String userName) {
        return (UserIdentifier)UserIdentifier.builder().userName(userName).build();
    }

    public static UserIdentifier fromEmail(String email) {
        return (UserIdentifier)UserIdentifier.builder().email(email).build();
    }

    public static UserIdentifier fromUserArn(String userArn) {
        return (UserIdentifier)UserIdentifier.builder().userArn(userArn).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("UserArn", USER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserIdentifier, T> g) {
        return obj -> g.apply((UserIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        USER_NAME,
        EMAIL,
        USER_ARN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String email;
        private String userArn;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentifier model) {
            this.userName(model.userName);
            this.email(model.email);
            this.userArn(model.userArn);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            String oldValue = this.userName;
            this.userName = userName;
            this.handleUnionValueChange(Type.USER_NAME, oldValue, this.userName);
        }

        @Override
        public final Builder userName(String userName) {
            String oldValue = this.userName;
            this.userName = userName;
            this.handleUnionValueChange(Type.USER_NAME, oldValue, this.userName);
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            String oldValue = this.email;
            this.email = email;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(String email) {
            String oldValue = this.email;
            this.email = email;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        public final String getUserArn() {
            return this.userArn;
        }

        public final void setUserArn(String userArn) {
            String oldValue = this.userArn;
            this.userArn = userArn;
            this.handleUnionValueChange(Type.USER_ARN, oldValue, this.userArn);
        }

        @Override
        public final Builder userArn(String userArn) {
            String oldValue = this.userArn;
            this.userArn = userArn;
            this.handleUnionValueChange(Type.USER_ARN, oldValue, this.userArn);
            return this;
        }

        public UserIdentifier build() {
            return new UserIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserIdentifier> {
        public Builder userName(String var1);

        public Builder email(String var1);

        public Builder userArn(String var1);
    }
}

