/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisBinding;
import software.amazon.awssdk.services.quicksight.model.DecalSettings;
import software.amazon.awssdk.services.quicksight.model.LineChartLineStyleSettings;
import software.amazon.awssdk.services.quicksight.model.LineChartMarkerStyleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineChartDefaultSeriesSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineChartDefaultSeriesSettings> {
    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisBinding").getter(LineChartDefaultSeriesSettings.getter(LineChartDefaultSeriesSettings::axisBindingAsString)).setter(LineChartDefaultSeriesSettings.setter(Builder::axisBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()}).build();
    private static final SdkField<LineChartLineStyleSettings> LINE_STYLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LineStyleSettings").getter(LineChartDefaultSeriesSettings.getter(LineChartDefaultSeriesSettings::lineStyleSettings)).setter(LineChartDefaultSeriesSettings.setter(Builder::lineStyleSettings)).constructor(LineChartLineStyleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineStyleSettings").build()}).build();
    private static final SdkField<LineChartMarkerStyleSettings> MARKER_STYLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MarkerStyleSettings").getter(LineChartDefaultSeriesSettings.getter(LineChartDefaultSeriesSettings::markerStyleSettings)).setter(LineChartDefaultSeriesSettings.setter(Builder::markerStyleSettings)).constructor(LineChartMarkerStyleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkerStyleSettings").build()}).build();
    private static final SdkField<DecalSettings> DECAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DecalSettings").getter(LineChartDefaultSeriesSettings.getter(LineChartDefaultSeriesSettings::decalSettings)).setter(LineChartDefaultSeriesSettings.setter(Builder::decalSettings)).constructor(DecalSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecalSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AXIS_BINDING_FIELD, LINE_STYLE_SETTINGS_FIELD, MARKER_STYLE_SETTINGS_FIELD, DECAL_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineChartDefaultSeriesSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String axisBinding;
    private final LineChartLineStyleSettings lineStyleSettings;
    private final LineChartMarkerStyleSettings markerStyleSettings;
    private final DecalSettings decalSettings;

    private LineChartDefaultSeriesSettings(BuilderImpl builder) {
        this.axisBinding = builder.axisBinding;
        this.lineStyleSettings = builder.lineStyleSettings;
        this.markerStyleSettings = builder.markerStyleSettings;
        this.decalSettings = builder.decalSettings;
    }

    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(this.axisBinding);
    }

    public final String axisBindingAsString() {
        return this.axisBinding;
    }

    public final LineChartLineStyleSettings lineStyleSettings() {
        return this.lineStyleSettings;
    }

    public final LineChartMarkerStyleSettings markerStyleSettings() {
        return this.markerStyleSettings;
    }

    public final DecalSettings decalSettings() {
        return this.decalSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.axisBindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineStyleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.markerStyleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.decalSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartDefaultSeriesSettings)) {
            return false;
        }
        LineChartDefaultSeriesSettings other = (LineChartDefaultSeriesSettings)obj;
        return Objects.equals(this.axisBindingAsString(), other.axisBindingAsString()) && Objects.equals(this.lineStyleSettings(), other.lineStyleSettings()) && Objects.equals(this.markerStyleSettings(), other.markerStyleSettings()) && Objects.equals(this.decalSettings(), other.decalSettings());
    }

    public final String toString() {
        return ToString.builder((String)"LineChartDefaultSeriesSettings").add("AxisBinding", (Object)this.axisBindingAsString()).add("LineStyleSettings", (Object)this.lineStyleSettings()).add("MarkerStyleSettings", (Object)this.markerStyleSettings()).add("DecalSettings", (Object)this.decalSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AxisBinding": {
                return Optional.ofNullable(clazz.cast(this.axisBindingAsString()));
            }
            case "LineStyleSettings": {
                return Optional.ofNullable(clazz.cast(this.lineStyleSettings()));
            }
            case "MarkerStyleSettings": {
                return Optional.ofNullable(clazz.cast(this.markerStyleSettings()));
            }
            case "DecalSettings": {
                return Optional.ofNullable(clazz.cast(this.decalSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AxisBinding", AXIS_BINDING_FIELD);
        map.put("LineStyleSettings", LINE_STYLE_SETTINGS_FIELD);
        map.put("MarkerStyleSettings", MARKER_STYLE_SETTINGS_FIELD);
        map.put("DecalSettings", DECAL_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartDefaultSeriesSettings, T> g) {
        return obj -> g.apply((LineChartDefaultSeriesSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String axisBinding;
        private LineChartLineStyleSettings lineStyleSettings;
        private LineChartMarkerStyleSettings markerStyleSettings;
        private DecalSettings decalSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartDefaultSeriesSettings model) {
            this.axisBinding(model.axisBinding);
            this.lineStyleSettings(model.lineStyleSettings);
            this.markerStyleSettings(model.markerStyleSettings);
            this.decalSettings(model.decalSettings);
        }

        public final String getAxisBinding() {
            return this.axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        public final LineChartLineStyleSettings.Builder getLineStyleSettings() {
            return this.lineStyleSettings != null ? this.lineStyleSettings.toBuilder() : null;
        }

        public final void setLineStyleSettings(LineChartLineStyleSettings.BuilderImpl lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings != null ? lineStyleSettings.build() : null;
        }

        @Override
        public final Builder lineStyleSettings(LineChartLineStyleSettings lineStyleSettings) {
            this.lineStyleSettings = lineStyleSettings;
            return this;
        }

        public final LineChartMarkerStyleSettings.Builder getMarkerStyleSettings() {
            return this.markerStyleSettings != null ? this.markerStyleSettings.toBuilder() : null;
        }

        public final void setMarkerStyleSettings(LineChartMarkerStyleSettings.BuilderImpl markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings != null ? markerStyleSettings.build() : null;
        }

        @Override
        public final Builder markerStyleSettings(LineChartMarkerStyleSettings markerStyleSettings) {
            this.markerStyleSettings = markerStyleSettings;
            return this;
        }

        public final DecalSettings.Builder getDecalSettings() {
            return this.decalSettings != null ? this.decalSettings.toBuilder() : null;
        }

        public final void setDecalSettings(DecalSettings.BuilderImpl decalSettings) {
            this.decalSettings = decalSettings != null ? decalSettings.build() : null;
        }

        @Override
        public final Builder decalSettings(DecalSettings decalSettings) {
            this.decalSettings = decalSettings;
            return this;
        }

        public LineChartDefaultSeriesSettings build() {
            return new LineChartDefaultSeriesSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineChartDefaultSeriesSettings> {
        public Builder axisBinding(String var1);

        public Builder axisBinding(AxisBinding var1);

        public Builder lineStyleSettings(LineChartLineStyleSettings var1);

        default public Builder lineStyleSettings(Consumer<LineChartLineStyleSettings.Builder> lineStyleSettings) {
            return this.lineStyleSettings((LineChartLineStyleSettings)((LineChartLineStyleSettings.Builder)LineChartLineStyleSettings.builder().applyMutation(lineStyleSettings)).build());
        }

        public Builder markerStyleSettings(LineChartMarkerStyleSettings var1);

        default public Builder markerStyleSettings(Consumer<LineChartMarkerStyleSettings.Builder> markerStyleSettings) {
            return this.markerStyleSettings((LineChartMarkerStyleSettings)((LineChartMarkerStyleSettings.Builder)LineChartMarkerStyleSettings.builder().applyMutation(markerStyleSettings)).build());
        }

        public Builder decalSettings(DecalSettings var1);

        default public Builder decalSettings(Consumer<DecalSettings.Builder> decalSettings) {
            return this.decalSettings((DecalSettings)((DecalSettings.Builder)DecalSettings.builder().applyMutation(decalSettings)).build());
        }
    }
}

