/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GridLayoutElementBackgroundStyle;
import software.amazon.awssdk.services.quicksight.model.GridLayoutElementBorderStyle;
import software.amazon.awssdk.services.quicksight.model.LayoutElementType;
import software.amazon.awssdk.services.quicksight.model.LoadingAnimation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GridLayoutElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GridLayoutElement> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementId").getter(GridLayoutElement.getter(GridLayoutElement::elementId)).setter(GridLayoutElement.setter(Builder::elementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementId").build()}).build();
    private static final SdkField<String> ELEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElementType").getter(GridLayoutElement.getter(GridLayoutElement::elementTypeAsString)).setter(GridLayoutElement.setter(Builder::elementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementType").build()}).build();
    private static final SdkField<Integer> COLUMN_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnIndex").getter(GridLayoutElement.getter(GridLayoutElement::columnIndex)).setter(GridLayoutElement.setter(Builder::columnIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIndex").build()}).build();
    private static final SdkField<Integer> COLUMN_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ColumnSpan").getter(GridLayoutElement.getter(GridLayoutElement::columnSpan)).setter(GridLayoutElement.setter(Builder::columnSpan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSpan").build()}).build();
    private static final SdkField<Integer> ROW_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowIndex").getter(GridLayoutElement.getter(GridLayoutElement::rowIndex)).setter(GridLayoutElement.setter(Builder::rowIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowIndex").build()}).build();
    private static final SdkField<Integer> ROW_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RowSpan").getter(GridLayoutElement.getter(GridLayoutElement::rowSpan)).setter(GridLayoutElement.setter(Builder::rowSpan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSpan").build()}).build();
    private static final SdkField<GridLayoutElementBorderStyle> BORDER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BorderStyle").getter(GridLayoutElement.getter(GridLayoutElement::borderStyle)).setter(GridLayoutElement.setter(Builder::borderStyle)).constructor(GridLayoutElementBorderStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderStyle").build()}).build();
    private static final SdkField<GridLayoutElementBorderStyle> SELECTED_BORDER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectedBorderStyle").getter(GridLayoutElement.getter(GridLayoutElement::selectedBorderStyle)).setter(GridLayoutElement.setter(Builder::selectedBorderStyle)).constructor(GridLayoutElementBorderStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedBorderStyle").build()}).build();
    private static final SdkField<GridLayoutElementBackgroundStyle> BACKGROUND_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackgroundStyle").getter(GridLayoutElement.getter(GridLayoutElement::backgroundStyle)).setter(GridLayoutElement.setter(Builder::backgroundStyle)).constructor(GridLayoutElementBackgroundStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundStyle").build()}).build();
    private static final SdkField<LoadingAnimation> LOADING_ANIMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoadingAnimation").getter(GridLayoutElement.getter(GridLayoutElement::loadingAnimation)).setter(GridLayoutElement.setter(Builder::loadingAnimation)).constructor(LoadingAnimation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadingAnimation").build()}).build();
    private static final SdkField<String> BORDER_RADIUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderRadius").getter(GridLayoutElement.getter(GridLayoutElement::borderRadius)).setter(GridLayoutElement.setter(Builder::borderRadius)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderRadius").build()}).build();
    private static final SdkField<String> PADDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Padding").getter(GridLayoutElement.getter(GridLayoutElement::padding)).setter(GridLayoutElement.setter(Builder::padding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Padding").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD, ELEMENT_TYPE_FIELD, COLUMN_INDEX_FIELD, COLUMN_SPAN_FIELD, ROW_INDEX_FIELD, ROW_SPAN_FIELD, BORDER_STYLE_FIELD, SELECTED_BORDER_STYLE_FIELD, BACKGROUND_STYLE_FIELD, LOADING_ANIMATION_FIELD, BORDER_RADIUS_FIELD, PADDING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GridLayoutElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String elementId;
    private final String elementType;
    private final Integer columnIndex;
    private final Integer columnSpan;
    private final Integer rowIndex;
    private final Integer rowSpan;
    private final GridLayoutElementBorderStyle borderStyle;
    private final GridLayoutElementBorderStyle selectedBorderStyle;
    private final GridLayoutElementBackgroundStyle backgroundStyle;
    private final LoadingAnimation loadingAnimation;
    private final String borderRadius;
    private final String padding;

    private GridLayoutElement(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.elementType = builder.elementType;
        this.columnIndex = builder.columnIndex;
        this.columnSpan = builder.columnSpan;
        this.rowIndex = builder.rowIndex;
        this.rowSpan = builder.rowSpan;
        this.borderStyle = builder.borderStyle;
        this.selectedBorderStyle = builder.selectedBorderStyle;
        this.backgroundStyle = builder.backgroundStyle;
        this.loadingAnimation = builder.loadingAnimation;
        this.borderRadius = builder.borderRadius;
        this.padding = builder.padding;
    }

    public final String elementId() {
        return this.elementId;
    }

    public final LayoutElementType elementType() {
        return LayoutElementType.fromValue(this.elementType);
    }

    public final String elementTypeAsString() {
        return this.elementType;
    }

    public final Integer columnIndex() {
        return this.columnIndex;
    }

    public final Integer columnSpan() {
        return this.columnSpan;
    }

    public final Integer rowIndex() {
        return this.rowIndex;
    }

    public final Integer rowSpan() {
        return this.rowSpan;
    }

    public final GridLayoutElementBorderStyle borderStyle() {
        return this.borderStyle;
    }

    public final GridLayoutElementBorderStyle selectedBorderStyle() {
        return this.selectedBorderStyle;
    }

    public final GridLayoutElementBackgroundStyle backgroundStyle() {
        return this.backgroundStyle;
    }

    public final LoadingAnimation loadingAnimation() {
        return this.loadingAnimation;
    }

    public final String borderRadius() {
        return this.borderRadius;
    }

    public final String padding() {
        return this.padding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.elementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedBorderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadingAnimation());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderRadius());
        hashCode = 31 * hashCode + Objects.hashCode(this.padding());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutElement)) {
            return false;
        }
        GridLayoutElement other = (GridLayoutElement)obj;
        return Objects.equals(this.elementId(), other.elementId()) && Objects.equals(this.elementTypeAsString(), other.elementTypeAsString()) && Objects.equals(this.columnIndex(), other.columnIndex()) && Objects.equals(this.columnSpan(), other.columnSpan()) && Objects.equals(this.rowIndex(), other.rowIndex()) && Objects.equals(this.rowSpan(), other.rowSpan()) && Objects.equals(this.borderStyle(), other.borderStyle()) && Objects.equals(this.selectedBorderStyle(), other.selectedBorderStyle()) && Objects.equals(this.backgroundStyle(), other.backgroundStyle()) && Objects.equals(this.loadingAnimation(), other.loadingAnimation()) && Objects.equals(this.borderRadius(), other.borderRadius()) && Objects.equals(this.padding(), other.padding());
    }

    public final String toString() {
        return ToString.builder((String)"GridLayoutElement").add("ElementId", (Object)this.elementId()).add("ElementType", (Object)this.elementTypeAsString()).add("ColumnIndex", (Object)this.columnIndex()).add("ColumnSpan", (Object)this.columnSpan()).add("RowIndex", (Object)this.rowIndex()).add("RowSpan", (Object)this.rowSpan()).add("BorderStyle", (Object)this.borderStyle()).add("SelectedBorderStyle", (Object)this.selectedBorderStyle()).add("BackgroundStyle", (Object)this.backgroundStyle()).add("LoadingAnimation", (Object)this.loadingAnimation()).add("BorderRadius", (Object)this.borderRadius()).add("Padding", (Object)this.padding()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElementId": {
                return Optional.ofNullable(clazz.cast(this.elementId()));
            }
            case "ElementType": {
                return Optional.ofNullable(clazz.cast(this.elementTypeAsString()));
            }
            case "ColumnIndex": {
                return Optional.ofNullable(clazz.cast(this.columnIndex()));
            }
            case "ColumnSpan": {
                return Optional.ofNullable(clazz.cast(this.columnSpan()));
            }
            case "RowIndex": {
                return Optional.ofNullable(clazz.cast(this.rowIndex()));
            }
            case "RowSpan": {
                return Optional.ofNullable(clazz.cast(this.rowSpan()));
            }
            case "BorderStyle": {
                return Optional.ofNullable(clazz.cast(this.borderStyle()));
            }
            case "SelectedBorderStyle": {
                return Optional.ofNullable(clazz.cast(this.selectedBorderStyle()));
            }
            case "BackgroundStyle": {
                return Optional.ofNullable(clazz.cast(this.backgroundStyle()));
            }
            case "LoadingAnimation": {
                return Optional.ofNullable(clazz.cast(this.loadingAnimation()));
            }
            case "BorderRadius": {
                return Optional.ofNullable(clazz.cast(this.borderRadius()));
            }
            case "Padding": {
                return Optional.ofNullable(clazz.cast(this.padding()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ElementId", ELEMENT_ID_FIELD);
        map.put("ElementType", ELEMENT_TYPE_FIELD);
        map.put("ColumnIndex", COLUMN_INDEX_FIELD);
        map.put("ColumnSpan", COLUMN_SPAN_FIELD);
        map.put("RowIndex", ROW_INDEX_FIELD);
        map.put("RowSpan", ROW_SPAN_FIELD);
        map.put("BorderStyle", BORDER_STYLE_FIELD);
        map.put("SelectedBorderStyle", SELECTED_BORDER_STYLE_FIELD);
        map.put("BackgroundStyle", BACKGROUND_STYLE_FIELD);
        map.put("LoadingAnimation", LOADING_ANIMATION_FIELD);
        map.put("BorderRadius", BORDER_RADIUS_FIELD);
        map.put("Padding", PADDING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutElement, T> g) {
        return obj -> g.apply((GridLayoutElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elementId;
        private String elementType;
        private Integer columnIndex;
        private Integer columnSpan;
        private Integer rowIndex;
        private Integer rowSpan;
        private GridLayoutElementBorderStyle borderStyle;
        private GridLayoutElementBorderStyle selectedBorderStyle;
        private GridLayoutElementBackgroundStyle backgroundStyle;
        private LoadingAnimation loadingAnimation;
        private String borderRadius;
        private String padding;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutElement model) {
            this.elementId(model.elementId);
            this.elementType(model.elementType);
            this.columnIndex(model.columnIndex);
            this.columnSpan(model.columnSpan);
            this.rowIndex(model.rowIndex);
            this.rowSpan(model.rowSpan);
            this.borderStyle(model.borderStyle);
            this.selectedBorderStyle(model.selectedBorderStyle);
            this.backgroundStyle(model.backgroundStyle);
            this.loadingAnimation(model.loadingAnimation);
            this.borderRadius(model.borderRadius);
            this.padding(model.padding);
        }

        public final String getElementId() {
            return this.elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final String getElementType() {
            return this.elementType;
        }

        public final void setElementType(String elementType) {
            this.elementType = elementType;
        }

        @Override
        public final Builder elementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        @Override
        public final Builder elementType(LayoutElementType elementType) {
            this.elementType(elementType == null ? null : elementType.toString());
            return this;
        }

        public final Integer getColumnIndex() {
            return this.columnIndex;
        }

        public final void setColumnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public final Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }

        public final Integer getColumnSpan() {
            return this.columnSpan;
        }

        public final void setColumnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
        }

        @Override
        public final Builder columnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        public final Integer getRowIndex() {
            return this.rowIndex;
        }

        public final void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public final Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public final Integer getRowSpan() {
            return this.rowSpan;
        }

        public final void setRowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
        }

        @Override
        public final Builder rowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        public final GridLayoutElementBorderStyle.Builder getBorderStyle() {
            return this.borderStyle != null ? this.borderStyle.toBuilder() : null;
        }

        public final void setBorderStyle(GridLayoutElementBorderStyle.BuilderImpl borderStyle) {
            this.borderStyle = borderStyle != null ? borderStyle.build() : null;
        }

        @Override
        public final Builder borderStyle(GridLayoutElementBorderStyle borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        public final GridLayoutElementBorderStyle.Builder getSelectedBorderStyle() {
            return this.selectedBorderStyle != null ? this.selectedBorderStyle.toBuilder() : null;
        }

        public final void setSelectedBorderStyle(GridLayoutElementBorderStyle.BuilderImpl selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle != null ? selectedBorderStyle.build() : null;
        }

        @Override
        public final Builder selectedBorderStyle(GridLayoutElementBorderStyle selectedBorderStyle) {
            this.selectedBorderStyle = selectedBorderStyle;
            return this;
        }

        public final GridLayoutElementBackgroundStyle.Builder getBackgroundStyle() {
            return this.backgroundStyle != null ? this.backgroundStyle.toBuilder() : null;
        }

        public final void setBackgroundStyle(GridLayoutElementBackgroundStyle.BuilderImpl backgroundStyle) {
            this.backgroundStyle = backgroundStyle != null ? backgroundStyle.build() : null;
        }

        @Override
        public final Builder backgroundStyle(GridLayoutElementBackgroundStyle backgroundStyle) {
            this.backgroundStyle = backgroundStyle;
            return this;
        }

        public final LoadingAnimation.Builder getLoadingAnimation() {
            return this.loadingAnimation != null ? this.loadingAnimation.toBuilder() : null;
        }

        public final void setLoadingAnimation(LoadingAnimation.BuilderImpl loadingAnimation) {
            this.loadingAnimation = loadingAnimation != null ? loadingAnimation.build() : null;
        }

        @Override
        public final Builder loadingAnimation(LoadingAnimation loadingAnimation) {
            this.loadingAnimation = loadingAnimation;
            return this;
        }

        public final String getBorderRadius() {
            return this.borderRadius;
        }

        public final void setBorderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
        }

        @Override
        public final Builder borderRadius(String borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public final String getPadding() {
            return this.padding;
        }

        public final void setPadding(String padding) {
            this.padding = padding;
        }

        @Override
        public final Builder padding(String padding) {
            this.padding = padding;
            return this;
        }

        public GridLayoutElement build() {
            return new GridLayoutElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GridLayoutElement> {
        public Builder elementId(String var1);

        public Builder elementType(String var1);

        public Builder elementType(LayoutElementType var1);

        public Builder columnIndex(Integer var1);

        public Builder columnSpan(Integer var1);

        public Builder rowIndex(Integer var1);

        public Builder rowSpan(Integer var1);

        public Builder borderStyle(GridLayoutElementBorderStyle var1);

        default public Builder borderStyle(Consumer<GridLayoutElementBorderStyle.Builder> borderStyle) {
            return this.borderStyle((GridLayoutElementBorderStyle)((GridLayoutElementBorderStyle.Builder)GridLayoutElementBorderStyle.builder().applyMutation(borderStyle)).build());
        }

        public Builder selectedBorderStyle(GridLayoutElementBorderStyle var1);

        default public Builder selectedBorderStyle(Consumer<GridLayoutElementBorderStyle.Builder> selectedBorderStyle) {
            return this.selectedBorderStyle((GridLayoutElementBorderStyle)((GridLayoutElementBorderStyle.Builder)GridLayoutElementBorderStyle.builder().applyMutation(selectedBorderStyle)).build());
        }

        public Builder backgroundStyle(GridLayoutElementBackgroundStyle var1);

        default public Builder backgroundStyle(Consumer<GridLayoutElementBackgroundStyle.Builder> backgroundStyle) {
            return this.backgroundStyle((GridLayoutElementBackgroundStyle)((GridLayoutElementBackgroundStyle.Builder)GridLayoutElementBackgroundStyle.builder().applyMutation(backgroundStyle)).build());
        }

        public Builder loadingAnimation(LoadingAnimation var1);

        default public Builder loadingAnimation(Consumer<LoadingAnimation.Builder> loadingAnimation) {
            return this.loadingAnimation((LoadingAnimation)((LoadingAnimation.Builder)LoadingAnimation.builder().applyMutation(loadingAnimation)).build());
        }

        public Builder borderRadius(String var1);

        public Builder padding(String var1);
    }
}

