/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnalysisRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateAnalysisRequest.Builder, UpdateAnalysisRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateAnalysisRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(UpdateAnalysisRequest::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAnalysisRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .memberName("Parameters").getter(getter(UpdateAnalysisRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<AnalysisSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<AnalysisSourceEntity> builder(MarshallingType.SDK_POJO).memberName("SourceEntity")
            .getter(getter(UpdateAnalysisRequest::sourceEntity)).setter(setter(Builder::sourceEntity))
            .constructor(AnalysisSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(UpdateAnalysisRequest::themeArn)).setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final SdkField<AnalysisDefinition> DEFINITION_FIELD = SdkField
            .<AnalysisDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(UpdateAnalysisRequest::definition)).setter(setter(Builder::definition))
            .constructor(AnalysisDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<ValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField
            .<ValidationStrategy> builder(MarshallingType.SDK_POJO).memberName("ValidationStrategy")
            .getter(getter(UpdateAnalysisRequest::validationStrategy)).setter(setter(Builder::validationStrategy))
            .constructor(ValidationStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ANALYSIS_ID_FIELD, NAME_FIELD, PARAMETERS_FIELD, SOURCE_ENTITY_FIELD, THEME_ARN_FIELD, DEFINITION_FIELD,
            VALIDATION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String analysisId;

    private final String name;

    private final Parameters parameters;

    private final AnalysisSourceEntity sourceEntity;

    private final String themeArn;

    private final AnalysisDefinition definition;

    private final ValidationStrategy validationStrategy;

    private UpdateAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.sourceEntity = builder.sourceEntity;
        this.themeArn = builder.themeArn;
        this.definition = builder.definition;
        this.validationStrategy = builder.validationStrategy;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the analysis that you're updating.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the analysis that you're updating.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
     * </p>
     * 
     * @return The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * A descriptive name for the analysis that you're updating. This name displays for the analysis in the QuickSight
     * console.
     * </p>
     * 
     * @return A descriptive name for the analysis that you're updating. This name displays for the analysis in the
     *         QuickSight console.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The parameter names and override values that you want to use. An analysis can have any parameter type, and some
     * parameters might accept multiple values.
     * </p>
     * 
     * @return The parameter names and override values that you want to use. An analysis can have any parameter type,
     *         and some parameters might accept multiple values.
     */
    public final Parameters parameters() {
        return parameters;
    }

    /**
     * <p>
     * A source entity to use for the analysis that you're updating. This metadata structure contains details that
     * describe a source template and one or more datasets.
     * </p>
     * 
     * @return A source entity to use for the analysis that you're updating. This metadata structure contains details
     *         that describe a source template and one or more datasets.
     */
    public final AnalysisSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme in
     * the QuickSight console, make sure that you have access to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the
     *         theme in the QuickSight console, make sure that you have access to it.
     */
    public final String themeArn() {
        return themeArn;
    }

    /**
     * <p>
     * The definition of an analysis.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * 
     * @return The definition of an analysis.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     */
    public final AnalysisDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The option to relax the validation needed to update an analysis with definition objects. This skips the
     * validation step for specific errors.
     * </p>
     * 
     * @return The option to relax the validation needed to update an analysis with definition objects. This skips the
     *         validation step for specific errors.
     */
    public final ValidationStrategy validationStrategy() {
        return validationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(validationStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalysisRequest)) {
            return false;
        }
        UpdateAnalysisRequest other = (UpdateAnalysisRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(analysisId(), other.analysisId())
                && Objects.equals(name(), other.name()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(sourceEntity(), other.sourceEntity()) && Objects.equals(themeArn(), other.themeArn())
                && Objects.equals(definition(), other.definition())
                && Objects.equals(validationStrategy(), other.validationStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnalysisRequest").add("AwsAccountId", awsAccountId()).add("AnalysisId", analysisId())
                .add("Name", name()).add("Parameters", parameters()).add("SourceEntity", sourceEntity())
                .add("ThemeArn", themeArn()).add("Definition", definition()).add("ValidationStrategy", validationStrategy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "ValidationStrategy":
            return Optional.ofNullable(clazz.cast(validationStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("SourceEntity", SOURCE_ENTITY_FIELD);
        map.put("ThemeArn", THEME_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalysisRequest, T> g) {
        return obj -> g.apply((UpdateAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnalysisRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the analysis that you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the analysis that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
         * </p>
         * 
         * @param analysisId
         *        The ID for the analysis that you're updating. This ID displays in the URL of the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * A descriptive name for the analysis that you're updating. This name displays for the analysis in the
         * QuickSight console.
         * </p>
         * 
         * @param name
         *        A descriptive name for the analysis that you're updating. This name displays for the analysis in the
         *        QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameter names and override values that you want to use. An analysis can have any parameter type, and
         * some parameters might accept multiple values.
         * </p>
         * 
         * @param parameters
         *        The parameter names and override values that you want to use. An analysis can have any parameter type,
         *        and some parameters might accept multiple values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * <p>
         * The parameter names and override values that you want to use. An analysis can have any parameter type, and
         * some parameters might accept multiple values.
         * </p>
         * This is a convenience method that creates an instance of the {@link Parameters.Builder} avoiding the need to
         * create one manually via {@link Parameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * A source entity to use for the analysis that you're updating. This metadata structure contains details that
         * describe a source template and one or more datasets.
         * </p>
         * 
         * @param sourceEntity
         *        A source entity to use for the analysis that you're updating. This metadata structure contains details
         *        that describe a source template and one or more datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(AnalysisSourceEntity sourceEntity);

        /**
         * <p>
         * A source entity to use for the analysis that you're updating. This metadata structure contains details that
         * describe a source template and one or more datasets.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSourceEntity.Builder} avoiding
         * the need to create one manually via {@link AnalysisSourceEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(AnalysisSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link AnalysisSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(AnalysisSourceEntity)
         */
        default Builder sourceEntity(Consumer<AnalysisSourceEntity.Builder> sourceEntity) {
            return sourceEntity(AnalysisSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the theme
         * in the QuickSight console, make sure that you have access to it.
         * </p>
         * 
         * @param themeArn
         *        The Amazon Resource Name (ARN) for the theme to apply to the analysis that you're creating. To see the
         *        theme in the QuickSight console, make sure that you have access to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        /**
         * <p>
         * The definition of an analysis.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * 
         * @param definition
         *        The definition of an analysis.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(AnalysisDefinition definition);

        /**
         * <p>
         * The definition of an analysis.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisDefinition.Builder} avoiding the
         * need to create one manually via {@link AnalysisDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(AnalysisDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link AnalysisDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(AnalysisDefinition)
         */
        default Builder definition(Consumer<AnalysisDefinition.Builder> definition) {
            return definition(AnalysisDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The option to relax the validation needed to update an analysis with definition objects. This skips the
         * validation step for specific errors.
         * </p>
         * 
         * @param validationStrategy
         *        The option to relax the validation needed to update an analysis with definition objects. This skips
         *        the validation step for specific errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStrategy(ValidationStrategy validationStrategy);

        /**
         * <p>
         * The option to relax the validation needed to update an analysis with definition objects. This skips the
         * validation step for specific errors.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationStrategy.Builder} avoiding the
         * need to create one manually via {@link ValidationStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #validationStrategy(ValidationStrategy)}.
         * 
         * @param validationStrategy
         *        a consumer that will call methods on {@link ValidationStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationStrategy(ValidationStrategy)
         */
        default Builder validationStrategy(Consumer<ValidationStrategy.Builder> validationStrategy) {
            return validationStrategy(ValidationStrategy.builder().applyMutation(validationStrategy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String analysisId;

        private String name;

        private Parameters parameters;

        private AnalysisSourceEntity sourceEntity;

        private String themeArn;

        private AnalysisDefinition definition;

        private ValidationStrategy validationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalysisRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            analysisId(model.analysisId);
            name(model.name);
            parameters(model.parameters);
            sourceEntity(model.sourceEntity);
            themeArn(model.themeArn);
            definition(model.definition);
            validationStrategy(model.validationStrategy);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final AnalysisSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(AnalysisSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(AnalysisSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final AnalysisDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(AnalysisDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(AnalysisDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final ValidationStrategy.Builder getValidationStrategy() {
            return validationStrategy != null ? validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(ValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnalysisRequest build() {
            return new UpdateAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
