/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of a <code>TopicIRComparisonMethod</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIRComparisonMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicIRComparisonMethod.Builder, TopicIRComparisonMethod> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TopicIRComparisonMethod::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Period")
            .getter(getter(TopicIRComparisonMethod::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<Integer> WINDOW_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WindowSize").getter(getter(TopicIRComparisonMethod::windowSize)).setter(setter(Builder::windowSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PERIOD_FIELD,
            WINDOW_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String period;

    private final Integer windowSize;

    private TopicIRComparisonMethod(BuilderImpl builder) {
        this.type = builder.type;
        this.period = builder.period;
        this.windowSize = builder.windowSize;
    }

    /**
     * <p>
     * The type for the <code>TopicIRComparisonMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComparisonMethodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type for the <code>TopicIRComparisonMethod</code>.
     * @see ComparisonMethodType
     */
    public final ComparisonMethodType type() {
        return ComparisonMethodType.fromValue(type);
    }

    /**
     * <p>
     * The type for the <code>TopicIRComparisonMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ComparisonMethodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type for the <code>TopicIRComparisonMethod</code>.
     * @see ComparisonMethodType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The period for the <code>TopicIRComparisonMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return The period for the <code>TopicIRComparisonMethod</code>.
     * @see TopicTimeGranularity
     */
    public final TopicTimeGranularity period() {
        return TopicTimeGranularity.fromValue(period);
    }

    /**
     * <p>
     * The period for the <code>TopicIRComparisonMethod</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link TopicTimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAsString}.
     * </p>
     * 
     * @return The period for the <code>TopicIRComparisonMethod</code>.
     * @see TopicTimeGranularity
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The window size for the <code>TopicIRComparisonMethod</code>.
     * </p>
     * 
     * @return The window size for the <code>TopicIRComparisonMethod</code>.
     */
    public final Integer windowSize() {
        return windowSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(windowSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRComparisonMethod)) {
            return false;
        }
        TopicIRComparisonMethod other = (TopicIRComparisonMethod) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(periodAsString(), other.periodAsString())
                && Objects.equals(windowSize(), other.windowSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicIRComparisonMethod").add("Type", typeAsString()).add("Period", periodAsString())
                .add("WindowSize", windowSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "WindowSize":
            return Optional.ofNullable(clazz.cast(windowSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("WindowSize", WINDOW_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRComparisonMethod, T> g) {
        return obj -> g.apply((TopicIRComparisonMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIRComparisonMethod> {
        /**
         * <p>
         * The type for the <code>TopicIRComparisonMethod</code>.
         * </p>
         * 
         * @param type
         *        The type for the <code>TopicIRComparisonMethod</code>.
         * @see ComparisonMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonMethodType
         */
        Builder type(String type);

        /**
         * <p>
         * The type for the <code>TopicIRComparisonMethod</code>.
         * </p>
         * 
         * @param type
         *        The type for the <code>TopicIRComparisonMethod</code>.
         * @see ComparisonMethodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonMethodType
         */
        Builder type(ComparisonMethodType type);

        /**
         * <p>
         * The period for the <code>TopicIRComparisonMethod</code>.
         * </p>
         * 
         * @param period
         *        The period for the <code>TopicIRComparisonMethod</code>.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder period(String period);

        /**
         * <p>
         * The period for the <code>TopicIRComparisonMethod</code>.
         * </p>
         * 
         * @param period
         *        The period for the <code>TopicIRComparisonMethod</code>.
         * @see TopicTimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicTimeGranularity
         */
        Builder period(TopicTimeGranularity period);

        /**
         * <p>
         * The window size for the <code>TopicIRComparisonMethod</code>.
         * </p>
         * 
         * @param windowSize
         *        The window size for the <code>TopicIRComparisonMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowSize(Integer windowSize);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String period;

        private Integer windowSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRComparisonMethod model) {
            type(model.type);
            period(model.period);
            windowSize(model.windowSize);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComparisonMethodType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(TopicTimeGranularity period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final Integer getWindowSize() {
            return windowSize;
        }

        public final void setWindowSize(Integer windowSize) {
            this.windowSize = windowSize;
        }

        @Override
        public final Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        @Override
        public TopicIRComparisonMethod build() {
            return new TopicIRComparisonMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
