/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the performance optimization of the dataset that contains a <code>UniqueKey</code>
 * configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceConfiguration.Builder, PerformanceConfiguration> {
    private static final SdkField<List<UniqueKey>> UNIQUE_KEYS_FIELD = SdkField
            .<List<UniqueKey>> builder(MarshallingType.LIST)
            .memberName("UniqueKeys")
            .getter(getter(PerformanceConfiguration::uniqueKeys))
            .setter(setter(Builder::uniqueKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UniqueKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(UniqueKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIQUE_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<UniqueKey> uniqueKeys;

    private PerformanceConfiguration(BuilderImpl builder) {
        this.uniqueKeys = builder.uniqueKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the UniqueKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUniqueKeys() {
        return uniqueKeys != null && !(uniqueKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>UniqueKey</code> configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUniqueKeys} method.
     * </p>
     * 
     * @return A <code>UniqueKey</code> configuration.
     */
    public final List<UniqueKey> uniqueKeys() {
        return uniqueKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUniqueKeys() ? uniqueKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceConfiguration)) {
            return false;
        }
        PerformanceConfiguration other = (PerformanceConfiguration) obj;
        return hasUniqueKeys() == other.hasUniqueKeys() && Objects.equals(uniqueKeys(), other.uniqueKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceConfiguration").add("UniqueKeys", hasUniqueKeys() ? uniqueKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UniqueKeys":
            return Optional.ofNullable(clazz.cast(uniqueKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UniqueKeys", UNIQUE_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceConfiguration, T> g) {
        return obj -> g.apply((PerformanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceConfiguration> {
        /**
         * <p>
         * A <code>UniqueKey</code> configuration.
         * </p>
         * 
         * @param uniqueKeys
         *        A <code>UniqueKey</code> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKeys(Collection<UniqueKey> uniqueKeys);

        /**
         * <p>
         * A <code>UniqueKey</code> configuration.
         * </p>
         * 
         * @param uniqueKeys
         *        A <code>UniqueKey</code> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKeys(UniqueKey... uniqueKeys);

        /**
         * <p>
         * A <code>UniqueKey</code> configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.UniqueKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.UniqueKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.UniqueKey.Builder#build()} is called immediately and
         * its result is passed to {@link #uniqueKeys(List<UniqueKey>)}.
         * 
         * @param uniqueKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.UniqueKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uniqueKeys(java.util.Collection<UniqueKey>)
         */
        Builder uniqueKeys(Consumer<UniqueKey.Builder>... uniqueKeys);
    }

    static final class BuilderImpl implements Builder {
        private List<UniqueKey> uniqueKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceConfiguration model) {
            uniqueKeys(model.uniqueKeys);
        }

        public final List<UniqueKey.Builder> getUniqueKeys() {
            List<UniqueKey.Builder> result = UniqueKeyListCopier.copyToBuilder(this.uniqueKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUniqueKeys(Collection<UniqueKey.BuilderImpl> uniqueKeys) {
            this.uniqueKeys = UniqueKeyListCopier.copyFromBuilder(uniqueKeys);
        }

        @Override
        public final Builder uniqueKeys(Collection<UniqueKey> uniqueKeys) {
            this.uniqueKeys = UniqueKeyListCopier.copy(uniqueKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(UniqueKey... uniqueKeys) {
            uniqueKeys(Arrays.asList(uniqueKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(Consumer<UniqueKey.Builder>... uniqueKeys) {
            uniqueKeys(Stream.of(uniqueKeys).map(c -> UniqueKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PerformanceConfiguration build() {
            return new PerformanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
