/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The navigation bar style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NavbarStyle implements SdkPojo, Serializable, ToCopyableBuilder<NavbarStyle.Builder, NavbarStyle> {
    private static final SdkField<Palette> GLOBAL_NAVBAR_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("GlobalNavbar").getter(getter(NavbarStyle::globalNavbar)).setter(setter(Builder::globalNavbar))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNavbar").build()).build();

    private static final SdkField<Palette> CONTEXTUAL_NAVBAR_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("ContextualNavbar").getter(getter(NavbarStyle::contextualNavbar))
            .setter(setter(Builder::contextualNavbar)).constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextualNavbar").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NAVBAR_FIELD,
            CONTEXTUAL_NAVBAR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Palette globalNavbar;

    private final Palette contextualNavbar;

    private NavbarStyle(BuilderImpl builder) {
        this.globalNavbar = builder.globalNavbar;
        this.contextualNavbar = builder.contextualNavbar;
    }

    /**
     * <p>
     * The global navigation bar style.
     * </p>
     * 
     * @return The global navigation bar style.
     */
    public final Palette globalNavbar() {
        return globalNavbar;
    }

    /**
     * <p>
     * The contextual navigation bar style.
     * </p>
     * 
     * @return The contextual navigation bar style.
     */
    public final Palette contextualNavbar() {
        return contextualNavbar;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalNavbar());
        hashCode = 31 * hashCode + Objects.hashCode(contextualNavbar());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NavbarStyle)) {
            return false;
        }
        NavbarStyle other = (NavbarStyle) obj;
        return Objects.equals(globalNavbar(), other.globalNavbar())
                && Objects.equals(contextualNavbar(), other.contextualNavbar());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NavbarStyle").add("GlobalNavbar", globalNavbar()).add("ContextualNavbar", contextualNavbar())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNavbar":
            return Optional.ofNullable(clazz.cast(globalNavbar()));
        case "ContextualNavbar":
            return Optional.ofNullable(clazz.cast(contextualNavbar()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalNavbar", GLOBAL_NAVBAR_FIELD);
        map.put("ContextualNavbar", CONTEXTUAL_NAVBAR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NavbarStyle, T> g) {
        return obj -> g.apply((NavbarStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NavbarStyle> {
        /**
         * <p>
         * The global navigation bar style.
         * </p>
         * 
         * @param globalNavbar
         *        The global navigation bar style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNavbar(Palette globalNavbar);

        /**
         * <p>
         * The global navigation bar style.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #globalNavbar(Palette)}.
         * 
         * @param globalNavbar
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalNavbar(Palette)
         */
        default Builder globalNavbar(Consumer<Palette.Builder> globalNavbar) {
            return globalNavbar(Palette.builder().applyMutation(globalNavbar).build());
        }

        /**
         * <p>
         * The contextual navigation bar style.
         * </p>
         * 
         * @param contextualNavbar
         *        The contextual navigation bar style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualNavbar(Palette contextualNavbar);

        /**
         * <p>
         * The contextual navigation bar style.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #contextualNavbar(Palette)}.
         * 
         * @param contextualNavbar
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualNavbar(Palette)
         */
        default Builder contextualNavbar(Consumer<Palette.Builder> contextualNavbar) {
            return contextualNavbar(Palette.builder().applyMutation(contextualNavbar).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Palette globalNavbar;

        private Palette contextualNavbar;

        private BuilderImpl() {
        }

        private BuilderImpl(NavbarStyle model) {
            globalNavbar(model.globalNavbar);
            contextualNavbar(model.contextualNavbar);
        }

        public final Palette.Builder getGlobalNavbar() {
            return globalNavbar != null ? globalNavbar.toBuilder() : null;
        }

        public final void setGlobalNavbar(Palette.BuilderImpl globalNavbar) {
            this.globalNavbar = globalNavbar != null ? globalNavbar.build() : null;
        }

        @Override
        public final Builder globalNavbar(Palette globalNavbar) {
            this.globalNavbar = globalNavbar;
            return this;
        }

        public final Palette.Builder getContextualNavbar() {
            return contextualNavbar != null ? contextualNavbar.toBuilder() : null;
        }

        public final void setContextualNavbar(Palette.BuilderImpl contextualNavbar) {
            this.contextualNavbar = contextualNavbar != null ? contextualNavbar.build() : null;
        }

        @Override
        public final Builder contextualNavbar(Palette contextualNavbar) {
            this.contextualNavbar = contextualNavbar;
            return this;
        }

        @Override
        public NavbarStyle build() {
            return new NavbarStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
