/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a heat map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeatMapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HeatMapConfiguration.Builder, HeatMapConfiguration> {
    private static final SdkField<HeatMapFieldWells> FIELD_WELLS_FIELD = SdkField
            .<HeatMapFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(HeatMapConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(HeatMapFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<HeatMapSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<HeatMapSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(HeatMapConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(HeatMapSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<AxisDisplayOptions> ROW_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("RowAxisDisplayOptions")
            .getter(getter(HeatMapConfiguration::rowAxisDisplayOptions)).setter(setter(Builder::rowAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> ROW_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("RowLabelOptions")
            .getter(getter(HeatMapConfiguration::rowLabelOptions)).setter(setter(Builder::rowLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLabelOptions").build()).build();

    private static final SdkField<AxisDisplayOptions> COLUMN_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("ColumnAxisDisplayOptions")
            .getter(getter(HeatMapConfiguration::columnAxisDisplayOptions)).setter(setter(Builder::columnAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> COLUMN_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ColumnLabelOptions")
            .getter(getter(HeatMapConfiguration::columnLabelOptions)).setter(setter(Builder::columnLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnLabelOptions").build())
            .build();

    private static final SdkField<ColorScale> COLOR_SCALE_FIELD = SdkField.<ColorScale> builder(MarshallingType.SDK_POJO)
            .memberName("ColorScale").getter(getter(HeatMapConfiguration::colorScale)).setter(setter(Builder::colorScale))
            .constructor(ColorScale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorScale").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(HeatMapConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(HeatMapConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(HeatMapConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(HeatMapConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, ROW_AXIS_DISPLAY_OPTIONS_FIELD, ROW_LABEL_OPTIONS_FIELD, COLUMN_AXIS_DISPLAY_OPTIONS_FIELD,
            COLUMN_LABEL_OPTIONS_FIELD, COLOR_SCALE_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HeatMapFieldWells fieldWells;

    private final HeatMapSortConfiguration sortConfiguration;

    private final AxisDisplayOptions rowAxisDisplayOptions;

    private final ChartAxisLabelOptions rowLabelOptions;

    private final AxisDisplayOptions columnAxisDisplayOptions;

    private final ChartAxisLabelOptions columnLabelOptions;

    private final ColorScale colorScale;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final TooltipOptions tooltip;

    private final VisualInteractionOptions interactions;

    private HeatMapConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.rowAxisDisplayOptions = builder.rowAxisDisplayOptions;
        this.rowLabelOptions = builder.rowLabelOptions;
        this.columnAxisDisplayOptions = builder.columnAxisDisplayOptions;
        this.columnLabelOptions = builder.columnLabelOptions;
        this.colorScale = builder.colorScale;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final HeatMapFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a heat map.
     * </p>
     * 
     * @return The sort configuration of a heat map.
     */
    public final HeatMapSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The options that determine the presentation of the row axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the row axis label.
     */
    public final AxisDisplayOptions rowAxisDisplayOptions() {
        return rowAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options of the row that is displayed in a <code>heat map</code>.
     * </p>
     * 
     * @return The label options of the row that is displayed in a <code>heat map</code>.
     */
    public final ChartAxisLabelOptions rowLabelOptions() {
        return rowLabelOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the row axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the row axis label.
     */
    public final AxisDisplayOptions columnAxisDisplayOptions() {
        return columnAxisDisplayOptions;
    }

    /**
     * <p>
     * The label options of the column that is displayed in a heat map.
     * </p>
     * 
     * @return The label options of the column that is displayed in a heat map.
     */
    public final ChartAxisLabelOptions columnLabelOptions() {
        return columnLabelOptions;
    }

    /**
     * <p>
     * The color options (gradient color, point of divergence) in a heat map.
     * </p>
     * 
     * @return The color options (gradient color, point of divergence) in a heat map.
     */
    public final ColorScale colorScale() {
        return colorScale;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The options that determine if visual data labels are displayed.
     * </p>
     * 
     * @return The options that determine if visual data labels are displayed.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rowAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(rowLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(columnAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(columnLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(colorScale());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeatMapConfiguration)) {
            return false;
        }
        HeatMapConfiguration other = (HeatMapConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(rowAxisDisplayOptions(), other.rowAxisDisplayOptions())
                && Objects.equals(rowLabelOptions(), other.rowLabelOptions())
                && Objects.equals(columnAxisDisplayOptions(), other.columnAxisDisplayOptions())
                && Objects.equals(columnLabelOptions(), other.columnLabelOptions())
                && Objects.equals(colorScale(), other.colorScale()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeatMapConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("RowAxisDisplayOptions", rowAxisDisplayOptions())
                .add("RowLabelOptions", rowLabelOptions()).add("ColumnAxisDisplayOptions", columnAxisDisplayOptions())
                .add("ColumnLabelOptions", columnLabelOptions()).add("ColorScale", colorScale()).add("Legend", legend())
                .add("DataLabels", dataLabels()).add("Tooltip", tooltip()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "RowAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(rowAxisDisplayOptions()));
        case "RowLabelOptions":
            return Optional.ofNullable(clazz.cast(rowLabelOptions()));
        case "ColumnAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(columnAxisDisplayOptions()));
        case "ColumnLabelOptions":
            return Optional.ofNullable(clazz.cast(columnLabelOptions()));
        case "ColorScale":
            return Optional.ofNullable(clazz.cast(colorScale()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("RowAxisDisplayOptions", ROW_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("RowLabelOptions", ROW_LABEL_OPTIONS_FIELD);
        map.put("ColumnAxisDisplayOptions", COLUMN_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("ColumnLabelOptions", COLUMN_LABEL_OPTIONS_FIELD);
        map.put("ColorScale", COLOR_SCALE_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeatMapConfiguration, T> g) {
        return obj -> g.apply((HeatMapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeatMapConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(HeatMapFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeatMapFieldWells.Builder} avoiding the
         * need to create one manually via {@link HeatMapFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeatMapFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(HeatMapFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link HeatMapFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(HeatMapFieldWells)
         */
        default Builder fieldWells(Consumer<HeatMapFieldWells.Builder> fieldWells) {
            return fieldWells(HeatMapFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a heat map.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(HeatMapSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeatMapSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link HeatMapSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeatMapSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(HeatMapSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link HeatMapSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(HeatMapSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<HeatMapSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(HeatMapSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the row axis label.
         * </p>
         * 
         * @param rowAxisDisplayOptions
         *        The options that determine the presentation of the row axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowAxisDisplayOptions(AxisDisplayOptions rowAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the row axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #rowAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param rowAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder rowAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> rowAxisDisplayOptions) {
            return rowAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(rowAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options of the row that is displayed in a <code>heat map</code>.
         * </p>
         * 
         * @param rowLabelOptions
         *        The label options of the row that is displayed in a <code>heat map</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowLabelOptions(ChartAxisLabelOptions rowLabelOptions);

        /**
         * <p>
         * The label options of the row that is displayed in a <code>heat map</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #rowLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param rowLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowLabelOptions(ChartAxisLabelOptions)
         */
        default Builder rowLabelOptions(Consumer<ChartAxisLabelOptions.Builder> rowLabelOptions) {
            return rowLabelOptions(ChartAxisLabelOptions.builder().applyMutation(rowLabelOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the row axis label.
         * </p>
         * 
         * @param columnAxisDisplayOptions
         *        The options that determine the presentation of the row axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnAxisDisplayOptions(AxisDisplayOptions columnAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the row axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #columnAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param columnAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder columnAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> columnAxisDisplayOptions) {
            return columnAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(columnAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The label options of the column that is displayed in a heat map.
         * </p>
         * 
         * @param columnLabelOptions
         *        The label options of the column that is displayed in a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnLabelOptions(ChartAxisLabelOptions columnLabelOptions);

        /**
         * <p>
         * The label options of the column that is displayed in a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #columnLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param columnLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnLabelOptions(ChartAxisLabelOptions)
         */
        default Builder columnLabelOptions(Consumer<ChartAxisLabelOptions.Builder> columnLabelOptions) {
            return columnLabelOptions(ChartAxisLabelOptions.builder().applyMutation(columnLabelOptions).build());
        }

        /**
         * <p>
         * The color options (gradient color, point of divergence) in a heat map.
         * </p>
         * 
         * @param colorScale
         *        The color options (gradient color, point of divergence) in a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorScale(ColorScale colorScale);

        /**
         * <p>
         * The color options (gradient color, point of divergence) in a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColorScale.Builder} avoiding the need to
         * create one manually via {@link ColorScale#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColorScale.Builder#build()} is called immediately and its result
         * is passed to {@link #colorScale(ColorScale)}.
         * 
         * @param colorScale
         *        a consumer that will call methods on {@link ColorScale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorScale(ColorScale)
         */
        default Builder colorScale(Consumer<ColorScale.Builder> colorScale) {
            return colorScale(ColorScale.builder().applyMutation(colorScale).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * 
         * @param dataLabels
         *        The options that determine if visual data labels are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The options that determine if visual data labels are displayed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HeatMapFieldWells fieldWells;

        private HeatMapSortConfiguration sortConfiguration;

        private AxisDisplayOptions rowAxisDisplayOptions;

        private ChartAxisLabelOptions rowLabelOptions;

        private AxisDisplayOptions columnAxisDisplayOptions;

        private ChartAxisLabelOptions columnLabelOptions;

        private ColorScale colorScale;

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private TooltipOptions tooltip;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(HeatMapConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            rowAxisDisplayOptions(model.rowAxisDisplayOptions);
            rowLabelOptions(model.rowLabelOptions);
            columnAxisDisplayOptions(model.columnAxisDisplayOptions);
            columnLabelOptions(model.columnLabelOptions);
            colorScale(model.colorScale);
            legend(model.legend);
            dataLabels(model.dataLabels);
            tooltip(model.tooltip);
            interactions(model.interactions);
        }

        public final HeatMapFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(HeatMapFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(HeatMapFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final HeatMapSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(HeatMapSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(HeatMapSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final AxisDisplayOptions.Builder getRowAxisDisplayOptions() {
            return rowAxisDisplayOptions != null ? rowAxisDisplayOptions.toBuilder() : null;
        }

        public final void setRowAxisDisplayOptions(AxisDisplayOptions.BuilderImpl rowAxisDisplayOptions) {
            this.rowAxisDisplayOptions = rowAxisDisplayOptions != null ? rowAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder rowAxisDisplayOptions(AxisDisplayOptions rowAxisDisplayOptions) {
            this.rowAxisDisplayOptions = rowAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getRowLabelOptions() {
            return rowLabelOptions != null ? rowLabelOptions.toBuilder() : null;
        }

        public final void setRowLabelOptions(ChartAxisLabelOptions.BuilderImpl rowLabelOptions) {
            this.rowLabelOptions = rowLabelOptions != null ? rowLabelOptions.build() : null;
        }

        @Override
        public final Builder rowLabelOptions(ChartAxisLabelOptions rowLabelOptions) {
            this.rowLabelOptions = rowLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getColumnAxisDisplayOptions() {
            return columnAxisDisplayOptions != null ? columnAxisDisplayOptions.toBuilder() : null;
        }

        public final void setColumnAxisDisplayOptions(AxisDisplayOptions.BuilderImpl columnAxisDisplayOptions) {
            this.columnAxisDisplayOptions = columnAxisDisplayOptions != null ? columnAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder columnAxisDisplayOptions(AxisDisplayOptions columnAxisDisplayOptions) {
            this.columnAxisDisplayOptions = columnAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColumnLabelOptions() {
            return columnLabelOptions != null ? columnLabelOptions.toBuilder() : null;
        }

        public final void setColumnLabelOptions(ChartAxisLabelOptions.BuilderImpl columnLabelOptions) {
            this.columnLabelOptions = columnLabelOptions != null ? columnLabelOptions.build() : null;
        }

        @Override
        public final Builder columnLabelOptions(ChartAxisLabelOptions columnLabelOptions) {
            this.columnLabelOptions = columnLabelOptions;
            return this;
        }

        public final ColorScale.Builder getColorScale() {
            return colorScale != null ? colorScale.toBuilder() : null;
        }

        public final void setColorScale(ColorScale.BuilderImpl colorScale) {
            this.colorScale = colorScale != null ? colorScale.build() : null;
        }

        @Override
        public final Builder colorScale(ColorScale colorScale) {
            this.colorScale = colorScale;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public HeatMapConfiguration build() {
            return new HeatMapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
