/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An element within a grid layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridLayoutElement implements SdkPojo, Serializable,
        ToCopyableBuilder<GridLayoutElement.Builder, GridLayoutElement> {
    private static final SdkField<String> ELEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElementId").getter(getter(GridLayoutElement::elementId)).setter(setter(Builder::elementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementId").build()).build();

    private static final SdkField<String> ELEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElementType").getter(getter(GridLayoutElement::elementTypeAsString))
            .setter(setter(Builder::elementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElementType").build()).build();

    private static final SdkField<Integer> COLUMN_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ColumnIndex").getter(getter(GridLayoutElement::columnIndex)).setter(setter(Builder::columnIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIndex").build()).build();

    private static final SdkField<Integer> COLUMN_SPAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ColumnSpan").getter(getter(GridLayoutElement::columnSpan)).setter(setter(Builder::columnSpan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSpan").build()).build();

    private static final SdkField<Integer> ROW_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RowIndex").getter(getter(GridLayoutElement::rowIndex)).setter(setter(Builder::rowIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowIndex").build()).build();

    private static final SdkField<Integer> ROW_SPAN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RowSpan").getter(getter(GridLayoutElement::rowSpan)).setter(setter(Builder::rowSpan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSpan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_ID_FIELD,
            ELEMENT_TYPE_FIELD, COLUMN_INDEX_FIELD, COLUMN_SPAN_FIELD, ROW_INDEX_FIELD, ROW_SPAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String elementId;

    private final String elementType;

    private final Integer columnIndex;

    private final Integer columnSpan;

    private final Integer rowIndex;

    private final Integer rowSpan;

    private GridLayoutElement(BuilderImpl builder) {
        this.elementId = builder.elementId;
        this.elementType = builder.elementType;
        this.columnIndex = builder.columnIndex;
        this.columnSpan = builder.columnSpan;
        this.rowIndex = builder.rowIndex;
        this.rowSpan = builder.rowSpan;
    }

    /**
     * <p>
     * A unique identifier for an element within a grid layout.
     * </p>
     * 
     * @return A unique identifier for an element within a grid layout.
     */
    public final String elementId() {
        return elementId;
    }

    /**
     * <p>
     * The type of element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elementType} will
     * return {@link LayoutElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elementTypeAsString}.
     * </p>
     * 
     * @return The type of element.
     * @see LayoutElementType
     */
    public final LayoutElementType elementType() {
        return LayoutElementType.fromValue(elementType);
    }

    /**
     * <p>
     * The type of element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elementType} will
     * return {@link LayoutElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elementTypeAsString}.
     * </p>
     * 
     * @return The type of element.
     * @see LayoutElementType
     */
    public final String elementTypeAsString() {
        return elementType;
    }

    /**
     * <p>
     * The column index for the upper left corner of an element.
     * </p>
     * 
     * @return The column index for the upper left corner of an element.
     */
    public final Integer columnIndex() {
        return columnIndex;
    }

    /**
     * <p>
     * The width of a grid element expressed as a number of grid columns.
     * </p>
     * 
     * @return The width of a grid element expressed as a number of grid columns.
     */
    public final Integer columnSpan() {
        return columnSpan;
    }

    /**
     * <p>
     * The row index for the upper left corner of an element.
     * </p>
     * 
     * @return The row index for the upper left corner of an element.
     */
    public final Integer rowIndex() {
        return rowIndex;
    }

    /**
     * <p>
     * The height of a grid element expressed as a number of grid rows.
     * </p>
     * 
     * @return The height of a grid element expressed as a number of grid rows.
     */
    public final Integer rowSpan() {
        return rowSpan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elementId());
        hashCode = 31 * hashCode + Objects.hashCode(elementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnIndex());
        hashCode = 31 * hashCode + Objects.hashCode(columnSpan());
        hashCode = 31 * hashCode + Objects.hashCode(rowIndex());
        hashCode = 31 * hashCode + Objects.hashCode(rowSpan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridLayoutElement)) {
            return false;
        }
        GridLayoutElement other = (GridLayoutElement) obj;
        return Objects.equals(elementId(), other.elementId())
                && Objects.equals(elementTypeAsString(), other.elementTypeAsString())
                && Objects.equals(columnIndex(), other.columnIndex()) && Objects.equals(columnSpan(), other.columnSpan())
                && Objects.equals(rowIndex(), other.rowIndex()) && Objects.equals(rowSpan(), other.rowSpan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridLayoutElement").add("ElementId", elementId()).add("ElementType", elementTypeAsString())
                .add("ColumnIndex", columnIndex()).add("ColumnSpan", columnSpan()).add("RowIndex", rowIndex())
                .add("RowSpan", rowSpan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElementId":
            return Optional.ofNullable(clazz.cast(elementId()));
        case "ElementType":
            return Optional.ofNullable(clazz.cast(elementTypeAsString()));
        case "ColumnIndex":
            return Optional.ofNullable(clazz.cast(columnIndex()));
        case "ColumnSpan":
            return Optional.ofNullable(clazz.cast(columnSpan()));
        case "RowIndex":
            return Optional.ofNullable(clazz.cast(rowIndex()));
        case "RowSpan":
            return Optional.ofNullable(clazz.cast(rowSpan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ElementId", ELEMENT_ID_FIELD);
        map.put("ElementType", ELEMENT_TYPE_FIELD);
        map.put("ColumnIndex", COLUMN_INDEX_FIELD);
        map.put("ColumnSpan", COLUMN_SPAN_FIELD);
        map.put("RowIndex", ROW_INDEX_FIELD);
        map.put("RowSpan", ROW_SPAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GridLayoutElement, T> g) {
        return obj -> g.apply((GridLayoutElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridLayoutElement> {
        /**
         * <p>
         * A unique identifier for an element within a grid layout.
         * </p>
         * 
         * @param elementId
         *        A unique identifier for an element within a grid layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementId(String elementId);

        /**
         * <p>
         * The type of element.
         * </p>
         * 
         * @param elementType
         *        The type of element.
         * @see LayoutElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutElementType
         */
        Builder elementType(String elementType);

        /**
         * <p>
         * The type of element.
         * </p>
         * 
         * @param elementType
         *        The type of element.
         * @see LayoutElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutElementType
         */
        Builder elementType(LayoutElementType elementType);

        /**
         * <p>
         * The column index for the upper left corner of an element.
         * </p>
         * 
         * @param columnIndex
         *        The column index for the upper left corner of an element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnIndex(Integer columnIndex);

        /**
         * <p>
         * The width of a grid element expressed as a number of grid columns.
         * </p>
         * 
         * @param columnSpan
         *        The width of a grid element expressed as a number of grid columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnSpan(Integer columnSpan);

        /**
         * <p>
         * The row index for the upper left corner of an element.
         * </p>
         * 
         * @param rowIndex
         *        The row index for the upper left corner of an element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowIndex(Integer rowIndex);

        /**
         * <p>
         * The height of a grid element expressed as a number of grid rows.
         * </p>
         * 
         * @param rowSpan
         *        The height of a grid element expressed as a number of grid rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSpan(Integer rowSpan);
    }

    static final class BuilderImpl implements Builder {
        private String elementId;

        private String elementType;

        private Integer columnIndex;

        private Integer columnSpan;

        private Integer rowIndex;

        private Integer rowSpan;

        private BuilderImpl() {
        }

        private BuilderImpl(GridLayoutElement model) {
            elementId(model.elementId);
            elementType(model.elementType);
            columnIndex(model.columnIndex);
            columnSpan(model.columnSpan);
            rowIndex(model.rowIndex);
            rowSpan(model.rowSpan);
        }

        public final String getElementId() {
            return elementId;
        }

        public final void setElementId(String elementId) {
            this.elementId = elementId;
        }

        @Override
        public final Builder elementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final String getElementType() {
            return elementType;
        }

        public final void setElementType(String elementType) {
            this.elementType = elementType;
        }

        @Override
        public final Builder elementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        @Override
        public final Builder elementType(LayoutElementType elementType) {
            this.elementType(elementType == null ? null : elementType.toString());
            return this;
        }

        public final Integer getColumnIndex() {
            return columnIndex;
        }

        public final void setColumnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public final Builder columnIndex(Integer columnIndex) {
            this.columnIndex = columnIndex;
            return this;
        }

        public final Integer getColumnSpan() {
            return columnSpan;
        }

        public final void setColumnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
        }

        @Override
        public final Builder columnSpan(Integer columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        public final Integer getRowIndex() {
            return rowIndex;
        }

        public final void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public final Builder rowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public final Integer getRowSpan() {
            return rowSpan;
        }

        public final void setRowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
        }

        @Override
        public final Builder rowSpan(Integer rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        @Override
        public GridLayoutElement build() {
            return new GridLayoutElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
