/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entry that appears when a <code>KeyRegistration</code> update to QuickSight fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedKeyRegistrationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedKeyRegistrationEntry.Builder, FailedKeyRegistrationEntry> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(FailedKeyRegistrationEntry::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(FailedKeyRegistrationEntry::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(FailedKeyRegistrationEntry::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<Boolean> SENDER_FAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SenderFault").getter(getter(FailedKeyRegistrationEntry::senderFault))
            .setter(setter(Builder::senderFault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderFault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, MESSAGE_FIELD,
            STATUS_CODE_FIELD, SENDER_FAULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyArn;

    private final String message;

    private final Integer statusCode;

    private final Boolean senderFault;

    private FailedKeyRegistrationEntry(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.message = builder.message;
        this.statusCode = builder.statusCode;
        this.senderFault = builder.senderFault;
    }

    /**
     * <p>
     * The ARN of the KMS key that failed to update.
     * </p>
     * 
     * @return The ARN of the KMS key that failed to update.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * A message that provides information about why a <code>FailedKeyRegistrationEntry</code> error occurred.
     * </p>
     * 
     * @return A message that provides information about why a <code>FailedKeyRegistrationEntry</code> error occurred.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The HTTP status of a <code>FailedKeyRegistrationEntry</code> error.
     * </p>
     * 
     * @return The HTTP status of a <code>FailedKeyRegistrationEntry</code> error.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * A boolean that indicates whether a <code>FailedKeyRegistrationEntry</code> resulted from user error. If the value
     * of this property is <code>True</code>, the error was caused by user error. If the value of this property is
     * <code>False</code>, the error occurred on the backend. If your job continues fail and with a <code>False</code>
     * <code>SenderFault</code> value, contact Amazon Web Services Support.
     * </p>
     * 
     * @return A boolean that indicates whether a <code>FailedKeyRegistrationEntry</code> resulted from user error. If
     *         the value of this property is <code>True</code>, the error was caused by user error. If the value of this
     *         property is <code>False</code>, the error occurred on the backend. If your job continues fail and with a
     *         <code>False</code> <code>SenderFault</code> value, contact Amazon Web Services Support.
     */
    public final Boolean senderFault() {
        return senderFault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(senderFault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedKeyRegistrationEntry)) {
            return false;
        }
        FailedKeyRegistrationEntry other = (FailedKeyRegistrationEntry) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(message(), other.message())
                && Objects.equals(statusCode(), other.statusCode()) && Objects.equals(senderFault(), other.senderFault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedKeyRegistrationEntry").add("KeyArn", keyArn()).add("Message", message())
                .add("StatusCode", statusCode()).add("SenderFault", senderFault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "SenderFault":
            return Optional.ofNullable(clazz.cast(senderFault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("SenderFault", SENDER_FAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedKeyRegistrationEntry, T> g) {
        return obj -> g.apply((FailedKeyRegistrationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedKeyRegistrationEntry> {
        /**
         * <p>
         * The ARN of the KMS key that failed to update.
         * </p>
         * 
         * @param keyArn
         *        The ARN of the KMS key that failed to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * A message that provides information about why a <code>FailedKeyRegistrationEntry</code> error occurred.
         * </p>
         * 
         * @param message
         *        A message that provides information about why a <code>FailedKeyRegistrationEntry</code> error
         *        occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The HTTP status of a <code>FailedKeyRegistrationEntry</code> error.
         * </p>
         * 
         * @param statusCode
         *        The HTTP status of a <code>FailedKeyRegistrationEntry</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * A boolean that indicates whether a <code>FailedKeyRegistrationEntry</code> resulted from user error. If the
         * value of this property is <code>True</code>, the error was caused by user error. If the value of this
         * property is <code>False</code>, the error occurred on the backend. If your job continues fail and with a
         * <code>False</code> <code>SenderFault</code> value, contact Amazon Web Services Support.
         * </p>
         * 
         * @param senderFault
         *        A boolean that indicates whether a <code>FailedKeyRegistrationEntry</code> resulted from user error.
         *        If the value of this property is <code>True</code>, the error was caused by user error. If the value
         *        of this property is <code>False</code>, the error occurred on the backend. If your job continues fail
         *        and with a <code>False</code> <code>SenderFault</code> value, contact Amazon Web Services Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderFault(Boolean senderFault);
    }

    static final class BuilderImpl implements Builder {
        private String keyArn;

        private String message;

        private Integer statusCode;

        private Boolean senderFault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedKeyRegistrationEntry model) {
            keyArn(model.keyArn);
            message(model.message);
            statusCode(model.statusCode);
            senderFault(model.senderFault);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final Boolean getSenderFault() {
            return senderFault;
        }

        public final void setSenderFault(Boolean senderFault) {
            this.senderFault = senderFault;
        }

        @Override
        public final Builder senderFault(Boolean senderFault) {
            this.senderFault = senderFault;
            return this;
        }

        @Override
        public FailedKeyRegistrationEntry build() {
            return new FailedKeyRegistrationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
