/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSetRefreshPropertiesResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDataSetRefreshPropertiesResponse.Builder, DescribeDataSetRefreshPropertiesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDataSetRefreshPropertiesResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDataSetRefreshPropertiesResponse::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<DataSetRefreshProperties> DATA_SET_REFRESH_PROPERTIES_FIELD = SdkField
            .<DataSetRefreshProperties> builder(MarshallingType.SDK_POJO).memberName("DataSetRefreshProperties")
            .getter(getter(DescribeDataSetRefreshPropertiesResponse::dataSetRefreshProperties))
            .setter(setter(Builder::dataSetRefreshProperties)).constructor(DataSetRefreshProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetRefreshProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            STATUS_FIELD, DATA_SET_REFRESH_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String requestId;

    private final Integer status;

    private final DataSetRefreshProperties dataSetRefreshProperties;

    private DescribeDataSetRefreshPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.dataSetRefreshProperties = builder.dataSetRefreshProperties;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The dataset refresh properties.
     * </p>
     * 
     * @return The dataset refresh properties.
     */
    public final DataSetRefreshProperties dataSetRefreshProperties() {
        return dataSetRefreshProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetRefreshProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSetRefreshPropertiesResponse)) {
            return false;
        }
        DescribeDataSetRefreshPropertiesResponse other = (DescribeDataSetRefreshPropertiesResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status())
                && Objects.equals(dataSetRefreshProperties(), other.dataSetRefreshProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSetRefreshPropertiesResponse").add("RequestId", requestId()).add("Status", status())
                .add("DataSetRefreshProperties", dataSetRefreshProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DataSetRefreshProperties":
            return Optional.ofNullable(clazz.cast(dataSetRefreshProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DataSetRefreshProperties", DATA_SET_REFRESH_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSetRefreshPropertiesResponse, T> g) {
        return obj -> g.apply((DescribeDataSetRefreshPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataSetRefreshPropertiesResponse> {
        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The dataset refresh properties.
         * </p>
         * 
         * @param dataSetRefreshProperties
         *        The dataset refresh properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties);

        /**
         * <p>
         * The dataset refresh properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetRefreshProperties.Builder}
         * avoiding the need to create one manually via {@link DataSetRefreshProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetRefreshProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSetRefreshProperties(DataSetRefreshProperties)}.
         * 
         * @param dataSetRefreshProperties
         *        a consumer that will call methods on {@link DataSetRefreshProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetRefreshProperties(DataSetRefreshProperties)
         */
        default Builder dataSetRefreshProperties(Consumer<DataSetRefreshProperties.Builder> dataSetRefreshProperties) {
            return dataSetRefreshProperties(DataSetRefreshProperties.builder().applyMutation(dataSetRefreshProperties).build());
        }
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String requestId;

        private Integer status;

        private DataSetRefreshProperties dataSetRefreshProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSetRefreshPropertiesResponse model) {
            super(model);
            requestId(model.requestId);
            status(model.status);
            dataSetRefreshProperties(model.dataSetRefreshProperties);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final DataSetRefreshProperties.Builder getDataSetRefreshProperties() {
            return dataSetRefreshProperties != null ? dataSetRefreshProperties.toBuilder() : null;
        }

        public final void setDataSetRefreshProperties(DataSetRefreshProperties.BuilderImpl dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties != null ? dataSetRefreshProperties.build() : null;
        }

        @Override
        public final Builder dataSetRefreshProperties(DataSetRefreshProperties dataSetRefreshProperties) {
            this.dataSetRefreshProperties = dataSetRefreshProperties;
            return this;
        }

        @Override
        public DescribeDataSetRefreshPropertiesResponse build() {
            return new DescribeDataSetRefreshPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
