/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Groupings of columns that work together in certain Amazon QuickSight features. This is a variant type structure. For
 * this structure to be valid, only one of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnGroup implements SdkPojo, Serializable, ToCopyableBuilder<ColumnGroup.Builder, ColumnGroup> {
    private static final SdkField<GeoSpatialColumnGroup> GEO_SPATIAL_COLUMN_GROUP_FIELD = SdkField
            .<GeoSpatialColumnGroup> builder(MarshallingType.SDK_POJO).memberName("GeoSpatialColumnGroup")
            .getter(getter(ColumnGroup::geoSpatialColumnGroup)).setter(setter(Builder::geoSpatialColumnGroup))
            .constructor(GeoSpatialColumnGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoSpatialColumnGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GEO_SPATIAL_COLUMN_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeoSpatialColumnGroup geoSpatialColumnGroup;

    private ColumnGroup(BuilderImpl builder) {
        this.geoSpatialColumnGroup = builder.geoSpatialColumnGroup;
    }

    /**
     * <p>
     * Geospatial column group that denotes a hierarchy.
     * </p>
     * 
     * @return Geospatial column group that denotes a hierarchy.
     */
    public final GeoSpatialColumnGroup geoSpatialColumnGroup() {
        return geoSpatialColumnGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geoSpatialColumnGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnGroup)) {
            return false;
        }
        ColumnGroup other = (ColumnGroup) obj;
        return Objects.equals(geoSpatialColumnGroup(), other.geoSpatialColumnGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnGroup").add("GeoSpatialColumnGroup", geoSpatialColumnGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoSpatialColumnGroup":
            return Optional.ofNullable(clazz.cast(geoSpatialColumnGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeoSpatialColumnGroup", GEO_SPATIAL_COLUMN_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnGroup, T> g) {
        return obj -> g.apply((ColumnGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnGroup> {
        /**
         * <p>
         * Geospatial column group that denotes a hierarchy.
         * </p>
         * 
         * @param geoSpatialColumnGroup
         *        Geospatial column group that denotes a hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoSpatialColumnGroup(GeoSpatialColumnGroup geoSpatialColumnGroup);

        /**
         * <p>
         * Geospatial column group that denotes a hierarchy.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoSpatialColumnGroup.Builder} avoiding
         * the need to create one manually via {@link GeoSpatialColumnGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeoSpatialColumnGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #geoSpatialColumnGroup(GeoSpatialColumnGroup)}.
         * 
         * @param geoSpatialColumnGroup
         *        a consumer that will call methods on {@link GeoSpatialColumnGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoSpatialColumnGroup(GeoSpatialColumnGroup)
         */
        default Builder geoSpatialColumnGroup(Consumer<GeoSpatialColumnGroup.Builder> geoSpatialColumnGroup) {
            return geoSpatialColumnGroup(GeoSpatialColumnGroup.builder().applyMutation(geoSpatialColumnGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GeoSpatialColumnGroup geoSpatialColumnGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnGroup model) {
            geoSpatialColumnGroup(model.geoSpatialColumnGroup);
        }

        public final GeoSpatialColumnGroup.Builder getGeoSpatialColumnGroup() {
            return geoSpatialColumnGroup != null ? geoSpatialColumnGroup.toBuilder() : null;
        }

        public final void setGeoSpatialColumnGroup(GeoSpatialColumnGroup.BuilderImpl geoSpatialColumnGroup) {
            this.geoSpatialColumnGroup = geoSpatialColumnGroup != null ? geoSpatialColumnGroup.build() : null;
        }

        @Override
        public final Builder geoSpatialColumnGroup(GeoSpatialColumnGroup geoSpatialColumnGroup) {
            this.geoSpatialColumnGroup = geoSpatialColumnGroup;
            return this;
        }

        @Override
        public ColumnGroup build() {
            return new ColumnGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
