/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options of a box plot visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BoxPlotOptions implements SdkPojo, Serializable, ToCopyableBuilder<BoxPlotOptions.Builder, BoxPlotOptions> {
    private static final SdkField<BoxPlotStyleOptions> STYLE_OPTIONS_FIELD = SdkField
            .<BoxPlotStyleOptions> builder(MarshallingType.SDK_POJO).memberName("StyleOptions")
            .getter(getter(BoxPlotOptions::styleOptions)).setter(setter(Builder::styleOptions))
            .constructor(BoxPlotStyleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StyleOptions").build()).build();

    private static final SdkField<String> OUTLIER_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutlierVisibility").getter(getter(BoxPlotOptions::outlierVisibilityAsString))
            .setter(setter(Builder::outlierVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutlierVisibility").build()).build();

    private static final SdkField<String> ALL_DATA_POINTS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllDataPointsVisibility").getter(getter(BoxPlotOptions::allDataPointsVisibilityAsString))
            .setter(setter(Builder::allDataPointsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllDataPointsVisibility").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_OPTIONS_FIELD,
            OUTLIER_VISIBILITY_FIELD, ALL_DATA_POINTS_VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BoxPlotStyleOptions styleOptions;

    private final String outlierVisibility;

    private final String allDataPointsVisibility;

    private BoxPlotOptions(BuilderImpl builder) {
        this.styleOptions = builder.styleOptions;
        this.outlierVisibility = builder.outlierVisibility;
        this.allDataPointsVisibility = builder.allDataPointsVisibility;
    }

    /**
     * <p>
     * The style options of the box plot.
     * </p>
     * 
     * @return The style options of the box plot.
     */
    public final BoxPlotStyleOptions styleOptions() {
        return styleOptions;
    }

    /**
     * <p>
     * Determines the visibility of the outlier in a box plot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlierVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outlierVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the outlier in a box plot.
     * @see Visibility
     */
    public final Visibility outlierVisibility() {
        return Visibility.fromValue(outlierVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the outlier in a box plot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlierVisibility}
     * will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outlierVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the outlier in a box plot.
     * @see Visibility
     */
    public final String outlierVisibilityAsString() {
        return outlierVisibility;
    }

    /**
     * <p>
     * Determines the visibility of all data points of the box plot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allDataPointsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #allDataPointsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of all data points of the box plot.
     * @see Visibility
     */
    public final Visibility allDataPointsVisibility() {
        return Visibility.fromValue(allDataPointsVisibility);
    }

    /**
     * <p>
     * Determines the visibility of all data points of the box plot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allDataPointsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #allDataPointsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of all data points of the box plot.
     * @see Visibility
     */
    public final String allDataPointsVisibilityAsString() {
        return allDataPointsVisibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(styleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(outlierVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allDataPointsVisibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotOptions)) {
            return false;
        }
        BoxPlotOptions other = (BoxPlotOptions) obj;
        return Objects.equals(styleOptions(), other.styleOptions())
                && Objects.equals(outlierVisibilityAsString(), other.outlierVisibilityAsString())
                && Objects.equals(allDataPointsVisibilityAsString(), other.allDataPointsVisibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BoxPlotOptions").add("StyleOptions", styleOptions())
                .add("OutlierVisibility", outlierVisibilityAsString())
                .add("AllDataPointsVisibility", allDataPointsVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StyleOptions":
            return Optional.ofNullable(clazz.cast(styleOptions()));
        case "OutlierVisibility":
            return Optional.ofNullable(clazz.cast(outlierVisibilityAsString()));
        case "AllDataPointsVisibility":
            return Optional.ofNullable(clazz.cast(allDataPointsVisibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StyleOptions", STYLE_OPTIONS_FIELD);
        map.put("OutlierVisibility", OUTLIER_VISIBILITY_FIELD);
        map.put("AllDataPointsVisibility", ALL_DATA_POINTS_VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotOptions, T> g) {
        return obj -> g.apply((BoxPlotOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BoxPlotOptions> {
        /**
         * <p>
         * The style options of the box plot.
         * </p>
         * 
         * @param styleOptions
         *        The style options of the box plot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder styleOptions(BoxPlotStyleOptions styleOptions);

        /**
         * <p>
         * The style options of the box plot.
         * </p>
         * This is a convenience method that creates an instance of the {@link BoxPlotStyleOptions.Builder} avoiding the
         * need to create one manually via {@link BoxPlotStyleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BoxPlotStyleOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #styleOptions(BoxPlotStyleOptions)}.
         * 
         * @param styleOptions
         *        a consumer that will call methods on {@link BoxPlotStyleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #styleOptions(BoxPlotStyleOptions)
         */
        default Builder styleOptions(Consumer<BoxPlotStyleOptions.Builder> styleOptions) {
            return styleOptions(BoxPlotStyleOptions.builder().applyMutation(styleOptions).build());
        }

        /**
         * <p>
         * Determines the visibility of the outlier in a box plot.
         * </p>
         * 
         * @param outlierVisibility
         *        Determines the visibility of the outlier in a box plot.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder outlierVisibility(String outlierVisibility);

        /**
         * <p>
         * Determines the visibility of the outlier in a box plot.
         * </p>
         * 
         * @param outlierVisibility
         *        Determines the visibility of the outlier in a box plot.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder outlierVisibility(Visibility outlierVisibility);

        /**
         * <p>
         * Determines the visibility of all data points of the box plot.
         * </p>
         * 
         * @param allDataPointsVisibility
         *        Determines the visibility of all data points of the box plot.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder allDataPointsVisibility(String allDataPointsVisibility);

        /**
         * <p>
         * Determines the visibility of all data points of the box plot.
         * </p>
         * 
         * @param allDataPointsVisibility
         *        Determines the visibility of all data points of the box plot.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder allDataPointsVisibility(Visibility allDataPointsVisibility);
    }

    static final class BuilderImpl implements Builder {
        private BoxPlotStyleOptions styleOptions;

        private String outlierVisibility;

        private String allDataPointsVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotOptions model) {
            styleOptions(model.styleOptions);
            outlierVisibility(model.outlierVisibility);
            allDataPointsVisibility(model.allDataPointsVisibility);
        }

        public final BoxPlotStyleOptions.Builder getStyleOptions() {
            return styleOptions != null ? styleOptions.toBuilder() : null;
        }

        public final void setStyleOptions(BoxPlotStyleOptions.BuilderImpl styleOptions) {
            this.styleOptions = styleOptions != null ? styleOptions.build() : null;
        }

        @Override
        public final Builder styleOptions(BoxPlotStyleOptions styleOptions) {
            this.styleOptions = styleOptions;
            return this;
        }

        public final String getOutlierVisibility() {
            return outlierVisibility;
        }

        public final void setOutlierVisibility(String outlierVisibility) {
            this.outlierVisibility = outlierVisibility;
        }

        @Override
        public final Builder outlierVisibility(String outlierVisibility) {
            this.outlierVisibility = outlierVisibility;
            return this;
        }

        @Override
        public final Builder outlierVisibility(Visibility outlierVisibility) {
            this.outlierVisibility(outlierVisibility == null ? null : outlierVisibility.toString());
            return this;
        }

        public final String getAllDataPointsVisibility() {
            return allDataPointsVisibility;
        }

        public final void setAllDataPointsVisibility(String allDataPointsVisibility) {
            this.allDataPointsVisibility = allDataPointsVisibility;
        }

        @Override
        public final Builder allDataPointsVisibility(String allDataPointsVisibility) {
            this.allDataPointsVisibility = allDataPointsVisibility;
            return this;
        }

        @Override
        public final Builder allDataPointsVisibility(Visibility allDataPointsVisibility) {
            this.allDataPointsVisibility(allDataPointsVisibility == null ? null : allDataPointsVisibility.toString());
            return this;
        }

        @Override
        public BoxPlotOptions build() {
            return new BoxPlotOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
