/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of analysis level configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetOptions implements SdkPojo, Serializable, ToCopyableBuilder<AssetOptions.Builder, AssetOptions> {
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(AssetOptions::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> WEEK_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WeekStart").getter(getter(AssetOptions::weekStartAsString)).setter(setter(Builder::weekStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeekStart").build()).build();

    private static final SdkField<String> Q_BUSINESS_INSIGHTS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QBusinessInsightsStatus").getter(getter(AssetOptions::qBusinessInsightsStatusAsString))
            .setter(setter(Builder::qBusinessInsightsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QBusinessInsightsStatus").build())
            .build();

    private static final SdkField<List<String>> EXCLUDED_DATA_SET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedDataSetArns")
            .getter(getter(AssetOptions::excludedDataSetArns))
            .setter(setter(Builder::excludedDataSetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedDataSetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualCustomActionDefaults> CUSTOM_ACTION_DEFAULTS_FIELD = SdkField
            .<VisualCustomActionDefaults> builder(MarshallingType.SDK_POJO).memberName("CustomActionDefaults")
            .getter(getter(AssetOptions::customActionDefaults)).setter(setter(Builder::customActionDefaults))
            .constructor(VisualCustomActionDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionDefaults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEZONE_FIELD,
            WEEK_START_FIELD, Q_BUSINESS_INSIGHTS_STATUS_FIELD, EXCLUDED_DATA_SET_ARNS_FIELD, CUSTOM_ACTION_DEFAULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timezone;

    private final String weekStart;

    private final String qBusinessInsightsStatus;

    private final List<String> excludedDataSetArns;

    private final VisualCustomActionDefaults customActionDefaults;

    private AssetOptions(BuilderImpl builder) {
        this.timezone = builder.timezone;
        this.weekStart = builder.weekStart;
        this.qBusinessInsightsStatus = builder.qBusinessInsightsStatus;
        this.excludedDataSetArns = builder.excludedDataSetArns;
        this.customActionDefaults = builder.customActionDefaults;
    }

    /**
     * <p>
     * Determines the timezone for the analysis.
     * </p>
     * 
     * @return Determines the timezone for the analysis.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Determines the week start day for an analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #weekStart} will
     * return {@link DayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #weekStartAsString}.
     * </p>
     * 
     * @return Determines the week start day for an analysis.
     * @see DayOfTheWeek
     */
    public final DayOfTheWeek weekStart() {
        return DayOfTheWeek.fromValue(weekStart);
    }

    /**
     * <p>
     * Determines the week start day for an analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #weekStart} will
     * return {@link DayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #weekStartAsString}.
     * </p>
     * 
     * @return Determines the week start day for an analysis.
     * @see DayOfTheWeek
     */
    public final String weekStartAsString() {
        return weekStart;
    }

    /**
     * <p>
     * Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qBusinessInsightsStatus} will return {@link QBusinessInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qBusinessInsightsStatusAsString}.
     * </p>
     * 
     * @return Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
     * @see QBusinessInsightsStatus
     */
    public final QBusinessInsightsStatus qBusinessInsightsStatus() {
        return QBusinessInsightsStatus.fromValue(qBusinessInsightsStatus);
    }

    /**
     * <p>
     * Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qBusinessInsightsStatus} will return {@link QBusinessInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qBusinessInsightsStatusAsString}.
     * </p>
     * 
     * @return Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
     * @see QBusinessInsightsStatus
     */
    public final String qBusinessInsightsStatusAsString() {
        return qBusinessInsightsStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedDataSetArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedDataSetArns() {
        return excludedDataSetArns != null && !(excludedDataSetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dataset ARNS to exclude from Dashboard Q&amp;A.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedDataSetArns} method.
     * </p>
     * 
     * @return A list of dataset ARNS to exclude from Dashboard Q&amp;A.
     */
    public final List<String> excludedDataSetArns() {
        return excludedDataSetArns;
    }

    /**
     * <p>
     * A list of visual custom actions for the analysis.
     * </p>
     * 
     * @return A list of visual custom actions for the analysis.
     */
    public final VisualCustomActionDefaults customActionDefaults() {
        return customActionDefaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(weekStartAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qBusinessInsightsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedDataSetArns() ? excludedDataSetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customActionDefaults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetOptions)) {
            return false;
        }
        AssetOptions other = (AssetOptions) obj;
        return Objects.equals(timezone(), other.timezone()) && Objects.equals(weekStartAsString(), other.weekStartAsString())
                && Objects.equals(qBusinessInsightsStatusAsString(), other.qBusinessInsightsStatusAsString())
                && hasExcludedDataSetArns() == other.hasExcludedDataSetArns()
                && Objects.equals(excludedDataSetArns(), other.excludedDataSetArns())
                && Objects.equals(customActionDefaults(), other.customActionDefaults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetOptions").add("Timezone", timezone()).add("WeekStart", weekStartAsString())
                .add("QBusinessInsightsStatus", qBusinessInsightsStatusAsString())
                .add("ExcludedDataSetArns", hasExcludedDataSetArns() ? excludedDataSetArns() : null)
                .add("CustomActionDefaults", customActionDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "WeekStart":
            return Optional.ofNullable(clazz.cast(weekStartAsString()));
        case "QBusinessInsightsStatus":
            return Optional.ofNullable(clazz.cast(qBusinessInsightsStatusAsString()));
        case "ExcludedDataSetArns":
            return Optional.ofNullable(clazz.cast(excludedDataSetArns()));
        case "CustomActionDefaults":
            return Optional.ofNullable(clazz.cast(customActionDefaults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("WeekStart", WEEK_START_FIELD);
        map.put("QBusinessInsightsStatus", Q_BUSINESS_INSIGHTS_STATUS_FIELD);
        map.put("ExcludedDataSetArns", EXCLUDED_DATA_SET_ARNS_FIELD);
        map.put("CustomActionDefaults", CUSTOM_ACTION_DEFAULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetOptions, T> g) {
        return obj -> g.apply((AssetOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetOptions> {
        /**
         * <p>
         * Determines the timezone for the analysis.
         * </p>
         * 
         * @param timezone
         *        Determines the timezone for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Determines the week start day for an analysis.
         * </p>
         * 
         * @param weekStart
         *        Determines the week start day for an analysis.
         * @see DayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfTheWeek
         */
        Builder weekStart(String weekStart);

        /**
         * <p>
         * Determines the week start day for an analysis.
         * </p>
         * 
         * @param weekStart
         *        Determines the week start day for an analysis.
         * @see DayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfTheWeek
         */
        Builder weekStart(DayOfTheWeek weekStart);

        /**
         * <p>
         * Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
         * </p>
         * 
         * @param qBusinessInsightsStatus
         *        Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
         * @see QBusinessInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QBusinessInsightsStatus
         */
        Builder qBusinessInsightsStatus(String qBusinessInsightsStatus);

        /**
         * <p>
         * Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
         * </p>
         * 
         * @param qBusinessInsightsStatus
         *        Determines whether insight summaries from Amazon Q Business are allowed in Dashboard Q&amp;A.
         * @see QBusinessInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QBusinessInsightsStatus
         */
        Builder qBusinessInsightsStatus(QBusinessInsightsStatus qBusinessInsightsStatus);

        /**
         * <p>
         * A list of dataset ARNS to exclude from Dashboard Q&amp;A.
         * </p>
         * 
         * @param excludedDataSetArns
         *        A list of dataset ARNS to exclude from Dashboard Q&amp;A.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedDataSetArns(Collection<String> excludedDataSetArns);

        /**
         * <p>
         * A list of dataset ARNS to exclude from Dashboard Q&amp;A.
         * </p>
         * 
         * @param excludedDataSetArns
         *        A list of dataset ARNS to exclude from Dashboard Q&amp;A.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedDataSetArns(String... excludedDataSetArns);

        /**
         * <p>
         * A list of visual custom actions for the analysis.
         * </p>
         * 
         * @param customActionDefaults
         *        A list of visual custom actions for the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionDefaults(VisualCustomActionDefaults customActionDefaults);

        /**
         * <p>
         * A list of visual custom actions for the analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualCustomActionDefaults.Builder}
         * avoiding the need to create one manually via {@link VisualCustomActionDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualCustomActionDefaults.Builder#build()} is called immediately
         * and its result is passed to {@link #customActionDefaults(VisualCustomActionDefaults)}.
         * 
         * @param customActionDefaults
         *        a consumer that will call methods on {@link VisualCustomActionDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customActionDefaults(VisualCustomActionDefaults)
         */
        default Builder customActionDefaults(Consumer<VisualCustomActionDefaults.Builder> customActionDefaults) {
            return customActionDefaults(VisualCustomActionDefaults.builder().applyMutation(customActionDefaults).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String timezone;

        private String weekStart;

        private String qBusinessInsightsStatus;

        private List<String> excludedDataSetArns = DefaultSdkAutoConstructList.getInstance();

        private VisualCustomActionDefaults customActionDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetOptions model) {
            timezone(model.timezone);
            weekStart(model.weekStart);
            qBusinessInsightsStatus(model.qBusinessInsightsStatus);
            excludedDataSetArns(model.excludedDataSetArns);
            customActionDefaults(model.customActionDefaults);
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getWeekStart() {
            return weekStart;
        }

        public final void setWeekStart(String weekStart) {
            this.weekStart = weekStart;
        }

        @Override
        public final Builder weekStart(String weekStart) {
            this.weekStart = weekStart;
            return this;
        }

        @Override
        public final Builder weekStart(DayOfTheWeek weekStart) {
            this.weekStart(weekStart == null ? null : weekStart.toString());
            return this;
        }

        public final String getQBusinessInsightsStatus() {
            return qBusinessInsightsStatus;
        }

        public final void setQBusinessInsightsStatus(String qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus = qBusinessInsightsStatus;
        }

        @Override
        public final Builder qBusinessInsightsStatus(String qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus = qBusinessInsightsStatus;
            return this;
        }

        @Override
        public final Builder qBusinessInsightsStatus(QBusinessInsightsStatus qBusinessInsightsStatus) {
            this.qBusinessInsightsStatus(qBusinessInsightsStatus == null ? null : qBusinessInsightsStatus.toString());
            return this;
        }

        public final Collection<String> getExcludedDataSetArns() {
            if (excludedDataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedDataSetArns;
        }

        public final void setExcludedDataSetArns(Collection<String> excludedDataSetArns) {
            this.excludedDataSetArns = DataSetArnsListCopier.copy(excludedDataSetArns);
        }

        @Override
        public final Builder excludedDataSetArns(Collection<String> excludedDataSetArns) {
            this.excludedDataSetArns = DataSetArnsListCopier.copy(excludedDataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedDataSetArns(String... excludedDataSetArns) {
            excludedDataSetArns(Arrays.asList(excludedDataSetArns));
            return this;
        }

        public final VisualCustomActionDefaults.Builder getCustomActionDefaults() {
            return customActionDefaults != null ? customActionDefaults.toBuilder() : null;
        }

        public final void setCustomActionDefaults(VisualCustomActionDefaults.BuilderImpl customActionDefaults) {
            this.customActionDefaults = customActionDefaults != null ? customActionDefaults.build() : null;
        }

        @Override
        public final Builder customActionDefaults(VisualCustomActionDefaults customActionDefaults) {
            this.customActionDefaults = customActionDefaults;
            return this;
        }

        @Override
        public AssetOptions build() {
            return new AssetOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
