/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings that you want to use for the Generative Q&amp;A experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserGenerativeQnAEmbeddingConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AnonymousUserGenerativeQnAEmbeddingConfiguration.Builder, AnonymousUserGenerativeQnAEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialTopicId").getter(getter(AnonymousUserGenerativeQnAEmbeddingConfiguration::initialTopicId))
            .setter(setter(Builder::initialTopicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialTopicId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_TOPIC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String initialTopicId;

    private AnonymousUserGenerativeQnAEmbeddingConfiguration(BuilderImpl builder) {
        this.initialTopicId = builder.initialTopicId;
    }

    /**
     * <p>
     * The QuickSight Q topic ID of the new reader experience topic that you want the anonymous user to see first. This
     * ID is included in the output URL. When the URL in response is accessed, QuickSight renders the Generative Q&amp;A
     * experience with this new reader experience topic pre selected.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of this Q new reader experience topic must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an
     * <code>InvalidParameterValueException</code> error.
     * </p>
     * 
     * @return The QuickSight Q topic ID of the new reader experience topic that you want the anonymous user to see
     *         first. This ID is included in the output URL. When the URL in response is accessed, QuickSight renders
     *         the Generative Q&amp;A experience with this new reader experience topic pre selected.</p>
     *         <p>
     *         The Amazon Resource Name (ARN) of this Q new reader experience topic must be included in the
     *         <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an
     *         <code>InvalidParameterValueException</code> error.
     */
    public final String initialTopicId() {
        return initialTopicId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialTopicId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserGenerativeQnAEmbeddingConfiguration)) {
            return false;
        }
        AnonymousUserGenerativeQnAEmbeddingConfiguration other = (AnonymousUserGenerativeQnAEmbeddingConfiguration) obj;
        return Objects.equals(initialTopicId(), other.initialTopicId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserGenerativeQnAEmbeddingConfiguration").add("InitialTopicId", initialTopicId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialTopicId":
            return Optional.ofNullable(clazz.cast(initialTopicId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InitialTopicId", INITIAL_TOPIC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserGenerativeQnAEmbeddingConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserGenerativeQnAEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserGenerativeQnAEmbeddingConfiguration> {
        /**
         * <p>
         * The QuickSight Q topic ID of the new reader experience topic that you want the anonymous user to see first.
         * This ID is included in the output URL. When the URL in response is accessed, QuickSight renders the
         * Generative Q&amp;A experience with this new reader experience topic pre selected.
         * </p>
         * <p>
         * The Amazon Resource Name (ARN) of this Q new reader experience topic must be included in the
         * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an
         * <code>InvalidParameterValueException</code> error.
         * </p>
         * 
         * @param initialTopicId
         *        The QuickSight Q topic ID of the new reader experience topic that you want the anonymous user to see
         *        first. This ID is included in the output URL. When the URL in response is accessed, QuickSight renders
         *        the Generative Q&amp;A experience with this new reader experience topic pre selected.</p>
         *        <p>
         *        The Amazon Resource Name (ARN) of this Q new reader experience topic must be included in the
         *        <code>AuthorizedResourceArns</code> parameter. Otherwise, the request fails with an
         *        <code>InvalidParameterValueException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialTopicId(String initialTopicId);
    }

    static final class BuilderImpl implements Builder {
        private String initialTopicId;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserGenerativeQnAEmbeddingConfiguration model) {
            initialTopicId(model.initialTopicId);
        }

        public final String getInitialTopicId() {
            return initialTopicId;
        }

        public final void setInitialTopicId(String initialTopicId) {
            this.initialTopicId = initialTopicId;
        }

        @Override
        public final Builder initialTopicId(String initialTopicId) {
            this.initialTopicId = initialTopicId;
            return this;
        }

        @Override
        public AnonymousUserGenerativeQnAEmbeddingConfiguration build() {
            return new AnonymousUserGenerativeQnAEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
