/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QDataKeyType {
    AWS_OWNED("AWS_OWNED"),
    CMK("CMK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QDataKeyType> VALUE_MAP;
    private final String value;

    private QDataKeyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QDataKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QDataKeyType> knownValues() {
        EnumSet<QDataKeyType> knownValues = EnumSet.allOf(QDataKeyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QDataKeyType.class, QDataKeyType::toString);
    }
}

