/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of custom actions applied to visuals in an analysis or sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualCustomActionDefaults implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualCustomActionDefaults.Builder, VisualCustomActionDefaults> {
    private static final SdkField<VisualHighlightOperation> HIGHLIGHT_OPERATION_FIELD = SdkField
            .<VisualHighlightOperation> builder(MarshallingType.SDK_POJO).memberName("highlightOperation")
            .getter(getter(VisualCustomActionDefaults::highlightOperation)).setter(setter(Builder::highlightOperation))
            .constructor(VisualHighlightOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlightOperation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIGHLIGHT_OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VisualHighlightOperation highlightOperation;

    private VisualCustomActionDefaults(BuilderImpl builder) {
        this.highlightOperation = builder.highlightOperation;
    }

    /**
     * <p>
     * A list of highlight operations available for visuals in an analysis or sheet.
     * </p>
     * 
     * @return A list of highlight operations available for visuals in an analysis or sheet.
     */
    public final VisualHighlightOperation highlightOperation() {
        return highlightOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(highlightOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomActionDefaults)) {
            return false;
        }
        VisualCustomActionDefaults other = (VisualCustomActionDefaults) obj;
        return Objects.equals(highlightOperation(), other.highlightOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualCustomActionDefaults").add("HighlightOperation", highlightOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "highlightOperation":
            return Optional.ofNullable(clazz.cast(highlightOperation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("highlightOperation", HIGHLIGHT_OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualCustomActionDefaults, T> g) {
        return obj -> g.apply((VisualCustomActionDefaults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualCustomActionDefaults> {
        /**
         * <p>
         * A list of highlight operations available for visuals in an analysis or sheet.
         * </p>
         * 
         * @param highlightOperation
         *        A list of highlight operations available for visuals in an analysis or sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlightOperation(VisualHighlightOperation highlightOperation);

        /**
         * <p>
         * A list of highlight operations available for visuals in an analysis or sheet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualHighlightOperation.Builder}
         * avoiding the need to create one manually via {@link VisualHighlightOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualHighlightOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #highlightOperation(VisualHighlightOperation)}.
         * 
         * @param highlightOperation
         *        a consumer that will call methods on {@link VisualHighlightOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #highlightOperation(VisualHighlightOperation)
         */
        default Builder highlightOperation(Consumer<VisualHighlightOperation.Builder> highlightOperation) {
            return highlightOperation(VisualHighlightOperation.builder().applyMutation(highlightOperation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VisualHighlightOperation highlightOperation;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualCustomActionDefaults model) {
            highlightOperation(model.highlightOperation);
        }

        public final VisualHighlightOperation.Builder getHighlightOperation() {
            return highlightOperation != null ? highlightOperation.toBuilder() : null;
        }

        public final void setHighlightOperation(VisualHighlightOperation.BuilderImpl highlightOperation) {
            this.highlightOperation = highlightOperation != null ? highlightOperation.build() : null;
        }

        @Override
        public final Builder highlightOperation(VisualHighlightOperation highlightOperation) {
            this.highlightOperation = highlightOperation;
            return this;
        }

        @Override
        public VisualCustomActionDefaults build() {
            return new VisualCustomActionDefaults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
