/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A registered user of Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(User::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(User::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(User::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(User::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(User::identityTypeAsString)).setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Active").getter(getter(User::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(User::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> CUSTOM_PERMISSIONS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomPermissionsName").getter(getter(User::customPermissionsName))
            .setter(setter(Builder::customPermissionsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomPermissionsName").build())
            .build();

    private static final SdkField<String> EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginFederationProviderType")
            .getter(getter(User::externalLoginFederationProviderType))
            .setter(setter(Builder::externalLoginFederationProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExternalLoginFederationProviderType").build()).build();

    private static final SdkField<String> EXTERNAL_LOGIN_FEDERATION_PROVIDER_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginFederationProviderUrl")
            .getter(getter(User::externalLoginFederationProviderUrl))
            .setter(setter(Builder::externalLoginFederationProviderUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginFederationProviderUrl")
                    .build()).build();

    private static final SdkField<String> EXTERNAL_LOGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalLoginId").getter(getter(User::externalLoginId)).setter(setter(Builder::externalLoginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalLoginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ARN_FIELD, USER_NAME_FIELD, EMAIL_FIELD, ROLE_FIELD, IDENTITY_TYPE_FIELD,
                    ACTIVE_FIELD, PRINCIPAL_ID_FIELD, CUSTOM_PERMISSIONS_NAME_FIELD,
                    EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD, EXTERNAL_LOGIN_FEDERATION_PROVIDER_URL_FIELD,
                    EXTERNAL_LOGIN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String userName;

    private final String email;

    private final String role;

    private final String identityType;

    private final Boolean active;

    private final String principalId;

    private final String customPermissionsName;

    private final String externalLoginFederationProviderType;

    private final String externalLoginFederationProviderUrl;

    private final String externalLoginId;

    private User(BuilderImpl builder) {
        this.arn = builder.arn;
        this.userName = builder.userName;
        this.email = builder.email;
        this.role = builder.role;
        this.identityType = builder.identityType;
        this.active = builder.active;
        this.principalId = builder.principalId;
        this.customPermissionsName = builder.customPermissionsName;
        this.externalLoginFederationProviderType = builder.externalLoginFederationProviderType;
        this.externalLoginFederationProviderUrl = builder.externalLoginFederationProviderUrl;
        this.externalLoginId = builder.externalLoginId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the user.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The user's user name. This value is required if you are registering a user that will be managed in QuickSight. In
     * the output, the value for <code>UserName</code> is <code>N/A</code> when the value for <code>IdentityType</code>
     * is <code>IAM</code> and the corresponding IAM user is deleted.
     * </p>
     * 
     * @return The user's user name. This value is required if you are registering a user that will be managed in
     *         QuickSight. In the output, the value for <code>UserName</code> is <code>N/A</code> when the value for
     *         <code>IdentityType</code> is <code>IAM</code> and the corresponding IAM user is deleted.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The user's email address.
     * </p>
     * 
     * @return The user's email address.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access
     * to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author
     * dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and
     * generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings.
     * Admin Pro users are billed at Author Pro pricing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
     *         access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries
     *         from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
     *         author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
     *         Q&amp;A, and generate executive summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
     *         settings. Admin Pro users are billed at Author Pro pricing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * The Amazon QuickSight role for the user. The user role can be one of the following:.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READER</code>: A user who has read-only access to dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have access
     * to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can author
     * dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for Q&amp;A, and
     * generate executive summaries from dashboards.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative settings.
     * Admin Pro users are billed at Author Pro pricing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READER</code>: A user who has read-only access to dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
     *         access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries
     *         from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
     *         author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
     *         Q&amp;A, and generate executive summaries from dashboards.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
     *         settings. Admin Pro users are billed at Author Pro pricing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_READER</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
     *         </p>
     *         </li>
     * @see UserRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The type of identity authentication used by the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity authentication used by the user.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The type of identity authentication used by the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity authentication used by the user.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The active status of user. When you create an Amazon QuickSight user that's not an IAM user or an Active
     * Directory user, that user is inactive until they sign in and provide a password.
     * </p>
     * 
     * @return The active status of user. When you create an Amazon QuickSight user that's not an IAM user or an Active
     *         Directory user, that user is inactive until they sign in and provide a password.
     */
    public final Boolean active() {
        return active;
    }

    /**
     * <p>
     * The principal ID of the user.
     * </p>
     * 
     * @return The principal ID of the user.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The custom permissions profile associated with this user.
     * </p>
     * 
     * @return The custom permissions profile associated with this user.
     */
    public final String customPermissionsName() {
        return customPermissionsName;
    }

    /**
     * <p>
     * The type of supported external login provider that provides identity to let the user federate into Amazon
     * QuickSight with an associated IAM role. The type can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of supported external login provider that provides identity to let the user federate into Amazon
     *         QuickSight with an associated IAM role. The type can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.
     *         </p>
     *         </li>
     */
    public final String externalLoginFederationProviderType() {
        return externalLoginFederationProviderType;
    }

    /**
     * <p>
     * The URL of the external login provider.
     * </p>
     * 
     * @return The URL of the external login provider.
     */
    public final String externalLoginFederationProviderUrl() {
        return externalLoginFederationProviderUrl;
    }

    /**
     * <p>
     * The identity ID for the user in the external login provider.
     * </p>
     * 
     * @return The identity ID for the user in the external login provider.
     */
    public final String externalLoginId() {
        return externalLoginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(customPermissionsName());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginFederationProviderType());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginFederationProviderUrl());
        hashCode = 31 * hashCode + Objects.hashCode(externalLoginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(userName(), other.userName())
                && Objects.equals(email(), other.email()) && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(active(), other.active()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(customPermissionsName(), other.customPermissionsName())
                && Objects.equals(externalLoginFederationProviderType(), other.externalLoginFederationProviderType())
                && Objects.equals(externalLoginFederationProviderUrl(), other.externalLoginFederationProviderUrl())
                && Objects.equals(externalLoginId(), other.externalLoginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("Arn", arn()).add("UserName", userName()).add("Email", email())
                .add("Role", roleAsString()).add("IdentityType", identityTypeAsString()).add("Active", active())
                .add("PrincipalId", principalId()).add("CustomPermissionsName", customPermissionsName())
                .add("ExternalLoginFederationProviderType", externalLoginFederationProviderType())
                .add("ExternalLoginFederationProviderUrl", externalLoginFederationProviderUrl())
                .add("ExternalLoginId", externalLoginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "CustomPermissionsName":
            return Optional.ofNullable(clazz.cast(customPermissionsName()));
        case "ExternalLoginFederationProviderType":
            return Optional.ofNullable(clazz.cast(externalLoginFederationProviderType()));
        case "ExternalLoginFederationProviderUrl":
            return Optional.ofNullable(clazz.cast(externalLoginFederationProviderUrl()));
        case "ExternalLoginId":
            return Optional.ofNullable(clazz.cast(externalLoginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("IdentityType", IDENTITY_TYPE_FIELD);
        map.put("Active", ACTIVE_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("CustomPermissionsName", CUSTOM_PERMISSIONS_NAME_FIELD);
        map.put("ExternalLoginFederationProviderType", EXTERNAL_LOGIN_FEDERATION_PROVIDER_TYPE_FIELD);
        map.put("ExternalLoginFederationProviderUrl", EXTERNAL_LOGIN_FEDERATION_PROVIDER_URL_FIELD);
        map.put("ExternalLoginId", EXTERNAL_LOGIN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the user.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user's user name. This value is required if you are registering a user that will be managed in
         * QuickSight. In the output, the value for <code>UserName</code> is <code>N/A</code> when the value for
         * <code>IdentityType</code> is <code>IAM</code> and the corresponding IAM user is deleted.
         * </p>
         * 
         * @param userName
         *        The user's user name. This value is required if you are registering a user that will be managed in
         *        QuickSight. In the output, the value for <code>UserName</code> is <code>N/A</code> when the value for
         *        <code>IdentityType</code> is <code>IAM</code> and the corresponding IAM user is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The user's email address.
         * </p>
         * 
         * @param email
         *        The user's email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
         * access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries from
         * dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
         * author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
         * Q&amp;A, and generate executive summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
         * settings. Admin Pro users are billed at Author Pro pricing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros
         *        have access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive
         *        summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros
         *        can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics
         *        for Q&amp;A, and generate executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight
         *        administrative settings. Admin Pro users are billed at Author Pro pricing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * The Amazon QuickSight role for the user. The user role can be one of the following:.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READER</code>: A user who has read-only access to dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros have
         * access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive summaries from
         * dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros can
         * author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics for
         * Q&amp;A, and generate executive summaries from dashboards.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight administrative
         * settings. Admin Pro users are billed at Author Pro pricing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param role
         *        The Amazon QuickSight role for the user. The user role can be one of the following:.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READER</code>: A user who has read-only access to dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR</code>: A user who can create data sources, datasets, analyses, and dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN</code>: A user who is an author, who can also manage Amazon QuickSight settings.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READER_PRO</code>: Reader Pro adds Generative BI capabilities to the Reader role. Reader Pros
         *        have access to Amazon Q in QuickSight, can build stories with Amazon Q, and can generate executive
         *        summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHOR_PRO</code>: Author Pro adds Generative BI capabilities to the Author role. Author Pros
         *        can author dashboards with natural language with Amazon Q, build stories with Amazon Q, create Topics
         *        for Q&amp;A, and generate executive summaries from dashboards.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ADMIN_PRO</code>: Admin Pros are Author Pros who can also manage Amazon QuickSight
         *        administrative settings. Admin Pro users are billed at Author Pro pricing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_READER</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESTRICTED_AUTHOR</code>: This role isn't currently available for use.
         *        </p>
         *        </li>
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        /**
         * <p>
         * The type of identity authentication used by the user.
         * </p>
         * 
         * @param identityType
         *        The type of identity authentication used by the user.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The type of identity authentication used by the user.
         * </p>
         * 
         * @param identityType
         *        The type of identity authentication used by the user.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The active status of user. When you create an Amazon QuickSight user that's not an IAM user or an Active
         * Directory user, that user is inactive until they sign in and provide a password.
         * </p>
         * 
         * @param active
         *        The active status of user. When you create an Amazon QuickSight user that's not an IAM user or an
         *        Active Directory user, that user is inactive until they sign in and provide a password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * The principal ID of the user.
         * </p>
         * 
         * @param principalId
         *        The principal ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The custom permissions profile associated with this user.
         * </p>
         * 
         * @param customPermissionsName
         *        The custom permissions profile associated with this user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPermissionsName(String customPermissionsName);

        /**
         * <p>
         * The type of supported external login provider that provides identity to let the user federate into Amazon
         * QuickSight with an associated IAM role. The type can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.
         * </p>
         * </li>
         * </ul>
         * 
         * @param externalLoginFederationProviderType
         *        The type of supported external login provider that provides identity to let the user federate into
         *        Amazon QuickSight with an associated IAM role. The type can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COGNITO</code>: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_OIDC</code>: Custom OpenID Connect (OIDC) provider.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginFederationProviderType(String externalLoginFederationProviderType);

        /**
         * <p>
         * The URL of the external login provider.
         * </p>
         * 
         * @param externalLoginFederationProviderUrl
         *        The URL of the external login provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginFederationProviderUrl(String externalLoginFederationProviderUrl);

        /**
         * <p>
         * The identity ID for the user in the external login provider.
         * </p>
         * 
         * @param externalLoginId
         *        The identity ID for the user in the external login provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalLoginId(String externalLoginId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String userName;

        private String email;

        private String role;

        private String identityType;

        private Boolean active;

        private String principalId;

        private String customPermissionsName;

        private String externalLoginFederationProviderType;

        private String externalLoginFederationProviderUrl;

        private String externalLoginId;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            arn(model.arn);
            userName(model.userName);
            email(model.email);
            role(model.role);
            identityType(model.identityType);
            active(model.active);
            principalId(model.principalId);
            customPermissionsName(model.customPermissionsName);
            externalLoginFederationProviderType(model.externalLoginFederationProviderType);
            externalLoginFederationProviderUrl(model.externalLoginFederationProviderUrl);
            externalLoginId(model.externalLoginId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getCustomPermissionsName() {
            return customPermissionsName;
        }

        public final void setCustomPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
        }

        @Override
        public final Builder customPermissionsName(String customPermissionsName) {
            this.customPermissionsName = customPermissionsName;
            return this;
        }

        public final String getExternalLoginFederationProviderType() {
            return externalLoginFederationProviderType;
        }

        public final void setExternalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
        }

        @Override
        public final Builder externalLoginFederationProviderType(String externalLoginFederationProviderType) {
            this.externalLoginFederationProviderType = externalLoginFederationProviderType;
            return this;
        }

        public final String getExternalLoginFederationProviderUrl() {
            return externalLoginFederationProviderUrl;
        }

        public final void setExternalLoginFederationProviderUrl(String externalLoginFederationProviderUrl) {
            this.externalLoginFederationProviderUrl = externalLoginFederationProviderUrl;
        }

        @Override
        public final Builder externalLoginFederationProviderUrl(String externalLoginFederationProviderUrl) {
            this.externalLoginFederationProviderUrl = externalLoginFederationProviderUrl;
            return this;
        }

        public final String getExternalLoginId() {
            return externalLoginId;
        }

        public final void setExternalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
        }

        @Override
        public final Builder externalLoginId(String externalLoginId) {
            this.externalLoginId = externalLoginId;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
