/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the static file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticFileSource implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticFileSource.Builder, StaticFileSource> {
    private static final SdkField<StaticFileUrlSourceOptions> URL_OPTIONS_FIELD = SdkField
            .<StaticFileUrlSourceOptions> builder(MarshallingType.SDK_POJO).memberName("UrlOptions")
            .getter(getter(StaticFileSource::urlOptions)).setter(setter(Builder::urlOptions))
            .constructor(StaticFileUrlSourceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlOptions").build()).build();

    private static final SdkField<StaticFileS3SourceOptions> S3_OPTIONS_FIELD = SdkField
            .<StaticFileS3SourceOptions> builder(MarshallingType.SDK_POJO).memberName("S3Options")
            .getter(getter(StaticFileSource::s3Options)).setter(setter(Builder::s3Options))
            .constructor(StaticFileS3SourceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_OPTIONS_FIELD,
            S3_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StaticFileUrlSourceOptions urlOptions;

    private final StaticFileS3SourceOptions s3Options;

    private StaticFileSource(BuilderImpl builder) {
        this.urlOptions = builder.urlOptions;
        this.s3Options = builder.s3Options;
    }

    /**
     * <p>
     * The structure that contains the URL to download the static file from.
     * </p>
     * 
     * @return The structure that contains the URL to download the static file from.
     */
    public final StaticFileUrlSourceOptions urlOptions() {
        return urlOptions;
    }

    /**
     * <p>
     * The structure that contains the Amazon S3 location to download the static file from.
     * </p>
     * 
     * @return The structure that contains the Amazon S3 location to download the static file from.
     */
    public final StaticFileS3SourceOptions s3Options() {
        return s3Options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(urlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3Options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticFileSource)) {
            return false;
        }
        StaticFileSource other = (StaticFileSource) obj;
        return Objects.equals(urlOptions(), other.urlOptions()) && Objects.equals(s3Options(), other.s3Options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticFileSource").add("UrlOptions", urlOptions()).add("S3Options", s3Options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UrlOptions":
            return Optional.ofNullable(clazz.cast(urlOptions()));
        case "S3Options":
            return Optional.ofNullable(clazz.cast(s3Options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UrlOptions", URL_OPTIONS_FIELD);
        map.put("S3Options", S3_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticFileSource, T> g) {
        return obj -> g.apply((StaticFileSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticFileSource> {
        /**
         * <p>
         * The structure that contains the URL to download the static file from.
         * </p>
         * 
         * @param urlOptions
         *        The structure that contains the URL to download the static file from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlOptions(StaticFileUrlSourceOptions urlOptions);

        /**
         * <p>
         * The structure that contains the URL to download the static file from.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticFileUrlSourceOptions.Builder}
         * avoiding the need to create one manually via {@link StaticFileUrlSourceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticFileUrlSourceOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #urlOptions(StaticFileUrlSourceOptions)}.
         * 
         * @param urlOptions
         *        a consumer that will call methods on {@link StaticFileUrlSourceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlOptions(StaticFileUrlSourceOptions)
         */
        default Builder urlOptions(Consumer<StaticFileUrlSourceOptions.Builder> urlOptions) {
            return urlOptions(StaticFileUrlSourceOptions.builder().applyMutation(urlOptions).build());
        }

        /**
         * <p>
         * The structure that contains the Amazon S3 location to download the static file from.
         * </p>
         * 
         * @param s3Options
         *        The structure that contains the Amazon S3 location to download the static file from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Options(StaticFileS3SourceOptions s3Options);

        /**
         * <p>
         * The structure that contains the Amazon S3 location to download the static file from.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticFileS3SourceOptions.Builder}
         * avoiding the need to create one manually via {@link StaticFileS3SourceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticFileS3SourceOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Options(StaticFileS3SourceOptions)}.
         * 
         * @param s3Options
         *        a consumer that will call methods on {@link StaticFileS3SourceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Options(StaticFileS3SourceOptions)
         */
        default Builder s3Options(Consumer<StaticFileS3SourceOptions.Builder> s3Options) {
            return s3Options(StaticFileS3SourceOptions.builder().applyMutation(s3Options).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StaticFileUrlSourceOptions urlOptions;

        private StaticFileS3SourceOptions s3Options;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticFileSource model) {
            urlOptions(model.urlOptions);
            s3Options(model.s3Options);
        }

        public final StaticFileUrlSourceOptions.Builder getUrlOptions() {
            return urlOptions != null ? urlOptions.toBuilder() : null;
        }

        public final void setUrlOptions(StaticFileUrlSourceOptions.BuilderImpl urlOptions) {
            this.urlOptions = urlOptions != null ? urlOptions.build() : null;
        }

        @Override
        public final Builder urlOptions(StaticFileUrlSourceOptions urlOptions) {
            this.urlOptions = urlOptions;
            return this;
        }

        public final StaticFileS3SourceOptions.Builder getS3Options() {
            return s3Options != null ? s3Options.toBuilder() : null;
        }

        public final void setS3Options(StaticFileS3SourceOptions.BuilderImpl s3Options) {
            this.s3Options = s3Options != null ? s3Options.build() : null;
        }

        @Override
        public final Builder s3Options(StaticFileS3SourceOptions s3Options) {
            this.s3Options = s3Options;
            return this;
        }

        @Override
        public StaticFileSource build() {
            return new StaticFileSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
