/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDashboardSnapshotJobRequest extends QuickSightRequest implements
        ToCopyableBuilder<StartDashboardSnapshotJobRequest.Builder, StartDashboardSnapshotJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(StartDashboardSnapshotJobRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(StartDashboardSnapshotJobRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> SNAPSHOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotJobId").getter(getter(StartDashboardSnapshotJobRequest::snapshotJobId))
            .setter(setter(Builder::snapshotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotJobId").build()).build();

    private static final SdkField<SnapshotUserConfiguration> USER_CONFIGURATION_FIELD = SdkField
            .<SnapshotUserConfiguration> builder(MarshallingType.SDK_POJO).memberName("UserConfiguration")
            .getter(getter(StartDashboardSnapshotJobRequest::userConfiguration)).setter(setter(Builder::userConfiguration))
            .constructor(SnapshotUserConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserConfiguration").build()).build();

    private static final SdkField<SnapshotConfiguration> SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<SnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnapshotConfiguration")
            .getter(getter(StartDashboardSnapshotJobRequest::snapshotConfiguration))
            .setter(setter(Builder::snapshotConfiguration)).constructor(SnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, SNAPSHOT_JOB_ID_FIELD, USER_CONFIGURATION_FIELD, SNAPSHOT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dashboardId;

    private final String snapshotJobId;

    private final SnapshotUserConfiguration userConfiguration;

    private final SnapshotConfiguration snapshotConfiguration;

    private StartDashboardSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.snapshotJobId = builder.snapshotJobId;
        this.userConfiguration = builder.userConfiguration;
        this.snapshotConfiguration = builder.snapshotConfiguration;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the dashboard that you want to start a snapshot job for.
     * </p>
     * 
     * @return The ID of the dashboard that you want to start a snapshot job for.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This ID can be
     * used to poll the status of a job with a <code>DescribeDashboardSnapshotJob</code> while the job runs. You can
     * reuse this ID for another job 24 hours after the current job is completed.
     * </p>
     * 
     * @return An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This
     *         ID can be used to poll the status of a job with a <code>DescribeDashboardSnapshotJob</code> while the job
     *         runs. You can reuse this ID for another job 24 hours after the current job is completed.
     */
    public final String snapshotJobId() {
        return snapshotJobId;
    }

    /**
     * <p>
     * A structure that contains information about the anonymous users that the generated snapshot is for. This API will
     * not return information about registered QuickSight.
     * </p>
     * 
     * @return A structure that contains information about the anonymous users that the generated snapshot is for. This
     *         API will not return information about registered QuickSight.
     */
    public final SnapshotUserConfiguration userConfiguration() {
        return userConfiguration;
    }

    /**
     * <p>
     * A structure that describes the configuration of the dashboard snapshot.
     * </p>
     * 
     * @return A structure that describes the configuration of the dashboard snapshot.
     */
    public final SnapshotConfiguration snapshotConfiguration() {
        return snapshotConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(userConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardSnapshotJobRequest)) {
            return false;
        }
        StartDashboardSnapshotJobRequest other = (StartDashboardSnapshotJobRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(snapshotJobId(), other.snapshotJobId())
                && Objects.equals(userConfiguration(), other.userConfiguration())
                && Objects.equals(snapshotConfiguration(), other.snapshotConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDashboardSnapshotJobRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("SnapshotJobId", snapshotJobId())
                .add("UserConfiguration", userConfiguration()).add("SnapshotConfiguration", snapshotConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "SnapshotJobId":
            return Optional.ofNullable(clazz.cast(snapshotJobId()));
        case "UserConfiguration":
            return Optional.ofNullable(clazz.cast(userConfiguration()));
        case "SnapshotConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("SnapshotJobId", SNAPSHOT_JOB_ID_FIELD);
        map.put("UserConfiguration", USER_CONFIGURATION_FIELD);
        map.put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardSnapshotJobRequest, T> g) {
        return obj -> g.apply((StartDashboardSnapshotJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDashboardSnapshotJobRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the dashboard that you want to start a snapshot job for.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard that you want to start a snapshot job for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running. This ID
         * can be used to poll the status of a job with a <code>DescribeDashboardSnapshotJob</code> while the job runs.
         * You can reuse this ID for another job 24 hours after the current job is completed.
         * </p>
         * 
         * @param snapshotJobId
         *        An ID for the dashboard snapshot job. This ID is unique to the dashboard while the job is running.
         *        This ID can be used to poll the status of a job with a <code>DescribeDashboardSnapshotJob</code> while
         *        the job runs. You can reuse this ID for another job 24 hours after the current job is completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotJobId(String snapshotJobId);

        /**
         * <p>
         * A structure that contains information about the anonymous users that the generated snapshot is for. This API
         * will not return information about registered QuickSight.
         * </p>
         * 
         * @param userConfiguration
         *        A structure that contains information about the anonymous users that the generated snapshot is for.
         *        This API will not return information about registered QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userConfiguration(SnapshotUserConfiguration userConfiguration);

        /**
         * <p>
         * A structure that contains information about the anonymous users that the generated snapshot is for. This API
         * will not return information about registered QuickSight.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotUserConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnapshotUserConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotUserConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #userConfiguration(SnapshotUserConfiguration)}.
         * 
         * @param userConfiguration
         *        a consumer that will call methods on {@link SnapshotUserConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userConfiguration(SnapshotUserConfiguration)
         */
        default Builder userConfiguration(Consumer<SnapshotUserConfiguration.Builder> userConfiguration) {
            return userConfiguration(SnapshotUserConfiguration.builder().applyMutation(userConfiguration).build());
        }

        /**
         * <p>
         * A structure that describes the configuration of the dashboard snapshot.
         * </p>
         * 
         * @param snapshotConfiguration
         *        A structure that describes the configuration of the dashboard snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration);

        /**
         * <p>
         * A structure that describes the configuration of the dashboard snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotConfiguration.Builder} avoiding
         * the need to create one manually via {@link SnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotConfiguration(SnapshotConfiguration)}.
         * 
         * @param snapshotConfiguration
         *        a consumer that will call methods on {@link SnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotConfiguration(SnapshotConfiguration)
         */
        default Builder snapshotConfiguration(Consumer<SnapshotConfiguration.Builder> snapshotConfiguration) {
            return snapshotConfiguration(SnapshotConfiguration.builder().applyMutation(snapshotConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String snapshotJobId;

        private SnapshotUserConfiguration userConfiguration;

        private SnapshotConfiguration snapshotConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardSnapshotJobRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            snapshotJobId(model.snapshotJobId);
            userConfiguration(model.userConfiguration);
            snapshotConfiguration(model.snapshotConfiguration);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getSnapshotJobId() {
            return snapshotJobId;
        }

        public final void setSnapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
        }

        @Override
        public final Builder snapshotJobId(String snapshotJobId) {
            this.snapshotJobId = snapshotJobId;
            return this;
        }

        public final SnapshotUserConfiguration.Builder getUserConfiguration() {
            return userConfiguration != null ? userConfiguration.toBuilder() : null;
        }

        public final void setUserConfiguration(SnapshotUserConfiguration.BuilderImpl userConfiguration) {
            this.userConfiguration = userConfiguration != null ? userConfiguration.build() : null;
        }

        @Override
        public final Builder userConfiguration(SnapshotUserConfiguration userConfiguration) {
            this.userConfiguration = userConfiguration;
            return this;
        }

        public final SnapshotConfiguration.Builder getSnapshotConfiguration() {
            return snapshotConfiguration != null ? snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(SnapshotConfiguration.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(SnapshotConfiguration snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDashboardSnapshotJobRequest build() {
            return new StartDashboardSnapshotJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
