/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tooltip configuration for a sheet image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetImageTooltipConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SheetImageTooltipConfiguration.Builder, SheetImageTooltipConfiguration> {
    private static final SdkField<SheetImageTooltipText> TOOLTIP_TEXT_FIELD = SdkField
            .<SheetImageTooltipText> builder(MarshallingType.SDK_POJO).memberName("TooltipText")
            .getter(getter(SheetImageTooltipConfiguration::tooltipText)).setter(setter(Builder::tooltipText))
            .constructor(SheetImageTooltipText::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipText").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(SheetImageTooltipConfiguration::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLTIP_TEXT_FIELD,
            VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SheetImageTooltipText tooltipText;

    private final String visibility;

    private SheetImageTooltipConfiguration(BuilderImpl builder) {
        this.tooltipText = builder.tooltipText;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The text that appears in the tooltip.
     * </p>
     * 
     * @return The text that appears in the tooltip.
     */
    public final SheetImageTooltipText tooltipText() {
        return tooltipText;
    }

    /**
     * <p>
     * The visibility of the tooltip.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the tooltip.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the tooltip.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tooltipText());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImageTooltipConfiguration)) {
            return false;
        }
        SheetImageTooltipConfiguration other = (SheetImageTooltipConfiguration) obj;
        return Objects.equals(tooltipText(), other.tooltipText())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetImageTooltipConfiguration").add("TooltipText", tooltipText())
                .add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TooltipText":
            return Optional.ofNullable(clazz.cast(tooltipText()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TooltipText", TOOLTIP_TEXT_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImageTooltipConfiguration, T> g) {
        return obj -> g.apply((SheetImageTooltipConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetImageTooltipConfiguration> {
        /**
         * <p>
         * The text that appears in the tooltip.
         * </p>
         * 
         * @param tooltipText
         *        The text that appears in the tooltip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltipText(SheetImageTooltipText tooltipText);

        /**
         * <p>
         * The text that appears in the tooltip.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetImageTooltipText.Builder} avoiding
         * the need to create one manually via {@link SheetImageTooltipText#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetImageTooltipText.Builder#build()} is called immediately and
         * its result is passed to {@link #tooltipText(SheetImageTooltipText)}.
         * 
         * @param tooltipText
         *        a consumer that will call methods on {@link SheetImageTooltipText.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltipText(SheetImageTooltipText)
         */
        default Builder tooltipText(Consumer<SheetImageTooltipText.Builder> tooltipText) {
            return tooltipText(SheetImageTooltipText.builder().applyMutation(tooltipText).build());
        }

        /**
         * <p>
         * The visibility of the tooltip.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the tooltip.
         * </p>
         * 
         * @param visibility
         *        The visibility of the tooltip.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);
    }

    static final class BuilderImpl implements Builder {
        private SheetImageTooltipText tooltipText;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImageTooltipConfiguration model) {
            tooltipText(model.tooltipText);
            visibility(model.visibility);
        }

        public final SheetImageTooltipText.Builder getTooltipText() {
            return tooltipText != null ? tooltipText.toBuilder() : null;
        }

        public final void setTooltipText(SheetImageTooltipText.BuilderImpl tooltipText) {
            this.tooltipText = tooltipText != null ? tooltipText.build() : null;
        }

        @Override
        public final Builder tooltipText(SheetImageTooltipText tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public SheetImageTooltipConfiguration build() {
            return new SheetImageTooltipConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
