/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The formatting configuration for all types of field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormatConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FormatConfiguration.Builder, FormatConfiguration> {
    private static final SdkField<StringFormatConfiguration> STRING_FORMAT_CONFIGURATION_FIELD = SdkField
            .<StringFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("StringFormatConfiguration")
            .getter(getter(FormatConfiguration::stringFormatConfiguration)).setter(setter(Builder::stringFormatConfiguration))
            .constructor(StringFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFormatConfiguration").build())
            .build();

    private static final SdkField<NumberFormatConfiguration> NUMBER_FORMAT_CONFIGURATION_FIELD = SdkField
            .<NumberFormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("NumberFormatConfiguration")
            .getter(getter(FormatConfiguration::numberFormatConfiguration)).setter(setter(Builder::numberFormatConfiguration))
            .constructor(NumberFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberFormatConfiguration").build())
            .build();

    private static final SdkField<DateTimeFormatConfiguration> DATE_TIME_FORMAT_CONFIGURATION_FIELD = SdkField
            .<DateTimeFormatConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DateTimeFormatConfiguration")
            .getter(getter(FormatConfiguration::dateTimeFormatConfiguration))
            .setter(setter(Builder::dateTimeFormatConfiguration))
            .constructor(DateTimeFormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeFormatConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STRING_FORMAT_CONFIGURATION_FIELD, NUMBER_FORMAT_CONFIGURATION_FIELD, DATE_TIME_FORMAT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StringFormatConfiguration stringFormatConfiguration;

    private final NumberFormatConfiguration numberFormatConfiguration;

    private final DateTimeFormatConfiguration dateTimeFormatConfiguration;

    private FormatConfiguration(BuilderImpl builder) {
        this.stringFormatConfiguration = builder.stringFormatConfiguration;
        this.numberFormatConfiguration = builder.numberFormatConfiguration;
        this.dateTimeFormatConfiguration = builder.dateTimeFormatConfiguration;
    }

    /**
     * <p>
     * Formatting configuration for string fields.
     * </p>
     * 
     * @return Formatting configuration for string fields.
     */
    public final StringFormatConfiguration stringFormatConfiguration() {
        return stringFormatConfiguration;
    }

    /**
     * <p>
     * Formatting configuration for number fields.
     * </p>
     * 
     * @return Formatting configuration for number fields.
     */
    public final NumberFormatConfiguration numberFormatConfiguration() {
        return numberFormatConfiguration;
    }

    /**
     * <p>
     * Formatting configuration for <code>DateTime</code> fields.
     * </p>
     * 
     * @return Formatting configuration for <code>DateTime</code> fields.
     */
    public final DateTimeFormatConfiguration dateTimeFormatConfiguration() {
        return dateTimeFormatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(numberFormatConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeFormatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormatConfiguration)) {
            return false;
        }
        FormatConfiguration other = (FormatConfiguration) obj;
        return Objects.equals(stringFormatConfiguration(), other.stringFormatConfiguration())
                && Objects.equals(numberFormatConfiguration(), other.numberFormatConfiguration())
                && Objects.equals(dateTimeFormatConfiguration(), other.dateTimeFormatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormatConfiguration").add("StringFormatConfiguration", stringFormatConfiguration())
                .add("NumberFormatConfiguration", numberFormatConfiguration())
                .add("DateTimeFormatConfiguration", dateTimeFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringFormatConfiguration":
            return Optional.ofNullable(clazz.cast(stringFormatConfiguration()));
        case "NumberFormatConfiguration":
            return Optional.ofNullable(clazz.cast(numberFormatConfiguration()));
        case "DateTimeFormatConfiguration":
            return Optional.ofNullable(clazz.cast(dateTimeFormatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringFormatConfiguration", STRING_FORMAT_CONFIGURATION_FIELD);
        map.put("NumberFormatConfiguration", NUMBER_FORMAT_CONFIGURATION_FIELD);
        map.put("DateTimeFormatConfiguration", DATE_TIME_FORMAT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormatConfiguration, T> g) {
        return obj -> g.apply((FormatConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormatConfiguration> {
        /**
         * <p>
         * Formatting configuration for string fields.
         * </p>
         * 
         * @param stringFormatConfiguration
         *        Formatting configuration for string fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringFormatConfiguration(StringFormatConfiguration stringFormatConfiguration);

        /**
         * <p>
         * Formatting configuration for string fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link StringFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #stringFormatConfiguration(StringFormatConfiguration)}.
         * 
         * @param stringFormatConfiguration
         *        a consumer that will call methods on {@link StringFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringFormatConfiguration(StringFormatConfiguration)
         */
        default Builder stringFormatConfiguration(Consumer<StringFormatConfiguration.Builder> stringFormatConfiguration) {
            return stringFormatConfiguration(StringFormatConfiguration.builder().applyMutation(stringFormatConfiguration).build());
        }

        /**
         * <p>
         * Formatting configuration for number fields.
         * </p>
         * 
         * @param numberFormatConfiguration
         *        Formatting configuration for number fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberFormatConfiguration(NumberFormatConfiguration numberFormatConfiguration);

        /**
         * <p>
         * Formatting configuration for number fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link NumberFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberFormatConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #numberFormatConfiguration(NumberFormatConfiguration)}.
         * 
         * @param numberFormatConfiguration
         *        a consumer that will call methods on {@link NumberFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberFormatConfiguration(NumberFormatConfiguration)
         */
        default Builder numberFormatConfiguration(Consumer<NumberFormatConfiguration.Builder> numberFormatConfiguration) {
            return numberFormatConfiguration(NumberFormatConfiguration.builder().applyMutation(numberFormatConfiguration).build());
        }

        /**
         * <p>
         * Formatting configuration for <code>DateTime</code> fields.
         * </p>
         * 
         * @param dateTimeFormatConfiguration
         *        Formatting configuration for <code>DateTime</code> fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeFormatConfiguration(DateTimeFormatConfiguration dateTimeFormatConfiguration);

        /**
         * <p>
         * Formatting configuration for <code>DateTime</code> fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeFormatConfiguration.Builder}
         * avoiding the need to create one manually via {@link DateTimeFormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeFormatConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dateTimeFormatConfiguration(DateTimeFormatConfiguration)}.
         * 
         * @param dateTimeFormatConfiguration
         *        a consumer that will call methods on {@link DateTimeFormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeFormatConfiguration(DateTimeFormatConfiguration)
         */
        default Builder dateTimeFormatConfiguration(Consumer<DateTimeFormatConfiguration.Builder> dateTimeFormatConfiguration) {
            return dateTimeFormatConfiguration(DateTimeFormatConfiguration.builder().applyMutation(dateTimeFormatConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringFormatConfiguration stringFormatConfiguration;

        private NumberFormatConfiguration numberFormatConfiguration;

        private DateTimeFormatConfiguration dateTimeFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FormatConfiguration model) {
            stringFormatConfiguration(model.stringFormatConfiguration);
            numberFormatConfiguration(model.numberFormatConfiguration);
            dateTimeFormatConfiguration(model.dateTimeFormatConfiguration);
        }

        public final StringFormatConfiguration.Builder getStringFormatConfiguration() {
            return stringFormatConfiguration != null ? stringFormatConfiguration.toBuilder() : null;
        }

        public final void setStringFormatConfiguration(StringFormatConfiguration.BuilderImpl stringFormatConfiguration) {
            this.stringFormatConfiguration = stringFormatConfiguration != null ? stringFormatConfiguration.build() : null;
        }

        @Override
        public final Builder stringFormatConfiguration(StringFormatConfiguration stringFormatConfiguration) {
            this.stringFormatConfiguration = stringFormatConfiguration;
            return this;
        }

        public final NumberFormatConfiguration.Builder getNumberFormatConfiguration() {
            return numberFormatConfiguration != null ? numberFormatConfiguration.toBuilder() : null;
        }

        public final void setNumberFormatConfiguration(NumberFormatConfiguration.BuilderImpl numberFormatConfiguration) {
            this.numberFormatConfiguration = numberFormatConfiguration != null ? numberFormatConfiguration.build() : null;
        }

        @Override
        public final Builder numberFormatConfiguration(NumberFormatConfiguration numberFormatConfiguration) {
            this.numberFormatConfiguration = numberFormatConfiguration;
            return this;
        }

        public final DateTimeFormatConfiguration.Builder getDateTimeFormatConfiguration() {
            return dateTimeFormatConfiguration != null ? dateTimeFormatConfiguration.toBuilder() : null;
        }

        public final void setDateTimeFormatConfiguration(DateTimeFormatConfiguration.BuilderImpl dateTimeFormatConfiguration) {
            this.dateTimeFormatConfiguration = dateTimeFormatConfiguration != null ? dateTimeFormatConfiguration.build() : null;
        }

        @Override
        public final Builder dateTimeFormatConfiguration(DateTimeFormatConfiguration dateTimeFormatConfiguration) {
            this.dateTimeFormatConfiguration = dateTimeFormatConfiguration;
            return this;
        }

        @Override
        public FormatConfiguration build() {
            return new FormatConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
