/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option to relax the validation that is required to create and update analyses, dashboards, and templates with
 * definition objects. When you set this value to <code>LENIENT</code>, validation is skipped for specific errors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationStrategy.Builder, ValidationStrategy> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(ValidationStrategy::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private ValidationStrategy(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The mode of validation for the asset to be created or updated. When you set this value to <code>STRICT</code>,
     * strict validation for every error is enforced. When you set this value to <code>LENIENT</code>, validation is
     * skipped for specific UI errors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ValidationStrategyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of validation for the asset to be created or updated. When you set this value to
     *         <code>STRICT</code>, strict validation for every error is enforced. When you set this value to
     *         <code>LENIENT</code>, validation is skipped for specific UI errors.
     * @see ValidationStrategyMode
     */
    public final ValidationStrategyMode mode() {
        return ValidationStrategyMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of validation for the asset to be created or updated. When you set this value to <code>STRICT</code>,
     * strict validation for every error is enforced. When you set this value to <code>LENIENT</code>, validation is
     * skipped for specific UI errors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ValidationStrategyMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of validation for the asset to be created or updated. When you set this value to
     *         <code>STRICT</code>, strict validation for every error is enforced. When you set this value to
     *         <code>LENIENT</code>, validation is skipped for specific UI errors.
     * @see ValidationStrategyMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationStrategy)) {
            return false;
        }
        ValidationStrategy other = (ValidationStrategy) obj;
        return Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationStrategy").add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationStrategy, T> g) {
        return obj -> g.apply((ValidationStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationStrategy> {
        /**
         * <p>
         * The mode of validation for the asset to be created or updated. When you set this value to <code>STRICT</code>
         * , strict validation for every error is enforced. When you set this value to <code>LENIENT</code>, validation
         * is skipped for specific UI errors.
         * </p>
         * 
         * @param mode
         *        The mode of validation for the asset to be created or updated. When you set this value to
         *        <code>STRICT</code>, strict validation for every error is enforced. When you set this value to
         *        <code>LENIENT</code>, validation is skipped for specific UI errors.
         * @see ValidationStrategyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStrategyMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of validation for the asset to be created or updated. When you set this value to <code>STRICT</code>
         * , strict validation for every error is enforced. When you set this value to <code>LENIENT</code>, validation
         * is skipped for specific UI errors.
         * </p>
         * 
         * @param mode
         *        The mode of validation for the asset to be created or updated. When you set this value to
         *        <code>STRICT</code>, strict validation for every error is enforced. When you set this value to
         *        <code>LENIENT</code>, validation is skipped for specific UI errors.
         * @see ValidationStrategyMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationStrategyMode
         */
        Builder mode(ValidationStrategyMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationStrategy model) {
            mode(model.mode);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ValidationStrategyMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public ValidationStrategy build() {
            return new ValidationStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
