/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAssetBundleExportJobResponse extends QuickSightResponse implements
        ToCopyableBuilder<StartAssetBundleExportJobResponse.Builder, StartAssetBundleExportJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(StartAssetBundleExportJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ASSET_BUNDLE_EXPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetBundleExportJobId").getter(getter(StartAssetBundleExportJobResponse::assetBundleExportJobId))
            .setter(setter(Builder::assetBundleExportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleExportJobId").build())
            .build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(StartAssetBundleExportJobResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(StartAssetBundleExportJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ASSET_BUNDLE_EXPORT_JOB_ID_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String assetBundleExportJobId;

    private final String requestId;

    private final Integer status;

    private StartAssetBundleExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.assetBundleExportJobId = builder.assetBundleExportJobId;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the export job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the export job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this ID
     * for another job.
     * </p>
     * 
     * @return The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse
     *         this ID for another job.
     */
    public final String assetBundleExportJobId() {
        return assetBundleExportJobId;
    }

    /**
     * <p>
     * The Amazon Web Services response ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services response ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the response.
     * </p>
     * 
     * @return The HTTP status of the response.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(assetBundleExportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleExportJobResponse)) {
            return false;
        }
        StartAssetBundleExportJobResponse other = (StartAssetBundleExportJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(assetBundleExportJobId(), other.assetBundleExportJobId())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAssetBundleExportJobResponse").add("Arn", arn())
                .add("AssetBundleExportJobId", assetBundleExportJobId()).add("RequestId", requestId()).add("Status", status())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AssetBundleExportJobId":
            return Optional.ofNullable(clazz.cast(assetBundleExportJobId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AssetBundleExportJobId", ASSET_BUNDLE_EXPORT_JOB_ID_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleExportJobResponse, T> g) {
        return obj -> g.apply((StartAssetBundleExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAssetBundleExportJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the export job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the job. This ID is unique while the job is running. After the job is completed, you can reuse this
         * ID for another job.
         * </p>
         * 
         * @param assetBundleExportJobId
         *        The ID of the job. This ID is unique while the job is running. After the job is completed, you can
         *        reuse this ID for another job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetBundleExportJobId(String assetBundleExportJobId);

        /**
         * <p>
         * The Amazon Web Services response ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services response ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the response.
         * </p>
         * 
         * @param status
         *        The HTTP status of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String assetBundleExportJobId;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleExportJobResponse model) {
            super(model);
            arn(model.arn);
            assetBundleExportJobId(model.assetBundleExportJobId);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAssetBundleExportJobId() {
            return assetBundleExportJobId;
        }

        public final void setAssetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
        }

        @Override
        public final Builder assetBundleExportJobId(String assetBundleExportJobId) {
            this.assetBundleExportJobId = assetBundleExportJobId;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public StartAssetBundleExportJobResponse build() {
            return new StartAssetBundleExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
