/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 result from the snapshot job. The result includes the <code>DestinationConfiguration</code> and the
 * Amazon S3 Uri. If an error occured during the job, the result returns information on the error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotJobS3Result implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotJobS3Result.Builder, SnapshotJobS3Result> {
    private static final SdkField<SnapshotS3DestinationConfiguration> S3_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<SnapshotS3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("S3DestinationConfiguration")
            .getter(getter(SnapshotJobS3Result::s3DestinationConfiguration))
            .setter(setter(Builder::s3DestinationConfiguration))
            .constructor(SnapshotS3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationConfiguration").build())
            .build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(SnapshotJobS3Result::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<List<SnapshotJobResultErrorInfo>> ERROR_INFO_FIELD = SdkField
            .<List<SnapshotJobResultErrorInfo>> builder(MarshallingType.LIST)
            .memberName("ErrorInfo")
            .getter(getter(SnapshotJobS3Result::errorInfo))
            .setter(setter(Builder::errorInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotJobResultErrorInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotJobResultErrorInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            S3_DESTINATION_CONFIGURATION_FIELD, S3_URI_FIELD, ERROR_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SnapshotS3DestinationConfiguration s3DestinationConfiguration;

    private final String s3Uri;

    private final List<SnapshotJobResultErrorInfo> errorInfo;

    private SnapshotJobS3Result(BuilderImpl builder) {
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.s3Uri = builder.s3Uri;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * A list of Amazon S3 bucket configurations that are provided when you make a
     * <code>StartDashboardSnapshotJob</code> API call.
     * </p>
     * 
     * @return A list of Amazon S3 bucket configurations that are provided when you make a
     *         <code>StartDashboardSnapshotJob</code> API call.
     */
    public final SnapshotS3DestinationConfiguration s3DestinationConfiguration() {
        return s3DestinationConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 Uri.
     * </p>
     * 
     * @return The Amazon S3 Uri.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorInfo property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrorInfo() {
        return errorInfo != null && !(errorInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorInfo} method.
     * </p>
     * 
     * @return An array of error records that describe any failures that occur while the dashboard snapshot job runs.
     */
    public final List<SnapshotJobResultErrorInfo> errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrorInfo() ? errorInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobS3Result)) {
            return false;
        }
        SnapshotJobS3Result other = (SnapshotJobS3Result) obj;
        return Objects.equals(s3DestinationConfiguration(), other.s3DestinationConfiguration())
                && Objects.equals(s3Uri(), other.s3Uri()) && hasErrorInfo() == other.hasErrorInfo()
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotJobS3Result").add("S3DestinationConfiguration", s3DestinationConfiguration())
                .add("S3Uri", s3Uri() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ErrorInfo", hasErrorInfo() ? errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DestinationConfiguration":
            return Optional.ofNullable(clazz.cast(s3DestinationConfiguration()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3DestinationConfiguration", S3_DESTINATION_CONFIGURATION_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        map.put("ErrorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotJobS3Result, T> g) {
        return obj -> g.apply((SnapshotJobS3Result) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotJobS3Result> {
        /**
         * <p>
         * A list of Amazon S3 bucket configurations that are provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * 
         * @param s3DestinationConfiguration
         *        A list of Amazon S3 bucket configurations that are provided when you make a
         *        <code>StartDashboardSnapshotJob</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfiguration(SnapshotS3DestinationConfiguration s3DestinationConfiguration);

        /**
         * <p>
         * A list of Amazon S3 bucket configurations that are provided when you make a
         * <code>StartDashboardSnapshotJob</code> API call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SnapshotS3DestinationConfiguration.Builder} avoiding the need to create one manually via
         * {@link SnapshotS3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotS3DestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3DestinationConfiguration(SnapshotS3DestinationConfiguration)}.
         * 
         * @param s3DestinationConfiguration
         *        a consumer that will call methods on {@link SnapshotS3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfiguration(SnapshotS3DestinationConfiguration)
         */
        default Builder s3DestinationConfiguration(Consumer<SnapshotS3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return s3DestinationConfiguration(SnapshotS3DestinationConfiguration.builder()
                    .applyMutation(s3DestinationConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 Uri.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 Uri.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         * </p>
         * 
         * @param errorInfo
         *        An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(Collection<SnapshotJobResultErrorInfo> errorInfo);

        /**
         * <p>
         * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         * </p>
         * 
         * @param errorInfo
         *        An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(SnapshotJobResultErrorInfo... errorInfo);

        /**
         * <p>
         * An array of error records that describe any failures that occur while the dashboard snapshot job runs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfo.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #errorInfo(List<SnapshotJobResultErrorInfo>)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(java.util.Collection<SnapshotJobResultErrorInfo>)
         */
        Builder errorInfo(Consumer<SnapshotJobResultErrorInfo.Builder>... errorInfo);
    }

    static final class BuilderImpl implements Builder {
        private SnapshotS3DestinationConfiguration s3DestinationConfiguration;

        private String s3Uri;

        private List<SnapshotJobResultErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotJobS3Result model) {
            s3DestinationConfiguration(model.s3DestinationConfiguration);
            s3Uri(model.s3Uri);
            errorInfo(model.errorInfo);
        }

        public final SnapshotS3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return s3DestinationConfiguration != null ? s3DestinationConfiguration.toBuilder() : null;
        }

        public final void setS3DestinationConfiguration(SnapshotS3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(SnapshotS3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final List<SnapshotJobResultErrorInfo.Builder> getErrorInfo() {
            List<SnapshotJobResultErrorInfo.Builder> result = SnapshotJobResultErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<SnapshotJobResultErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = SnapshotJobResultErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<SnapshotJobResultErrorInfo> errorInfo) {
            this.errorInfo = SnapshotJobResultErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(SnapshotJobResultErrorInfo... errorInfo) {
            errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<SnapshotJobResultErrorInfo.Builder>... errorInfo) {
            errorInfo(Stream.of(errorInfo).map(c -> SnapshotJobResultErrorInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotJobS3Result build() {
            return new SnapshotJobS3Result(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
