/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTopicReviewedAnswersResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListTopicReviewedAnswersResponse.Builder, ListTopicReviewedAnswersResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicId").getter(getter(ListTopicReviewedAnswersResponse::topicId)).setter(setter(Builder::topicId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(ListTopicReviewedAnswersResponse::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<List<TopicReviewedAnswer>> ANSWERS_FIELD = SdkField
            .<List<TopicReviewedAnswer>> builder(MarshallingType.LIST)
            .memberName("Answers")
            .getter(getter(ListTopicReviewedAnswersResponse::answers))
            .setter(setter(Builder::answers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicReviewedAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicReviewedAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListTopicReviewedAnswersResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListTopicReviewedAnswersResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD,
            TOPIC_ARN_FIELD, ANSWERS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String topicId;

    private final String topicArn;

    private final List<TopicReviewedAnswer> answers;

    private final Integer status;

    private final String requestId;

    private ListTopicReviewedAnswersResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.answers = builder.answers;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per Amazon Web
     * Services Region for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per
     *         Amazon Web Services Region for each Amazon Web Services account.
     */
    public final String topicId() {
        return topicId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the topic.
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Answers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnswers() {
        return answers != null && !(answers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definition of all Answers in the topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswers} method.
     * </p>
     * 
     * @return The definition of all Answers in the topic.
     */
    public final List<TopicReviewedAnswer> answers() {
        return answers;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicId());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswers() ? answers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicReviewedAnswersResponse)) {
            return false;
        }
        ListTopicReviewedAnswersResponse other = (ListTopicReviewedAnswersResponse) obj;
        return Objects.equals(topicId(), other.topicId()) && Objects.equals(topicArn(), other.topicArn())
                && hasAnswers() == other.hasAnswers() && Objects.equals(answers(), other.answers())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTopicReviewedAnswersResponse").add("TopicId", topicId()).add("TopicArn", topicArn())
                .add("Answers", hasAnswers() ? answers() : null).add("Status", status()).add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicId":
            return Optional.ofNullable(clazz.cast(topicId()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "Answers":
            return Optional.ofNullable(clazz.cast(answers()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("Answers", ANSWERS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTopicReviewedAnswersResponse, T> g) {
        return obj -> g.apply((ListTopicReviewedAnswersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTopicReviewedAnswersResponse> {
        /**
         * <p>
         * The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per Amazon
         * Web Services Region for each Amazon Web Services account.
         * </p>
         * 
         * @param topicId
         *        The ID for the topic that contains the reviewed answer that you want to list. This ID is unique per
         *        Amazon Web Services Region for each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicId(String topicId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the topic.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The definition of all Answers in the topic.
         * </p>
         * 
         * @param answers
         *        The definition of all Answers in the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(Collection<TopicReviewedAnswer> answers);

        /**
         * <p>
         * The definition of all Answers in the topic.
         * </p>
         * 
         * @param answers
         *        The definition of all Answers in the topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(TopicReviewedAnswer... answers);

        /**
         * <p>
         * The definition of all Answers in the topic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TopicReviewedAnswer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.TopicReviewedAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TopicReviewedAnswer.Builder#build()} is called
         * immediately and its result is passed to {@link #answers(List<TopicReviewedAnswer>)}.
         * 
         * @param answers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TopicReviewedAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #answers(java.util.Collection<TopicReviewedAnswer>)
         */
        Builder answers(Consumer<TopicReviewedAnswer.Builder>... answers);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String topicId;

        private String topicArn;

        private List<TopicReviewedAnswer> answers = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicReviewedAnswersResponse model) {
            super(model);
            topicId(model.topicId);
            topicArn(model.topicArn);
            answers(model.answers);
            status(model.status);
            requestId(model.requestId);
        }

        public final String getTopicId() {
            return topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<TopicReviewedAnswer.Builder> getAnswers() {
            List<TopicReviewedAnswer.Builder> result = TopicReviewedAnswersCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Collection<TopicReviewedAnswer.BuilderImpl> answers) {
            this.answers = TopicReviewedAnswersCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Collection<TopicReviewedAnswer> answers) {
            this.answers = TopicReviewedAnswersCopier.copy(answers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answers(TopicReviewedAnswer... answers) {
            answers(Arrays.asList(answers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answers(Consumer<TopicReviewedAnswer.Builder>... answers) {
            answers(Stream.of(answers).map(c -> TopicReviewedAnswer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListTopicReviewedAnswersResponse build() {
            return new ListTopicReviewedAnswersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
