/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <code>FilledMapVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilledMapConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilledMapConfiguration.Builder, FilledMapConfiguration> {
    private static final SdkField<FilledMapFieldWells> FIELD_WELLS_FIELD = SdkField
            .<FilledMapFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(FilledMapConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(FilledMapFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<FilledMapSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<FilledMapSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(FilledMapConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(FilledMapSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(FilledMapConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(FilledMapConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<GeospatialWindowOptions> WINDOW_OPTIONS_FIELD = SdkField
            .<GeospatialWindowOptions> builder(MarshallingType.SDK_POJO).memberName("WindowOptions")
            .getter(getter(FilledMapConfiguration::windowOptions)).setter(setter(Builder::windowOptions))
            .constructor(GeospatialWindowOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowOptions").build()).build();

    private static final SdkField<GeospatialMapStyleOptions> MAP_STYLE_OPTIONS_FIELD = SdkField
            .<GeospatialMapStyleOptions> builder(MarshallingType.SDK_POJO).memberName("MapStyleOptions")
            .getter(getter(FilledMapConfiguration::mapStyleOptions)).setter(setter(Builder::mapStyleOptions))
            .constructor(GeospatialMapStyleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapStyleOptions").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(FilledMapConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, LEGEND_FIELD, TOOLTIP_FIELD, WINDOW_OPTIONS_FIELD, MAP_STYLE_OPTIONS_FIELD,
            INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FilledMapFieldWells fieldWells;

    private final FilledMapSortConfiguration sortConfiguration;

    private final LegendOptions legend;

    private final TooltipOptions tooltip;

    private final GeospatialWindowOptions windowOptions;

    private final GeospatialMapStyleOptions mapStyleOptions;

    private final VisualInteractionOptions interactions;

    private FilledMapConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.legend = builder.legend;
        this.tooltip = builder.tooltip;
        this.windowOptions = builder.windowOptions;
        this.mapStyleOptions = builder.mapStyleOptions;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field wells of the visual.
     * </p>
     * 
     * @return The field wells of the visual.
     */
    public final FilledMapFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>FilledMapVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>FilledMapVisual</code>.
     */
    public final FilledMapSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The legend display setup of the visual.
     * </p>
     * 
     * @return The legend display setup of the visual.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The tooltip display setup of the visual.
     * </p>
     * 
     * @return The tooltip display setup of the visual.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The window options of the filled map visual.
     * </p>
     * 
     * @return The window options of the filled map visual.
     */
    public final GeospatialWindowOptions windowOptions() {
        return windowOptions;
    }

    /**
     * <p>
     * The map style options of the filled map visual.
     * </p>
     * 
     * @return The map style options of the filled map visual.
     */
    public final GeospatialMapStyleOptions mapStyleOptions() {
        return mapStyleOptions;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(windowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(mapStyleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilledMapConfiguration)) {
            return false;
        }
        FilledMapConfiguration other = (FilledMapConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(legend(), other.legend()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(windowOptions(), other.windowOptions())
                && Objects.equals(mapStyleOptions(), other.mapStyleOptions())
                && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilledMapConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("Legend", legend()).add("Tooltip", tooltip())
                .add("WindowOptions", windowOptions()).add("MapStyleOptions", mapStyleOptions())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "WindowOptions":
            return Optional.ofNullable(clazz.cast(windowOptions()));
        case "MapStyleOptions":
            return Optional.ofNullable(clazz.cast(mapStyleOptions()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("WindowOptions", WINDOW_OPTIONS_FIELD);
        map.put("MapStyleOptions", MAP_STYLE_OPTIONS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilledMapConfiguration, T> g) {
        return obj -> g.apply((FilledMapConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilledMapConfiguration> {
        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * 
         * @param fieldWells
         *        The field wells of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(FilledMapFieldWells fieldWells);

        /**
         * <p>
         * The field wells of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilledMapFieldWells.Builder} avoiding the
         * need to create one manually via {@link FilledMapFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilledMapFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(FilledMapFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link FilledMapFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(FilledMapFieldWells)
         */
        default Builder fieldWells(Consumer<FilledMapFieldWells.Builder> fieldWells) {
            return fieldWells(FilledMapFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>FilledMapVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>FilledMapVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(FilledMapSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>FilledMapVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilledMapSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link FilledMapSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilledMapSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(FilledMapSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link FilledMapSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(FilledMapSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<FilledMapSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(FilledMapSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * 
         * @param legend
         *        The legend display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * 
         * @param tooltip
         *        The tooltip display setup of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip display setup of the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The window options of the filled map visual.
         * </p>
         * 
         * @param windowOptions
         *        The window options of the filled map visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowOptions(GeospatialWindowOptions windowOptions);

        /**
         * <p>
         * The window options of the filled map visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialWindowOptions.Builder} avoiding
         * the need to create one manually via {@link GeospatialWindowOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialWindowOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #windowOptions(GeospatialWindowOptions)}.
         * 
         * @param windowOptions
         *        a consumer that will call methods on {@link GeospatialWindowOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowOptions(GeospatialWindowOptions)
         */
        default Builder windowOptions(Consumer<GeospatialWindowOptions.Builder> windowOptions) {
            return windowOptions(GeospatialWindowOptions.builder().applyMutation(windowOptions).build());
        }

        /**
         * <p>
         * The map style options of the filled map visual.
         * </p>
         * 
         * @param mapStyleOptions
         *        The map style options of the filled map visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapStyleOptions(GeospatialMapStyleOptions mapStyleOptions);

        /**
         * <p>
         * The map style options of the filled map visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialMapStyleOptions.Builder}
         * avoiding the need to create one manually via {@link GeospatialMapStyleOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialMapStyleOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #mapStyleOptions(GeospatialMapStyleOptions)}.
         * 
         * @param mapStyleOptions
         *        a consumer that will call methods on {@link GeospatialMapStyleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapStyleOptions(GeospatialMapStyleOptions)
         */
        default Builder mapStyleOptions(Consumer<GeospatialMapStyleOptions.Builder> mapStyleOptions) {
            return mapStyleOptions(GeospatialMapStyleOptions.builder().applyMutation(mapStyleOptions).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilledMapFieldWells fieldWells;

        private FilledMapSortConfiguration sortConfiguration;

        private LegendOptions legend;

        private TooltipOptions tooltip;

        private GeospatialWindowOptions windowOptions;

        private GeospatialMapStyleOptions mapStyleOptions;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(FilledMapConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            legend(model.legend);
            tooltip(model.tooltip);
            windowOptions(model.windowOptions);
            mapStyleOptions(model.mapStyleOptions);
            interactions(model.interactions);
        }

        public final FilledMapFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(FilledMapFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(FilledMapFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final FilledMapSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(FilledMapSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(FilledMapSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final GeospatialWindowOptions.Builder getWindowOptions() {
            return windowOptions != null ? windowOptions.toBuilder() : null;
        }

        public final void setWindowOptions(GeospatialWindowOptions.BuilderImpl windowOptions) {
            this.windowOptions = windowOptions != null ? windowOptions.build() : null;
        }

        @Override
        public final Builder windowOptions(GeospatialWindowOptions windowOptions) {
            this.windowOptions = windowOptions;
            return this;
        }

        public final GeospatialMapStyleOptions.Builder getMapStyleOptions() {
            return mapStyleOptions != null ? mapStyleOptions.toBuilder() : null;
        }

        public final void setMapStyleOptions(GeospatialMapStyleOptions.BuilderImpl mapStyleOptions) {
            this.mapStyleOptions = mapStyleOptions != null ? mapStyleOptions.build() : null;
        }

        @Override
        public final Builder mapStyleOptions(GeospatialMapStyleOptions mapStyleOptions) {
            this.mapStyleOptions = mapStyleOptions;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public FilledMapConfiguration build() {
            return new FilledMapConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
