/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The QA result that is made from dashboard visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVisualResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVisualResult.Builder, DashboardVisualResult> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DashboardVisualResult::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardName").getter(getter(DashboardVisualResult::dashboardName))
            .setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()).build();

    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(DashboardVisualResult::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> SHEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetName").getter(getter(DashboardVisualResult::sheetName)).setter(setter(Builder::sheetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetName").build()).build();

    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(DashboardVisualResult::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<String> VISUAL_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualTitle").getter(getter(DashboardVisualResult::visualTitle)).setter(setter(Builder::visualTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualTitle").build()).build();

    private static final SdkField<String> VISUAL_SUBTITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualSubtitle").getter(getter(DashboardVisualResult::visualSubtitle))
            .setter(setter(Builder::visualSubtitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualSubtitle").build()).build();

    private static final SdkField<String> DASHBOARD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardUrl").getter(getter(DashboardVisualResult::dashboardUrl)).setter(setter(Builder::dashboardUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            DASHBOARD_NAME_FIELD, SHEET_ID_FIELD, SHEET_NAME_FIELD, VISUAL_ID_FIELD, VISUAL_TITLE_FIELD, VISUAL_SUBTITLE_FIELD,
            DASHBOARD_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dashboardId;

    private final String dashboardName;

    private final String sheetId;

    private final String sheetName;

    private final String visualId;

    private final String visualTitle;

    private final String visualSubtitle;

    private final String dashboardUrl;

    private DashboardVisualResult(BuilderImpl builder) {
        this.dashboardId = builder.dashboardId;
        this.dashboardName = builder.dashboardName;
        this.sheetId = builder.sheetId;
        this.sheetName = builder.sheetName;
        this.visualId = builder.visualId;
        this.visualTitle = builder.visualTitle;
        this.visualSubtitle = builder.visualSubtitle;
        this.dashboardUrl = builder.dashboardUrl;
    }

    /**
     * <p>
     * The ID of the dashboard.
     * </p>
     * 
     * @return The ID of the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public final String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * The ID of the sheet.
     * </p>
     * 
     * @return The ID of the sheet.
     */
    public final String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The name of the sheet.
     * </p>
     * 
     * @return The name of the sheet.
     */
    public final String sheetName() {
        return sheetName;
    }

    /**
     * <p>
     * The ID of the visual.
     * </p>
     * 
     * @return The ID of the visual.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * <p>
     * The title of the visual.
     * </p>
     * 
     * @return The title of the visual.
     */
    public final String visualTitle() {
        return visualTitle;
    }

    /**
     * <p>
     * The subtitle of the visual.
     * </p>
     * 
     * @return The subtitle of the visual.
     */
    public final String visualSubtitle() {
        return visualSubtitle;
    }

    /**
     * <p>
     * The URL of the dashboard.
     * </p>
     * 
     * @return The URL of the dashboard.
     */
    public final String dashboardUrl() {
        return dashboardUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(sheetName());
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(visualTitle());
        hashCode = 31 * hashCode + Objects.hashCode(visualSubtitle());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVisualResult)) {
            return false;
        }
        DashboardVisualResult other = (DashboardVisualResult) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(dashboardName(), other.dashboardName())
                && Objects.equals(sheetId(), other.sheetId()) && Objects.equals(sheetName(), other.sheetName())
                && Objects.equals(visualId(), other.visualId()) && Objects.equals(visualTitle(), other.visualTitle())
                && Objects.equals(visualSubtitle(), other.visualSubtitle())
                && Objects.equals(dashboardUrl(), other.dashboardUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardVisualResult").add("DashboardId", dashboardId()).add("DashboardName", dashboardName())
                .add("SheetId", sheetId()).add("SheetName", sheetName()).add("VisualId", visualId())
                .add("VisualTitle", visualTitle()).add("VisualSubtitle", visualSubtitle()).add("DashboardUrl", dashboardUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "DashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "SheetName":
            return Optional.ofNullable(clazz.cast(sheetName()));
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "VisualTitle":
            return Optional.ofNullable(clazz.cast(visualTitle()));
        case "VisualSubtitle":
            return Optional.ofNullable(clazz.cast(visualSubtitle()));
        case "DashboardUrl":
            return Optional.ofNullable(clazz.cast(dashboardUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("DashboardName", DASHBOARD_NAME_FIELD);
        map.put("SheetId", SHEET_ID_FIELD);
        map.put("SheetName", SHEET_NAME_FIELD);
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("VisualTitle", VISUAL_TITLE_FIELD);
        map.put("VisualSubtitle", VISUAL_SUBTITLE_FIELD);
        map.put("DashboardUrl", DASHBOARD_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardVisualResult, T> g) {
        return obj -> g.apply((DashboardVisualResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVisualResult> {
        /**
         * <p>
         * The ID of the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * The ID of the sheet.
         * </p>
         * 
         * @param sheetId
         *        The ID of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The name of the sheet.
         * </p>
         * 
         * @param sheetName
         *        The name of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetName(String sheetName);

        /**
         * <p>
         * The ID of the visual.
         * </p>
         * 
         * @param visualId
         *        The ID of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * <p>
         * The title of the visual.
         * </p>
         * 
         * @param visualTitle
         *        The title of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualTitle(String visualTitle);

        /**
         * <p>
         * The subtitle of the visual.
         * </p>
         * 
         * @param visualSubtitle
         *        The subtitle of the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualSubtitle(String visualSubtitle);

        /**
         * <p>
         * The URL of the dashboard.
         * </p>
         * 
         * @param dashboardUrl
         *        The URL of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardUrl(String dashboardUrl);
    }

    static final class BuilderImpl implements Builder {
        private String dashboardId;

        private String dashboardName;

        private String sheetId;

        private String sheetName;

        private String visualId;

        private String visualTitle;

        private String visualSubtitle;

        private String dashboardUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVisualResult model) {
            dashboardId(model.dashboardId);
            dashboardName(model.dashboardName);
            sheetId(model.sheetId);
            sheetName(model.sheetName);
            visualId(model.visualId);
            visualTitle(model.visualTitle);
            visualSubtitle(model.visualSubtitle);
            dashboardUrl(model.dashboardUrl);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final String getSheetId() {
            return sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getSheetName() {
            return sheetName;
        }

        public final void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        @Override
        public final Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getVisualTitle() {
            return visualTitle;
        }

        public final void setVisualTitle(String visualTitle) {
            this.visualTitle = visualTitle;
        }

        @Override
        public final Builder visualTitle(String visualTitle) {
            this.visualTitle = visualTitle;
            return this;
        }

        public final String getVisualSubtitle() {
            return visualSubtitle;
        }

        public final void setVisualSubtitle(String visualSubtitle) {
            this.visualSubtitle = visualSubtitle;
        }

        @Override
        public final Builder visualSubtitle(String visualSubtitle) {
            this.visualSubtitle = visualSubtitle;
            return this;
        }

        public final String getDashboardUrl() {
            return dashboardUrl;
        }

        public final void setDashboardUrl(String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
        }

        @Override
        public final Builder dashboardUrl(String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @Override
        public DashboardVisualResult build() {
            return new DashboardVisualResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
