/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Instructions that provide additional guidance and context for response generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomInstructions implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomInstructions.Builder, CustomInstructions> {
    private static final SdkField<String> CUSTOM_INSTRUCTIONS_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomInstructionsString").getter(getter(CustomInstructions::customInstructionsString))
            .setter(setter(Builder::customInstructionsString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomInstructionsString").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_INSTRUCTIONS_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customInstructionsString;

    private CustomInstructions(BuilderImpl builder) {
        this.customInstructionsString = builder.customInstructionsString;
    }

    /**
     * <p>
     * A text field for providing additional guidance or context for response generation.
     * </p>
     * 
     * @return A text field for providing additional guidance or context for response generation.
     */
    public final String customInstructionsString() {
        return customInstructionsString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customInstructionsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomInstructions)) {
            return false;
        }
        CustomInstructions other = (CustomInstructions) obj;
        return Objects.equals(customInstructionsString(), other.customInstructionsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomInstructions")
                .add("CustomInstructionsString", customInstructionsString() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomInstructionsString":
            return Optional.ofNullable(clazz.cast(customInstructionsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomInstructionsString", CUSTOM_INSTRUCTIONS_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomInstructions, T> g) {
        return obj -> g.apply((CustomInstructions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomInstructions> {
        /**
         * <p>
         * A text field for providing additional guidance or context for response generation.
         * </p>
         * 
         * @param customInstructionsString
         *        A text field for providing additional guidance or context for response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstructionsString(String customInstructionsString);
    }

    static final class BuilderImpl implements Builder {
        private String customInstructionsString;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomInstructions model) {
            customInstructionsString(model.customInstructionsString);
        }

        public final String getCustomInstructionsString() {
            return customInstructionsString;
        }

        public final void setCustomInstructionsString(String customInstructionsString) {
            this.customInstructionsString = customInstructionsString;
        }

        @Override
        public final Builder customInstructionsString(String customInstructionsString) {
            this.customInstructionsString = customInstructionsString;
            return this;
        }

        @Override
        public CustomInstructions build() {
            return new CustomInstructions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
