/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration for a column that is not used in a field well.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnSort implements SdkPojo, Serializable, ToCopyableBuilder<ColumnSort.Builder, ColumnSort> {
    private static final SdkField<ColumnIdentifier> SORT_BY_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(ColumnSort::sortBy)).setter(setter(Builder::sortBy))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(ColumnSort::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<AggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<AggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(ColumnSort::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(AggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD,
            DIRECTION_FIELD, AGGREGATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnIdentifier sortBy;

    private final String direction;

    private final AggregationFunction aggregationFunction;

    private ColumnSort(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.direction = builder.direction;
        this.aggregationFunction = builder.aggregationFunction;
    }

    /**
     * Returns the value of the SortBy property for this object.
     * 
     * @return The value of the SortBy property for this object.
     */
    public final ColumnIdentifier sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The sort direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction.
     * @see SortDirection
     */
    public final SortDirection direction() {
        return SortDirection.fromValue(direction);
    }

    /**
     * <p>
     * The sort direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link SortDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return The sort direction.
     * @see SortDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The aggregation function that is defined in the column sort.
     * </p>
     * 
     * @return The aggregation function that is defined in the column sort.
     */
    public final AggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnSort)) {
            return false;
        }
        ColumnSort other = (ColumnSort) obj;
        return Objects.equals(sortBy(), other.sortBy()) && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(aggregationFunction(), other.aggregationFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnSort").add("SortBy", sortBy()).add("Direction", directionAsString())
                .add("AggregationFunction", aggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SortBy", SORT_BY_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnSort, T> g) {
        return obj -> g.apply((ColumnSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnSort> {
        /**
         * Sets the value of the SortBy property for this object.
         *
         * @param sortBy
         *        The new value for the SortBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(ColumnIdentifier sortBy);

        /**
         * Sets the value of the SortBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(ColumnIdentifier)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(ColumnIdentifier)
         */
        default Builder sortBy(Consumer<ColumnIdentifier.Builder> sortBy) {
            return sortBy(ColumnIdentifier.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * The sort direction.
         * </p>
         * 
         * @param direction
         *        The sort direction.
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * The sort direction.
         * </p>
         * 
         * @param direction
         *        The sort direction.
         * @see SortDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortDirection
         */
        Builder direction(SortDirection direction);

        /**
         * <p>
         * The aggregation function that is defined in the column sort.
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function that is defined in the column sort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(AggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function that is defined in the column sort.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationFunction.Builder} avoiding the
         * need to create one manually via {@link AggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregationFunction(AggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link AggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(AggregationFunction)
         */
        default Builder aggregationFunction(Consumer<AggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(AggregationFunction.builder().applyMutation(aggregationFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnIdentifier sortBy;

        private String direction;

        private AggregationFunction aggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnSort model) {
            sortBy(model.sortBy);
            direction(model.direction);
            aggregationFunction(model.aggregationFunction);
        }

        public final ColumnIdentifier.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(ColumnIdentifier.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(ColumnIdentifier sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(SortDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final AggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(AggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(AggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public ColumnSort build() {
            return new ColumnSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
