/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfo;
import software.amazon.awssdk.services.quicksight.model.SnapshotJobResultErrorInfoListCopier;
import software.amazon.awssdk.services.quicksight.model.SnapshotS3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotJobS3Result
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotJobS3Result> {
    private static final SdkField<SnapshotS3DestinationConfiguration> S3_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationConfiguration").getter(SnapshotJobS3Result.getter(SnapshotJobS3Result::s3DestinationConfiguration)).setter(SnapshotJobS3Result.setter(Builder::s3DestinationConfiguration)).constructor(SnapshotS3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationConfiguration").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(SnapshotJobS3Result.getter(SnapshotJobS3Result::s3Uri)).setter(SnapshotJobS3Result.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<List<SnapshotJobResultErrorInfo>> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorInfo").getter(SnapshotJobS3Result.getter(SnapshotJobS3Result::errorInfo)).setter(SnapshotJobS3Result.setter(Builder::errorInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotJobResultErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DESTINATION_CONFIGURATION_FIELD, S3_URI_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnapshotJobS3Result.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SnapshotS3DestinationConfiguration s3DestinationConfiguration;
    private final String s3Uri;
    private final List<SnapshotJobResultErrorInfo> errorInfo;

    private SnapshotJobS3Result(BuilderImpl builder) {
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.s3Uri = builder.s3Uri;
        this.errorInfo = builder.errorInfo;
    }

    public final SnapshotS3DestinationConfiguration s3DestinationConfiguration() {
        return this.s3DestinationConfiguration;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final boolean hasErrorInfo() {
        return this.errorInfo != null && !(this.errorInfo instanceof SdkAutoConstructList);
    }

    public final List<SnapshotJobResultErrorInfo> errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorInfo() ? this.errorInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotJobS3Result)) {
            return false;
        }
        SnapshotJobS3Result other = (SnapshotJobS3Result)obj;
        return Objects.equals(this.s3DestinationConfiguration(), other.s3DestinationConfiguration()) && Objects.equals(this.s3Uri(), other.s3Uri()) && this.hasErrorInfo() == other.hasErrorInfo() && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotJobS3Result").add("S3DestinationConfiguration", (Object)this.s3DestinationConfiguration()).add("S3Uri", (Object)(this.s3Uri() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorInfo", this.hasErrorInfo() ? this.errorInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3DestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationConfiguration()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3DestinationConfiguration", S3_DESTINATION_CONFIGURATION_FIELD);
        map.put("S3Uri", S3_URI_FIELD);
        map.put("ErrorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotJobS3Result, T> g) {
        return obj -> g.apply((SnapshotJobS3Result)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SnapshotS3DestinationConfiguration s3DestinationConfiguration;
        private String s3Uri;
        private List<SnapshotJobResultErrorInfo> errorInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotJobS3Result model) {
            this.s3DestinationConfiguration(model.s3DestinationConfiguration);
            this.s3Uri(model.s3Uri);
            this.errorInfo(model.errorInfo);
        }

        public final SnapshotS3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.toBuilder() : null;
        }

        public final void setS3DestinationConfiguration(SnapshotS3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(SnapshotS3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final List<SnapshotJobResultErrorInfo.Builder> getErrorInfo() {
            List<SnapshotJobResultErrorInfo.Builder> result = SnapshotJobResultErrorInfoListCopier.copyToBuilder(this.errorInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorInfo(Collection<SnapshotJobResultErrorInfo.BuilderImpl> errorInfo) {
            this.errorInfo = SnapshotJobResultErrorInfoListCopier.copyFromBuilder(errorInfo);
        }

        @Override
        public final Builder errorInfo(Collection<SnapshotJobResultErrorInfo> errorInfo) {
            this.errorInfo = SnapshotJobResultErrorInfoListCopier.copy(errorInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(SnapshotJobResultErrorInfo ... errorInfo) {
            this.errorInfo(Arrays.asList(errorInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorInfo(Consumer<SnapshotJobResultErrorInfo.Builder> ... errorInfo) {
            this.errorInfo(Stream.of(errorInfo).map(c -> (SnapshotJobResultErrorInfo)((SnapshotJobResultErrorInfo.Builder)SnapshotJobResultErrorInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SnapshotJobS3Result build() {
            return new SnapshotJobS3Result(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotJobS3Result> {
        public Builder s3DestinationConfiguration(SnapshotS3DestinationConfiguration var1);

        default public Builder s3DestinationConfiguration(Consumer<SnapshotS3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return this.s3DestinationConfiguration((SnapshotS3DestinationConfiguration)((SnapshotS3DestinationConfiguration.Builder)SnapshotS3DestinationConfiguration.builder().applyMutation(s3DestinationConfiguration)).build());
        }

        public Builder s3Uri(String var1);

        public Builder errorInfo(Collection<SnapshotJobResultErrorInfo> var1);

        public Builder errorInfo(SnapshotJobResultErrorInfo ... var1);

        public Builder errorInfo(Consumer<SnapshotJobResultErrorInfo.Builder> ... var1);
    }
}

