/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWell;
import software.amazon.awssdk.services.quicksight.model.PluginVisualFieldWellsCopier;
import software.amazon.awssdk.services.quicksight.model.PluginVisualOptions;
import software.amazon.awssdk.services.quicksight.model.PluginVisualSortConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginVisualConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginVisualConfiguration> {
    private static final SdkField<List<PluginVisualFieldWell>> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldWells").getter(PluginVisualConfiguration.getter(PluginVisualConfiguration::fieldWells)).setter(PluginVisualConfiguration.setter(Builder::fieldWells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PluginVisualFieldWell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PluginVisualOptions> VISUAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualOptions").getter(PluginVisualConfiguration.getter(PluginVisualConfiguration::visualOptions)).setter(PluginVisualConfiguration.setter(Builder::visualOptions)).constructor(PluginVisualOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualOptions").build()}).build();
    private static final SdkField<PluginVisualSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(PluginVisualConfiguration.getter(PluginVisualConfiguration::sortConfiguration)).setter(PluginVisualConfiguration.setter(Builder::sortConfiguration)).constructor(PluginVisualSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, VISUAL_OPTIONS_FIELD, SORT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PluginVisualConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PluginVisualFieldWell> fieldWells;
    private final PluginVisualOptions visualOptions;
    private final PluginVisualSortConfiguration sortConfiguration;

    private PluginVisualConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.visualOptions = builder.visualOptions;
        this.sortConfiguration = builder.sortConfiguration;
    }

    public final boolean hasFieldWells() {
        return this.fieldWells != null && !(this.fieldWells instanceof SdkAutoConstructList);
    }

    public final List<PluginVisualFieldWell> fieldWells() {
        return this.fieldWells;
    }

    public final PluginVisualOptions visualOptions() {
        return this.visualOptions;
    }

    public final PluginVisualSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldWells() ? this.fieldWells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.visualOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisualConfiguration)) {
            return false;
        }
        PluginVisualConfiguration other = (PluginVisualConfiguration)obj;
        return this.hasFieldWells() == other.hasFieldWells() && Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.visualOptions(), other.visualOptions()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PluginVisualConfiguration").add("FieldWells", this.hasFieldWells() ? this.fieldWells() : null).add("VisualOptions", (Object)this.visualOptions()).add("SortConfiguration", (Object)this.sortConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "VisualOptions": {
                return Optional.ofNullable(clazz.cast(this.visualOptions()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("VisualOptions", VISUAL_OPTIONS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisualConfiguration, T> g) {
        return obj -> g.apply((PluginVisualConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PluginVisualFieldWell> fieldWells = DefaultSdkAutoConstructList.getInstance();
        private PluginVisualOptions visualOptions;
        private PluginVisualSortConfiguration sortConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisualConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.visualOptions(model.visualOptions);
            this.sortConfiguration(model.sortConfiguration);
        }

        public final List<PluginVisualFieldWell.Builder> getFieldWells() {
            List<PluginVisualFieldWell.Builder> result = PluginVisualFieldWellsCopier.copyToBuilder(this.fieldWells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldWells(Collection<PluginVisualFieldWell.BuilderImpl> fieldWells) {
            this.fieldWells = PluginVisualFieldWellsCopier.copyFromBuilder(fieldWells);
        }

        @Override
        public final Builder fieldWells(Collection<PluginVisualFieldWell> fieldWells) {
            this.fieldWells = PluginVisualFieldWellsCopier.copy(fieldWells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldWells(PluginVisualFieldWell ... fieldWells) {
            this.fieldWells(Arrays.asList(fieldWells));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldWells(Consumer<PluginVisualFieldWell.Builder> ... fieldWells) {
            this.fieldWells(Stream.of(fieldWells).map(c -> (PluginVisualFieldWell)((PluginVisualFieldWell.Builder)PluginVisualFieldWell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PluginVisualOptions.Builder getVisualOptions() {
            return this.visualOptions != null ? this.visualOptions.toBuilder() : null;
        }

        public final void setVisualOptions(PluginVisualOptions.BuilderImpl visualOptions) {
            this.visualOptions = visualOptions != null ? visualOptions.build() : null;
        }

        @Override
        public final Builder visualOptions(PluginVisualOptions visualOptions) {
            this.visualOptions = visualOptions;
            return this;
        }

        public final PluginVisualSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(PluginVisualSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(PluginVisualSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public PluginVisualConfiguration build() {
            return new PluginVisualConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginVisualConfiguration> {
        public Builder fieldWells(Collection<PluginVisualFieldWell> var1);

        public Builder fieldWells(PluginVisualFieldWell ... var1);

        public Builder fieldWells(Consumer<PluginVisualFieldWell.Builder> ... var1);

        public Builder visualOptions(PluginVisualOptions var1);

        default public Builder visualOptions(Consumer<PluginVisualOptions.Builder> visualOptions) {
            return this.visualOptions((PluginVisualOptions)((PluginVisualOptions.Builder)PluginVisualOptions.builder().applyMutation(visualOptions)).build());
        }

        public Builder sortConfiguration(PluginVisualSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<PluginVisualSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((PluginVisualSortConfiguration)((PluginVisualSortConfiguration.Builder)PluginVisualSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }
    }
}

