/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DecimalDatasetParameterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecimalDatasetParameterDefaultValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DecimalDatasetParameterDefaultValues> {
    private static final SdkField<List<Double>> STATIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaticValues").getter(DecimalDatasetParameterDefaultValues.getter(DecimalDatasetParameterDefaultValues::staticValues)).setter(DecimalDatasetParameterDefaultValues.setter(Builder::staticValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecimalDatasetParameterDefaultValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> staticValues;

    private DecimalDatasetParameterDefaultValues(BuilderImpl builder) {
        this.staticValues = builder.staticValues;
    }

    public final boolean hasStaticValues() {
        return this.staticValues != null && !(this.staticValues instanceof SdkAutoConstructList);
    }

    public final List<Double> staticValues() {
        return this.staticValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticValues() ? this.staticValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalDatasetParameterDefaultValues)) {
            return false;
        }
        DecimalDatasetParameterDefaultValues other = (DecimalDatasetParameterDefaultValues)obj;
        return this.hasStaticValues() == other.hasStaticValues() && Objects.equals(this.staticValues(), other.staticValues());
    }

    public final String toString() {
        return ToString.builder((String)"DecimalDatasetParameterDefaultValues").add("StaticValues", this.hasStaticValues() ? this.staticValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StaticValues": {
                return Optional.ofNullable(clazz.cast(this.staticValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Double>>> map = new HashMap<String, SdkField<List<Double>>>();
        map.put("StaticValues", STATIC_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecimalDatasetParameterDefaultValues, T> g) {
        return obj -> g.apply((DecimalDatasetParameterDefaultValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> staticValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalDatasetParameterDefaultValues model) {
            this.staticValues(model.staticValues);
        }

        public final Collection<Double> getStaticValues() {
            if (this.staticValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.staticValues;
        }

        public final void setStaticValues(Collection<Double> staticValues) {
            this.staticValues = DecimalDatasetParameterValueListCopier.copy(staticValues);
        }

        @Override
        public final Builder staticValues(Collection<Double> staticValues) {
            this.staticValues = DecimalDatasetParameterValueListCopier.copy(staticValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticValues(Double ... staticValues) {
            this.staticValues(Arrays.asList(staticValues));
            return this;
        }

        public DecimalDatasetParameterDefaultValues build() {
            return new DecimalDatasetParameterDefaultValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecimalDatasetParameterDefaultValues> {
        public Builder staticValues(Collection<Double> var1);

        public Builder staticValues(Double ... var1);
    }
}

