/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TwitterParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TwitterParameters> {
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Query").getter(TwitterParameters.getter(TwitterParameters::query)).setter(TwitterParameters.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()}).build();
    private static final SdkField<Integer> MAX_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRows").getter(TwitterParameters.getter(TwitterParameters::maxRows)).setter(TwitterParameters.setter(Builder::maxRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, MAX_ROWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TwitterParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String query;
    private final Integer maxRows;

    private TwitterParameters(BuilderImpl builder) {
        this.query = builder.query;
        this.maxRows = builder.maxRows;
    }

    public final String query() {
        return this.query;
    }

    public final Integer maxRows() {
        return this.maxRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRows());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TwitterParameters)) {
            return false;
        }
        TwitterParameters other = (TwitterParameters)obj;
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.maxRows(), other.maxRows());
    }

    public final String toString() {
        return ToString.builder((String)"TwitterParameters").add("Query", (Object)this.query()).add("MaxRows", (Object)this.maxRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "MaxRows": {
                return Optional.ofNullable(clazz.cast(this.maxRows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Query", QUERY_FIELD);
        map.put("MaxRows", MAX_ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TwitterParameters, T> g) {
        return obj -> g.apply((TwitterParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String query;
        private Integer maxRows;

        private BuilderImpl() {
        }

        private BuilderImpl(TwitterParameters model) {
            this.query(model.query);
            this.maxRows(model.maxRows);
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final Integer getMaxRows() {
            return this.maxRows;
        }

        public final void setMaxRows(Integer maxRows) {
            this.maxRows = maxRows;
        }

        @Override
        public final Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public TwitterParameters build() {
            return new TwitterParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TwitterParameters> {
        public Builder query(String var1);

        public Builder maxRows(Integer var1);
    }
}

