/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BinCountOptions;
import software.amazon.awssdk.services.quicksight.model.BinWidthOptions;
import software.amazon.awssdk.services.quicksight.model.HistogramBinType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistogramBinOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistogramBinOptions> {
    private static final SdkField<String> SELECTED_BIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectedBinType").getter(HistogramBinOptions.getter(HistogramBinOptions::selectedBinTypeAsString)).setter(HistogramBinOptions.setter(Builder::selectedBinType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedBinType").build()}).build();
    private static final SdkField<BinCountOptions> BIN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BinCount").getter(HistogramBinOptions.getter(HistogramBinOptions::binCount)).setter(HistogramBinOptions.setter(Builder::binCount)).constructor(BinCountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinCount").build()}).build();
    private static final SdkField<BinWidthOptions> BIN_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BinWidth").getter(HistogramBinOptions.getter(HistogramBinOptions::binWidth)).setter(HistogramBinOptions.setter(Builder::binWidth)).constructor(BinWidthOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinWidth").build()}).build();
    private static final SdkField<Double> START_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartValue").getter(HistogramBinOptions.getter(HistogramBinOptions::startValue)).setter(HistogramBinOptions.setter(Builder::startValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_BIN_TYPE_FIELD, BIN_COUNT_FIELD, BIN_WIDTH_FIELD, START_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HistogramBinOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String selectedBinType;
    private final BinCountOptions binCount;
    private final BinWidthOptions binWidth;
    private final Double startValue;

    private HistogramBinOptions(BuilderImpl builder) {
        this.selectedBinType = builder.selectedBinType;
        this.binCount = builder.binCount;
        this.binWidth = builder.binWidth;
        this.startValue = builder.startValue;
    }

    public final HistogramBinType selectedBinType() {
        return HistogramBinType.fromValue(this.selectedBinType);
    }

    public final String selectedBinTypeAsString() {
        return this.selectedBinType;
    }

    public final BinCountOptions binCount() {
        return this.binCount;
    }

    public final BinWidthOptions binWidth() {
        return this.binWidth;
    }

    public final Double startValue() {
        return this.startValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedBinTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.binCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.binWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.startValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramBinOptions)) {
            return false;
        }
        HistogramBinOptions other = (HistogramBinOptions)obj;
        return Objects.equals(this.selectedBinTypeAsString(), other.selectedBinTypeAsString()) && Objects.equals(this.binCount(), other.binCount()) && Objects.equals(this.binWidth(), other.binWidth()) && Objects.equals(this.startValue(), other.startValue());
    }

    public final String toString() {
        return ToString.builder((String)"HistogramBinOptions").add("SelectedBinType", (Object)this.selectedBinTypeAsString()).add("BinCount", (Object)this.binCount()).add("BinWidth", (Object)this.binWidth()).add("StartValue", (Object)this.startValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedBinType": {
                return Optional.ofNullable(clazz.cast(this.selectedBinTypeAsString()));
            }
            case "BinCount": {
                return Optional.ofNullable(clazz.cast(this.binCount()));
            }
            case "BinWidth": {
                return Optional.ofNullable(clazz.cast(this.binWidth()));
            }
            case "StartValue": {
                return Optional.ofNullable(clazz.cast(this.startValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SelectedBinType", SELECTED_BIN_TYPE_FIELD);
        map.put("BinCount", BIN_COUNT_FIELD);
        map.put("BinWidth", BIN_WIDTH_FIELD);
        map.put("StartValue", START_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistogramBinOptions, T> g) {
        return obj -> g.apply((HistogramBinOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectedBinType;
        private BinCountOptions binCount;
        private BinWidthOptions binWidth;
        private Double startValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HistogramBinOptions model) {
            this.selectedBinType(model.selectedBinType);
            this.binCount(model.binCount);
            this.binWidth(model.binWidth);
            this.startValue(model.startValue);
        }

        public final String getSelectedBinType() {
            return this.selectedBinType;
        }

        public final void setSelectedBinType(String selectedBinType) {
            this.selectedBinType = selectedBinType;
        }

        @Override
        public final Builder selectedBinType(String selectedBinType) {
            this.selectedBinType = selectedBinType;
            return this;
        }

        @Override
        public final Builder selectedBinType(HistogramBinType selectedBinType) {
            this.selectedBinType(selectedBinType == null ? null : selectedBinType.toString());
            return this;
        }

        public final BinCountOptions.Builder getBinCount() {
            return this.binCount != null ? this.binCount.toBuilder() : null;
        }

        public final void setBinCount(BinCountOptions.BuilderImpl binCount) {
            this.binCount = binCount != null ? binCount.build() : null;
        }

        @Override
        public final Builder binCount(BinCountOptions binCount) {
            this.binCount = binCount;
            return this;
        }

        public final BinWidthOptions.Builder getBinWidth() {
            return this.binWidth != null ? this.binWidth.toBuilder() : null;
        }

        public final void setBinWidth(BinWidthOptions.BuilderImpl binWidth) {
            this.binWidth = binWidth != null ? binWidth.build() : null;
        }

        @Override
        public final Builder binWidth(BinWidthOptions binWidth) {
            this.binWidth = binWidth;
            return this;
        }

        public final Double getStartValue() {
            return this.startValue;
        }

        public final void setStartValue(Double startValue) {
            this.startValue = startValue;
        }

        @Override
        public final Builder startValue(Double startValue) {
            this.startValue = startValue;
            return this;
        }

        public HistogramBinOptions build() {
            return new HistogramBinOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistogramBinOptions> {
        public Builder selectedBinType(String var1);

        public Builder selectedBinType(HistogramBinType var1);

        public Builder binCount(BinCountOptions var1);

        default public Builder binCount(Consumer<BinCountOptions.Builder> binCount) {
            return this.binCount((BinCountOptions)((BinCountOptions.Builder)BinCountOptions.builder().applyMutation(binCount)).build());
        }

        public Builder binWidth(BinWidthOptions var1);

        default public Builder binWidth(Consumer<BinWidthOptions.Builder> binWidth) {
            return this.binWidth((BinWidthOptions)((BinWidthOptions.Builder)BinWidthOptions.builder().applyMutation(binWidth)).build());
        }

        public Builder startValue(Double var1);
    }
}

